/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.ADFLogger;

public class PerUserLogger
extends ADFLogger {
    public static final String USER_ID = "userId";
    private static final String ANON_USER = "anonymous";
    private static final int offValue = Level.OFF.intValue();
    private static final Map<String, Map<String, Integer>> allUsers = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Context context;

    public static PerUserLogger getLogger(String name, String bundleName, Context context) {
        return new Builder(name, bundleName, context).build();
    }

    private PerUserLogger(Logger logger, String clazzName, Context context) {
        super(logger, clazzName);
        this.context = context;
        if (context.get(USER_ID) == null) {
            context.put(USER_ID, ANON_USER);
        }
        ((PlatformWrapLogger)logger).outer = this;
    }

    protected FilterReply isUserLoggable(Level level) {
        return this.isUserLoggable(level, this.getName());
    }

    protected FilterReply isUserLoggable(Level level, String loggerName) {
        String key = this.getUserIdKey(this.context.get(USER_ID));
        Map<String, Integer> userLoggers = allUsers.get(key);
        if (userLoggers == null || userLoggers.size() < 1) {
            return FilterReply.NEUTRAL;
        }
        String nm = loggerName;
        while (nm != null) {
            Integer levelValue = userLoggers.get(nm);
            if (levelValue != null) {
                if (offValue == levelValue || level.intValue() < levelValue) {
                    return FilterReply.DENY;
                }
                return FilterReply.ACCEPT;
            }
            nm = this.subtractLeaf(nm);
        }
        return FilterReply.NEUTRAL;
    }

    private final String subtractLeaf(String nm) {
        int lx = nm.lastIndexOf(46);
        return lx == -1 ? null : nm.substring(0, lx);
    }

    private final String getUserIdKey(Object userId) {
        if (userId == null) {
            return ANON_USER;
        }
        return String.valueOf(userId).toLowerCase();
    }

    public void setUserLevel(Level level) {
        this.setUserLevel(level, this.getName());
    }

    public void setUserLevel(Level level, String loggerName) {
        Integer newValue = level == null ? offValue : level.intValue();
        String userIdKey = this.getUserIdKey(this.context.get(USER_ID));
        Map<String, Integer> userLoggers = allUsers.get(userIdKey);
        if (userLoggers == null) {
            allUsers.put(userIdKey, new ConcurrentHashMap(2));
            userLoggers = allUsers.get(userIdKey);
        }
        userLoggers.put(loggerName, newValue);
    }

    public void clearUser() {
        allUsers.remove(this.getUserIdKey(this.context.get(USER_ID)));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PerUserLogger) {
            PerUserLogger rhs = (PerUserLogger)obj;
            return rhs.getName().equals(this.getName()) && this.getUserIdKey(rhs.context.get(USER_ID)).equals(this.getUserIdKey(this.context.get(USER_ID)));
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getUserIdKey(this.context.get(USER_ID)).hashCode();
    }

    private static class PlatformWrapLogger
    extends Logger {
        private final Logger wrapped;
        private PerUserLogger outer;

        public PlatformWrapLogger(Logger wrapped) {
            super(wrapped.getName(), wrapped.getResourceBundleName());
            this.wrapped = wrapped;
        }

        @Override
        public void addHandler(Handler handler) throws SecurityException {
            this.wrapped.addHandler(handler);
        }

        @Override
        public boolean isLoggable(Level level) {
            FilterReply fr = this.outer.isUserLoggable(level);
            if (fr == FilterReply.DENY) {
                return false;
            }
            if (fr == FilterReply.ACCEPT) {
                return true;
            }
            return this.wrapped.isLoggable(level);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(LogRecord rec) {
            Level recLevel = rec.getLevel();
            FilterReply fr = this.outer.isUserLoggable(recLevel);
            if (fr == FilterReply.DENY) {
                return;
            }
            if (fr == FilterReply.ACCEPT) {
                Level oldLevel = this.wrapped.getLevel();
                try {
                    this.wrapped.setLevel(recLevel);
                    rec.setMessage(this.getContextString(this.outer.context) + rec.getMessage());
                    this.wrapped.log(rec);
                }
                finally {
                    this.wrapped.setLevel(oldLevel);
                }
            } else if (this.wrapped.isLoggable(recLevel)) {
                rec.setMessage(this.getContextString(this.outer.context) + rec.getMessage());
                this.wrapped.log(rec);
            }
        }

        private String getContextString(LinkedHashMap<String, Object> context) {
            if (context.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, Object> ent : context.entrySet()) {
                buf.append("[").append(ent.getKey()).append(": ").append(ent.getValue()).append("] ");
            }
            return buf.toString();
        }
    }

    public static class Builder
    extends ADFLogger.Builder {
        private final Context context;

        public Builder(String name, String bundleName, Context context) {
            super(name, bundleName);
            this.context = context;
            this.withClazzName(PerUserLogger.class.getName());
        }

        @Override
        public Logger getPlatformLogger() {
            return new PlatformWrapLogger(super.getPlatformLogger());
        }

        @Override
        public PerUserLogger build() {
            return new PerUserLogger(this.getPlatformLogger(), this.getClazzName(), this.context);
        }
    }

    public static class ContextBuilder {
        private final LinkedHashMap<String, Object> context = new LinkedHashMap(4);

        public ContextBuilder(Object userId) {
            this.context.put(PerUserLogger.USER_ID, userId == null ? PerUserLogger.ANON_USER : userId);
        }

        public ContextBuilder with(String key, Object value) {
            this.context.put(key, value);
            return this;
        }

        public Context build() {
            return new Context(this.context);
        }
    }

    public static class Context
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        public Context(LinkedHashMap<String, Object> map) {
            this.putAll(map);
        }
    }

    protected static enum FilterReply {
        DENY,
        NEUTRAL,
        ACCEPT;

    }
}

