/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common;

import oracle.adf.share.common.ThreadLocal;
import oracle.adf.share.common.ThreadLocalFactory;
import oracle.adf.share.common.ThreadLocalManager;
import oracle.adf.share.common.ThreadLocalValue;

class ThreadLocalFactoryJDK<T>
extends ThreadLocalFactory<T> {
    @Override
    public <T> ThreadLocal<T> newThreadLocal(ThreadLocalManager<T> mgr) {
        ThreadLocalManager m = mgr != null ? mgr : new ThreadLocalManager();
        Object nativeImpl = m.newNativeImpl();
        return new ThreadLocalJDK(m, nativeImpl != null ? (java.lang.ThreadLocal)nativeImpl : new java.lang.ThreadLocal());
    }

    private static class ThreadLocalJDK<T>
    implements ThreadLocal<T> {
        private final ThreadLocalManager<T> mgr;
        private final java.lang.ThreadLocal<ThreadLocalValue<T>> nativeTL;

        public ThreadLocalJDK(ThreadLocalManager<T> mgr, java.lang.ThreadLocal<ThreadLocalValue<T>> nativeTL) {
            this.mgr = mgr;
            this.nativeTL = nativeTL;
        }

        @Override
        public T get() {
            ThreadLocalValue<T> tlv = this.nativeTL.get();
            return tlv != null ? (T)tlv.t() : null;
        }

        @Override
        public void set(T t) {
            if (t != null) {
                this.nativeTL.set(new ThreadLocalValue<T>(t, this.mgr.newResetRunnable(t), this));
            } else {
                this.nativeTL.remove();
            }
        }

        @Override
        public void remove() {
            this.nativeTL.remove();
        }

        @Override
        public void resetValue() {
            block3: {
                ThreadLocalValue<T> tlv = this.nativeTL.get();
                if (tlv != null && tlv.r() != null) {
                    try {
                        tlv.r().run();
                    }
                    catch (Throwable t) {
                        if (!ThreadLocalFactory.Lazy.LOG.isInfo()) break block3;
                        ThreadLocalFactory.Lazy.LOG.info(tlv.toString(), t);
                    }
                }
            }
            this.remove();
        }
    }
}

