/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyEncryptionContext;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;

public class SimpleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public SimpleGeneratorHostKeyProvider() {
    }

    public SimpleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    /*
     * Loose catch block
     */
    @Override
    protected Iterable<KeyPair> doReadKeyPairs(SessionContext session, NamedResource resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
        OpenSSHKeyPairResourceParser reader;
        try (BufferedInputStream in = new BufferedInputStream(inputStream);){
            if (this.isJavaSerialization(in, resourceKey)) {
                try (ValidatingObjectInputStream r = new ValidatingObjectInputStream(in);){
                    List<KeyPair> list = Collections.singletonList((KeyPair)r.readObject());
                    return list;
                }
                {
                    catch (ClassNotFoundException e) {
                        throw new InvalidKeySpecException("Cannot de-serialize " + resourceKey + ": missing classes: " + e.getMessage(), e);
                    }
                }
            }
            reader = new OpenSSHKeyPairResourceParser();
        }
        Collection<KeyPair> collection = reader.loadKeyPairs(null, resourceKey, null, in);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJavaSerialization(BufferedInputStream in, NamedResource resourceKey) throws IOException {
        in.mark(2);
        try {
            byte[] magicBytes = new byte[2];
            int length = in.read(magicBytes);
            if (length != 2) {
                throw new StreamCorruptedException("File " + resourceKey + " is not a host key");
            }
            short magic = (short)((magicBytes[0] & 0xFF) << 8 | magicBytes[1] & 0xFF);
            boolean bl = magic == -21267;
            return bl;
        }
        finally {
            in.reset();
        }
    }

    @Override
    protected void doWriteKeyPair(NamedResource resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
        OpenSSHKeyPairResourceWriter writer = new OpenSSHKeyPairResourceWriter();
        try (OutputStream out = outputStream;){
            writer.writePrivateKey(kp, "host key", (OpenSSHKeyEncryptionContext)null, out);
        }
    }

    private static class ValidatingObjectInputStream
    extends ObjectInputStream {
        private static final Set<String> ALLOWED = new HashSet<String>();

        ValidatingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            this.validate(desc.getName());
            return super.resolveClass(desc);
        }

        private void validate(String className) throws IOException {
            if (!ALLOWED.contains(className)) {
                throw new IOException(className + " blocked for deserialization");
            }
        }

        static {
            ALLOWED.add("[B");
            ALLOWED.add("java.lang.Enum");
            ALLOWED.add("java.lang.Number");
            ALLOWED.add("java.lang.String");
            ALLOWED.add("java.math.BigInteger");
            ALLOWED.add("java.security.KeyPair");
            ALLOWED.add("java.security.PublicKey");
            ALLOWED.add("java.security.PrivateKey");
            ALLOWED.add("java.security.KeyRep");
            ALLOWED.add("java.security.KeyRep$Type");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey");
            ALLOWED.add("org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey");
            ALLOWED.add("com.android.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey");
        }
    }
}

