/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.util.Map;
import oracle.ide.dependency.index.IndexDeclaration;
import oracle.ide.dependency.index.IndexReference;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ide.index.QueryCriteria;
import oracle.ideimpl.dependency.index.DependencyCollector;

public abstract class DependencyIndexer
implements Indexer {
    private DataCollector data;
    private IndexingContext context;

    public void startIndexing(IndexingContext context) {
    }

    public void endIndexing(IndexingContext context) {
    }

    public void index(IndexingContext context, DataCollector data) {
        this.context = context;
        this.data = data;
        Object filterKey = context.getFilterKey();
        if (filterKey == null || "dependency.declaration".equals(filterKey) || "dependency.reference".equals(filterKey)) {
            this.indexDependencies(context);
        }
    }

    protected abstract void indexDependencies(IndexingContext var1);

    protected void addDeclaration(IndexDeclaration declaration) {
        Object filterKey = this.context.getFilterKey();
        if (filterKey == null || filterKey == "dependency.declaration") {
            if (this.data instanceof DependencyCollector) {
                ((DependencyCollector)this.data).addDeclaration(declaration);
            } else {
                this.addDependencyData(declaration.getQueryCriteria(), declaration.getStartOffset(), declaration.getEndOffset());
            }
        }
    }

    protected void addReference(IndexReference reference) {
        Object filterKey = this.context.getFilterKey();
        if (filterKey == null || filterKey == "dependency.reference") {
            if (this.data instanceof DependencyCollector) {
                ((DependencyCollector)this.data).addReference(reference);
            } else {
                this.addDependencyData(reference.getQueryCriteria(), reference.getStartOffset(), reference.getEndOffset());
            }
        }
    }

    private void addDependencyData(QueryCriteria criteria, int start, int end) {
        for (Map.Entry entry : criteria.entrySet()) {
            this.data.add((String)entry.getKey(), entry.getValue().hashCode(), 0, start, end);
        }
    }
}

