/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.awt.EventQueue;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DeclarationProvider;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclarationProvider;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.dependency.index.IndexIdDeclarationProvider;

public abstract class IdDeclaration
implements Declaration {
    protected String id;

    public static IdDeclaration findDeclaration(Context context, String id) throws InterruptedException {
        if (EventQueue.isDispatchThread() && !IdeUtil.isHeadless()) {
            throw new IllegalArgumentException("Cannot be called on event thread");
        }
        DependencyManager dm = DependencyManager.getDependencyManager();
        IdDeclarationProvider indexProvider = null;
        for (DeclarationProvider provider : dm.getDeclarationProviders()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!(provider instanceof IdDeclarationProvider)) continue;
            IdDeclarationProvider idp = (IdDeclarationProvider)provider;
            if (indexProvider == null && provider instanceof IndexIdDeclarationProvider) {
                indexProvider = idp;
                continue;
            }
            if (!idp.canGetDeclaration(context, id)) continue;
            return idp.getDeclaration(context, id);
        }
        if (indexProvider != null && indexProvider.canGetDeclaration(context, id)) {
            return indexProvider.getDeclaration(context, id);
        }
        return null;
    }

    public IdDeclaration(String id) {
        this.id = id;
    }

    public String getDeclarationId() {
        return this.id;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IdDeclaration) {
            IdDeclaration other = (IdDeclaration)object;
            return this.getDeclarationId().equals(other.getDeclarationId());
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclarationId().hashCode();
    }
}

