/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.QuickTraceHandlerFactory;
import oracle.core.ojdl.logging.QuickTraceHandlerMarker;
import oracle.core.ojdl.logging.context.ApplicationContext;
import oracle.core.ojdl.logging.context.UserContext;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.State;

public abstract class QuickTraceHandler
extends ODLHandler
implements GroupRefresh,
QuickTraceHandlerMarker {
    static final int DEFAULT_BUFFER_SIZE = 0x500000;
    static final int DEFAULT_FIELD_LEN = 240;
    static final String DEFAULT_DMS_METRICS = "true";
    static final String NOT_AVAILABLE = "N/A";
    static final int OFF = Level.OFF.intValue();
    static final String NOUNTYPE = "QuickTraceInfo";
    static final String DEFAULT_USER = "COMMON";
    static final String ST_OLDESTTIME = "oldestTimestamp";
    static final String ST_NUMRECIRD = "bufferRecordCount";
    static final String ST_BUFFERUSED = "bufferUsedPercentage";
    static final String ST_ELAPSED = "bufferElapsed";
    static final String TIME_STAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String USERID = "USERID";
    static final String APPS_USER_ID = "APPS_USER_NAME";
    private static AtomicInteger id_s = new AtomicInteger(0);
    protected Mode mode_;
    protected int id_;
    protected boolean closed_ = false;
    protected long bufferSize_;
    protected long specifiedBufferSize_;
    protected int fieldLen_;
    protected boolean useLoggingContext_ = false;
    protected int levelValue_;
    protected int sourceClassAndMethodLevelValue_;
    protected boolean enableDMSMetrics_;
    protected boolean useThreadName_;
    protected boolean useRealThreadId_;
    protected String path_;
    protected LogFormatter formatter_;
    protected ApplicationContext appContext_;
    protected UserContext userContext_;
    protected boolean enableUserBuffer_;
    protected boolean flushOnDump_;
    protected String[] reserveBufferIDs_;
    private SimpleDateFormat dateFormat_;
    protected QuickTraceMetrics defUserMetrics_;
    protected Noun nounRoot_;
    protected Hashtable<String, QuickTraceMetrics> metrics_;
    protected int ref_overhead_ = QuickTraceHandlerFactory.is64BitVM() ? 8 : 4;
    protected int logRecord_overhead_ = 72 + this.ref_overhead_ * 6;
    protected int string_overhead_ = this.ref_overhead_ * 3 * 2;
    protected int hashMap_overhead_s = this.ref_overhead_ * 12;
    protected int hashMap_entry_overhead_ = this.ref_overhead_ * 3 * 2;
    protected int param_overhead_ = this.ref_overhead_ * 5 * 2;
    protected int resourceBundle_overhead_ = this.ref_overhead_ * 5 * 2;

    public QuickTraceHandler(LogFormatter formatter, long bufferSize, int fieldLength, String path, boolean useLoggingContext, Mode mode, boolean enableDMSMetrics, Noun nounRoot, boolean bufferPerUser, boolean flushOnDump) {
        super(formatter);
        this.formatter_ = formatter;
        this.specifiedBufferSize_ = bufferSize;
        this.bufferSize_ = bufferSize > (long)this.logRecord_overhead_ ? bufferSize : (long)this.logRecord_overhead_;
        this.setFieldLength(fieldLength);
        this.path_ = path;
        this.useLoggingContext_ = useLoggingContext;
        this.mode_ = mode;
        this.enableDMSMetrics_ = enableDMSMetrics;
        this.metrics_ = new Hashtable();
        this.nounRoot_ = nounRoot;
        this.enableUserBuffer_ = bufferPerUser;
        this.flushOnDump_ = flushOnDump;
        this.id_ = id_s.getAndAdd(1);
        this.dateFormat_ = new SimpleDateFormat(TIME_STAMP_FORMAT);
        this.setApplicationContext(super.getApplicationContextProvider());
        this.setUserContext(super.getUserContextProvider());
    }

    public void initHandler() {
        this.levelValue_ = super.getLevel().intValue();
    }

    public long getBufferSize() {
        return this.bufferSize_;
    }

    public long getFieldLength() {
        return this.fieldLen_;
    }

    public boolean isUseLoggingContext() {
        return this.useLoggingContext_;
    }

    void setUseLoggingContext(boolean useLoggingContext) {
        this.useLoggingContext_ = useLoggingContext;
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.levelValue_ = level.intValue();
    }

    @Override
    public void setUseSourceClassAndMethod(Level level) {
        super.setUseSourceClassAndMethod(level);
        this.sourceClassAndMethodLevelValue_ = level.intValue();
    }

    @Override
    public void setUseThreadName(boolean useThreadName) {
        super.setUseThreadName(useThreadName);
        this.useThreadName_ = useThreadName;
    }

    @Override
    public void setUseRealThreadId(boolean useRealThreadId) {
        super.setUseRealThreadId(useRealThreadId);
        this.useRealThreadId_ = useRealThreadId;
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        super.setBaseEncoding(encoding);
    }

    public Mode getMode() {
        return this.mode_;
    }

    public boolean isEnableDMSMetrics() {
        return this.enableDMSMetrics_;
    }

    public boolean isEnableUserBuffer() {
        return this.enableUserBuffer_;
    }

    public boolean isFlushOnDump() {
        return this.flushOnDump_;
    }

    public void createDMSSensors() {
        if (this.enableDMSMetrics_) {
            this.defUserMetrics_ = this.enableUserBuffer_ ? new QuickTraceMetrics(this.nounRoot_, super.getName(), DEFAULT_USER, this, true) : new QuickTraceMetrics(this.nounRoot_, super.getName(), this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDMSSensors(String bufferName) {
        if (bufferName == null) {
            return;
        }
        if (this.enableDMSMetrics_ && this.enableUserBuffer_) {
            Hashtable<String, QuickTraceMetrics> hashtable = this.metrics_;
            synchronized (hashtable) {
                if (!this.metrics_.containsKey(bufferName)) {
                    QuickTraceMetrics metrics = new QuickTraceMetrics(this.nounRoot_, super.getName(), bufferName, this, false);
                    this.metrics_.put(bufferName, metrics);
                }
            }
        }
    }

    void destroyDMSSensor(String name) {
        QuickTraceMetrics m;
        if (this.enableUserBuffer_ && this.metrics_ != null && this.metrics_.size() > 0 && (m = this.metrics_.remove(name)) != null) {
            m.noun_.destroy();
        }
    }

    void destroyDMSSensors() {
        if (this.enableDMSMetrics_) {
            if (this.defUserMetrics_ != null && this.defUserMetrics_.noun_ != null) {
                this.defUserMetrics_.noun_.destroy();
            }
            if (this.enableUserBuffer_ && this.metrics_ != null && this.metrics_.size() > 0) {
                for (QuickTraceMetrics m : this.metrics_.values()) {
                    if (m == null) continue;
                    m.noun_.destroy();
                }
                this.metrics_.clear();
            }
        }
    }

    public void refresh() {
        if (this.enableDMSMetrics_) {
            this.defUserMetrics_.refresh();
            if (this.enableUserBuffer_ && this.metrics_ != null) {
                for (QuickTraceMetrics m : this.metrics_.values()) {
                    if (m == null) continue;
                    m.refresh();
                }
            }
        }
    }

    ResourceBundle getResourceBundle(String resourceBundleName, ResourceBundle defaultBundle, Locale locale) throws MissingResourceException {
        ClassLoader cl = null;
        if (defaultBundle != null) {
            cl = defaultBundle.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(resourceBundleName, locale, cl);
    }

    void setApplicationContext(String appCtxProvider) {
        if (appCtxProvider == null || appCtxProvider.length() == 0 || "disabled".equalsIgnoreCase(appCtxProvider)) {
            this.appContext_ = null;
        } else {
            try {
                this.appContext_ = (ApplicationContext)Class.forName(appCtxProvider).newInstance();
            }
            catch (Throwable t) {
                System.out.println("ODLFormatter: unable to create instance of ApplicationContext class " + appCtxProvider + ": " + t);
            }
        }
    }

    void setUserContext(String userCtxProvider) {
        if (userCtxProvider == null || userCtxProvider.length() == 0 || "disabled".equalsIgnoreCase(userCtxProvider)) {
            this.userContext_ = null;
        } else {
            try {
                this.userContext_ = (UserContext)Class.forName(userCtxProvider).newInstance();
            }
            catch (Throwable t) {
                System.out.println("ODLFormatter: unable to create instance of ApplicationContext class " + userCtxProvider + ": " + t);
            }
        }
    }

    void setReserveBufferIDs(String[] ids) {
        this.reserveBufferIDs_ = ids;
    }

    public String[] getReserveBufferIDs() {
        String[] cloneIDs = null;
        if (this.reserveBufferIDs_ != null) {
            cloneIDs = new String[this.reserveBufferIDs_.length];
            System.arraycopy(this.reserveBufferIDs_, 0, cloneIDs, 0, this.reserveBufferIDs_.length);
        }
        return cloneIDs;
    }

    private static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    protected void internalDump(String name, File destination) {
        this.internalDump(name, destination, this.flushOnDump_);
    }

    protected void internalDump(String name, File destination, boolean flushBuffer) {
        FileOutputStream fos = null;
        try {
            fos = QuickTraceHandler.getFileOutputStream(destination);
            this.dump(name, fos, flushBuffer);
            fos.flush();
            fos.close();
        }
        catch (Exception fnfex) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ignore) {
                    fos = null;
                }
            }
            fos = null;
        }
    }

    protected void internalDump(String name, FileOutputStream fos) {
        this.internalDump(name, fos, this.flushOnDump_);
    }

    protected void internalDump(String name, FileOutputStream fos, boolean flushBuffer) {
        BufferedInputStream bins = null;
        try {
            File file = File.createTempFile("quicktrace-temp", ".dmp");
            file.deleteOnExit();
            this.dump(name, file, flushBuffer);
            FileInputStream fins = new FileInputStream(file);
            int iobufSize = 65536;
            byte[] buffer = new byte[iobufSize];
            bins = new BufferedInputStream(fins, iobufSize);
            int read = bins.read(buffer, 0, buffer.length);
            while (read > 0) {
                fos.write(buffer, 0, read);
                fos.flush();
                read = bins.read(buffer, 0, iobufSize);
            }
            bins.close();
            boolean canDeleted = file.delete();
            if (!canDeleted) {
                file.deleteOnExit();
            }
        }
        catch (IOException ioex) {
            if (bins != null) {
                try {
                    bins.close();
                }
                catch (Exception ignore) {
                    bins = null;
                }
            }
            bins = null;
        }
    }

    void setFieldLength(int fieldLength) {
        this.fieldLen_ = (long)fieldLength > this.specifiedBufferSize_ ? (int)this.specifiedBufferSize_ : fieldLength;
    }

    public abstract void dump(FileOutputStream var1);

    public abstract void dump(String var1, FileOutputStream var2);

    public abstract void dump(File var1);

    public abstract void dump(String var1, File var2);

    public abstract void dump(FileOutputStream var1, boolean var2);

    public abstract void dump(String var1, FileOutputStream var2, boolean var3);

    public abstract void dump(File var1, boolean var2);

    public abstract void dump(String var1, File var2, boolean var3);

    abstract long getOldestRecordTime();

    abstract long getOldestRecordTime(String var1);

    abstract int getNumberOfRecords();

    abstract int getNumberOfRecords(String var1);

    abstract int getBufferUsedPercentage();

    abstract int getBufferUsedPercentage(String var1);

    public abstract String[] getBufferNames();

    class QuickTraceMetrics {
        String name_;
        Noun noun_;
        State stateOldestTime_;
        State stateNumRecord_;
        State stateBufUsed_;
        State stateElapsed_;
        boolean defUser_;

        QuickTraceMetrics(Noun root, String handlerName, String bufferName, QuickTraceHandler h, boolean defUser) {
            this.noun_ = Noun.create((Noun)root, (String)(handlerName + "/" + bufferName), (String)QuickTraceHandler.NOUNTYPE);
            this.name_ = bufferName;
            this.defUser_ = defUser;
            this.createSensors(h);
        }

        QuickTraceMetrics(Noun root, String handlerName, QuickTraceHandler h, boolean defUser) {
            this.noun_ = Noun.create((Noun)root, (String)handlerName, (String)QuickTraceHandler.NOUNTYPE);
            this.defUser_ = defUser;
            this.createSensors(h);
        }

        void createSensors(QuickTraceHandler h) {
            this.stateOldestTime_ = State.create((Noun)this.noun_, (String)QuickTraceHandler.ST_OLDESTTIME, (byte)5, (String)"time", (String)"time stamp of the oldest log record in memory");
            this.stateNumRecord_ = State.create((Noun)this.noun_, (String)QuickTraceHandler.ST_NUMRECIRD, (byte)3, (String)"records", (String)"number of log records in memory");
            this.stateBufUsed_ = State.create((Noun)this.noun_, (String)QuickTraceHandler.ST_BUFFERUSED, (byte)3, (String)"percent", (String)"buffer used");
            this.stateElapsed_ = State.create((Noun)this.noun_, (String)QuickTraceHandler.ST_ELAPSED, (byte)3, (String)"seconds", (String)"buffer elapsed time");
            this.stateOldestTime_.setRefresh((Refresh)h);
            this.stateNumRecord_.setRefresh((Refresh)h);
            this.stateBufUsed_.setRefresh((Refresh)h);
            this.stateElapsed_.setRefresh((Refresh)h);
        }

        void refresh() {
            String timeStamp = QuickTraceHandler.NOT_AVAILABLE;
            try {
                long time = this.defUser_ ? QuickTraceHandler.this.getOldestRecordTime() : QuickTraceHandler.this.getOldestRecordTime(this.name_);
                long elapsed = 0L;
                if (time > 0L) {
                    timeStamp = QuickTraceHandler.this.dateFormat_.format(new Date(time));
                    elapsed = (System.currentTimeMillis() - time) / 1000L;
                }
                this.stateOldestTime_.update((Object)timeStamp);
                if (this.defUser_) {
                    this.stateNumRecord_.update(QuickTraceHandler.this.getNumberOfRecords());
                } else {
                    this.stateNumRecord_.update(QuickTraceHandler.this.getNumberOfRecords(this.name_));
                }
                if (this.defUser_) {
                    this.stateBufUsed_.update(QuickTraceHandler.this.getBufferUsedPercentage());
                } else {
                    this.stateBufUsed_.update(QuickTraceHandler.this.getBufferUsedPercentage(this.name_));
                }
                this.stateElapsed_.update(elapsed);
            }
            catch (Exception ex) {
                timeStamp = null;
            }
        }
    }

    public static enum Mode {
        JFR,
        OBJREF,
        OBJVAL;

    }
}

