/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.MissingResourceException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLLogger;

class ODLLoggerProxy
extends ODLLogger {
    private Logger m_targetLogger;

    protected ODLLoggerProxy(Logger targetLogger) throws MissingResourceException {
        super(targetLogger.getName(), targetLogger.getResourceBundleName());
        this.m_targetLogger = targetLogger;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.isLoggableByContext(level) || this.m_targetLogger.isLoggable(level);
    }

    @Override
    public Logger getParent() {
        return this.m_targetLogger.getParent();
    }

    @Override
    public void setParent(Logger logger) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Filter getFilter() {
        return this.m_targetLogger.getFilter();
    }

    @Override
    public void setFilter(Filter filter) {
        this.m_targetLogger.setFilter(filter);
    }

    @Override
    public Handler[] getHandlers() {
        return this.m_targetLogger.getHandlers();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.m_targetLogger.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this.m_targetLogger.removeHandler(handler);
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.m_targetLogger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.m_targetLogger.getUseParentHandlers();
    }

    @Override
    public Level getLevel() {
        return this.m_targetLogger.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        this.m_targetLogger.setLevel(level);
    }

    @Override
    public String getResourceBundleName() {
        return this.m_targetLogger.getResourceBundleName();
    }
}

