/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.HandlerFactoryException;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.messages.Msgs;
import oracle.core.ojdl.util.TimestampFormat;

public class ODLHandlerFactory
implements HandlerFactory {
    private Properties m_properties;
    private HashMap m_nameMap;
    private static final TimestampFormat[] s_timeFormats = new TimestampFormat[]{TimestampFormat.getInstance("ISO8601"), TimestampFormat.getInstance("yyyy-MM-dd'T'HH:mm"), TimestampFormat.getInstance("yyyy-MM-dd"), TimestampFormat.getInstance("HH:mm")};
    private static final String PATH = "path";
    private static final String FORMAT = "format";
    private static final String MAXFILESZ = "maxFileSize";
    private static final String MAXLOGSZ = "maxLogSize";
    private static final String BASETIME = "baseRotationTime";
    private static final String FREQUENCY = "rotationFrequency";
    private static final String RETENTION = "retentionPeriod";
    private static final String ENCODING = "encoding";
    private static final String SUPPLATTRS = "supplementalAttributes";
    private static final String USESCM = "useSourceClassandMethod";
    private static final String USEDEFATTRS = "useDefaultAttributes";
    private static final String INCMSGARGS = "includeMessageArguments";
    private static final String DELETEFILES = "deleteFiles";
    private static final String KEEPOPEN = "keepOpen";
    private static final String LOCALE = "locale";
    private static final String AUTOFLUSH = "autoFlushLevel";
    private static final String USETHRNAME = "useThreadName";
    private static final String USEREALTHRID = "useRealThreadID";
    private static final String ADDJVMNUM = "addJvmNumber";
    private static final String APPCTX = "applicationContextProvider";
    private static final String USRCTX = "userContextProvider";
    private static final String LOCKMODE = "lockMode";
    private static final String LOCKTIMEOUT = "lockTimeOut";
    private static final List<String> s_allProperties = Collections.unmodifiableList(Arrays.asList("path".toLowerCase(), "format".toLowerCase(), "maxFileSize".toLowerCase(), "maxLogSize".toLowerCase(), "baseRotationTime".toLowerCase(), "rotationFrequency".toLowerCase(), "retentionPeriod".toLowerCase(), "encoding".toLowerCase(), "supplementalAttributes".toLowerCase(), "useSourceClassandMethod".toLowerCase(), "useDefaultAttributes".toLowerCase(), "includeMessageArguments".toLowerCase(), "deleteFiles".toLowerCase(), "keepOpen".toLowerCase(), "locale".toLowerCase(), "autoFlushLevel".toLowerCase(), "useThreadName".toLowerCase(), "useRealThreadID".toLowerCase(), "addJvmNumber".toLowerCase(), "applicationContextProvider".toLowerCase(), "userContextProvider".toLowerCase(), "lockMode".toLowerCase(), "lockTimeOut".toLowerCase()));

    @Override
    public Handler create(Properties properties) throws HandlerFactoryException {
        return this.configure(null, properties);
    }

    public Handler configure(ODLHandler h, Properties properties) throws HandlerFactoryException {
        this.m_properties = properties;
        this.m_nameMap = new HashMap(properties.size());
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String lname = name.toLowerCase();
            if (!ODLHandlerFactory.isValidPropertyName(lname)) {
                throw new HandlerFactoryException(Msgs.get("ODL-52030", name));
            }
            this.m_nameMap.put(lname, name);
        }
        String path = this.getProperty(PATH);
        if (path == null) {
            throw new HandlerFactoryException(Msgs.get("ODL-52031", PATH));
        }
        String format = this.getProperty(FORMAT, "ODL-Text");
        if (!(format.equalsIgnoreCase("ODL-Text") || format.equalsIgnoreCase("ODL-XML") || format.equalsIgnoreCase("ODL10-XML"))) {
            throw new HandlerFactoryException(Msgs.get("ODL-52032", format, "'ODL-Text', 'ODL-XML'"));
        }
        long fileSize = this.getLongProperty(MAXFILESZ, Long.MAX_VALUE);
        if (fileSize <= 0L) {
            throw new HandlerFactoryException(this.invPropVal(MAXFILESZ));
        }
        long logSize = this.getLongProperty(MAXLOGSZ, Long.MAX_VALUE);
        if (logSize <= 0L) {
            throw new HandlerFactoryException(this.invPropVal(MAXLOGSZ));
        }
        if (logSize < fileSize) {
            throw new HandlerFactoryException(Msgs.get("ODL-52034", MAXLOGSZ, MAXFILESZ));
        }
        long baseTime = this.getTimeProperty(BASETIME, 0L);
        if (baseTime == Long.MIN_VALUE) {
            throw new HandlerFactoryException(this.invPropVal(BASETIME));
        }
        int frequency = this.getFreqProperty(FREQUENCY, Integer.MAX_VALUE);
        if (frequency <= 0) {
            throw new HandlerFactoryException(this.invPropVal(FREQUENCY));
        }
        int retentionPeriod = this.getTimePeriodProperty(RETENTION, Integer.MAX_VALUE);
        if (retentionPeriod <= 0) {
            throw new HandlerFactoryException(this.invPropVal(RETENTION));
        }
        String encoding = this.getProperty(ENCODING);
        String supplAttrs = this.getProperty(SUPPLATTRS);
        String useDefAttr = this.getProperty(USEDEFATTRS);
        String deleteFiles = this.getProperty(DELETEFILES);
        String keepOpen = this.getProperty(KEEPOPEN);
        String useThrName = this.getProperty(USETHRNAME);
        String useRealThrId = this.getProperty(USEREALTHRID);
        String appCtx = this.getProperty(APPCTX);
        String usrCtx = this.getProperty(USRCTX);
        String localeStr = this.getProperty(LOCALE);
        Locale locale = localeStr != null ? TimestampFormat.toLocale(localeStr) : null;
        String autoFlush = this.getProperty(AUTOFLUSH);
        Level autoFlushLevel = null;
        if (autoFlush != null) {
            try {
                autoFlushLevel = this.parseLevel(autoFlush);
            }
            catch (IllegalArgumentException e) {
                throw new HandlerFactoryException(this.invPropVal(AUTOFLUSH));
            }
        }
        String useSCM = this.getProperty(USESCM);
        Level useSCMLevel = null;
        if (useSCM != null) {
            if (useSCM.equalsIgnoreCase("true")) {
                useSCMLevel = Level.OFF;
            } else if (useSCM.equalsIgnoreCase("false")) {
                useSCMLevel = Level.ALL;
            } else {
                try {
                    useSCMLevel = this.parseLevel(useSCM);
                }
                catch (IllegalArgumentException e) {
                    throw new HandlerFactoryException(this.invPropVal(USESCM));
                }
            }
        }
        String incMsgArgs = this.getProperty(INCMSGARGS);
        Level incMsgArgsLevel = null;
        if (incMsgArgs != null) {
            if (incMsgArgs.equalsIgnoreCase("true")) {
                incMsgArgsLevel = Level.OFF;
            } else if (incMsgArgs.equalsIgnoreCase("false")) {
                incMsgArgsLevel = Level.ALL;
            } else {
                try {
                    incMsgArgsLevel = this.parseLevel(incMsgArgs);
                }
                catch (IllegalArgumentException e) {
                    throw new HandlerFactoryException(this.invPropVal(INCMSGARGS));
                }
            }
        }
        boolean addJvmNum = "true".equalsIgnoreCase(this.getProperty(ADDJVMNUM));
        String lockMode = this.getProperty(LOCKMODE);
        long lockTimeOut = this.getLongProperty(LOCKTIMEOUT, Long.MIN_VALUE);
        try {
            String defaultFilename;
            LogFormatter logFormatter;
            if (format.equals("ODL-XML")) {
                logFormatter = new ODL11Formatter();
                defaultFilename = "log.xml";
            } else if (format.equals("ODL10-XML")) {
                logFormatter = new XMLFormatter();
                defaultFilename = "log.xml";
            } else {
                logFormatter = new ODLTextFormatter();
                defaultFilename = "diagnostic.log";
            }
            path = this.getEffectivePath(path, defaultFilename, addJvmNum);
            if (h == null) {
                h = new ODLHandler(logFormatter, path, encoding);
            } else {
                h.init(logFormatter, path, Long.MAX_VALUE, Long.MAX_VALUE, encoding);
            }
            h.setMaxFileSize(fileSize);
            h.setMaxLogSize(logSize);
            h.setBaseRotationTime(baseTime);
            h.setRotationFrequency(frequency);
            h.setRetentionPeriod(retentionPeriod);
            if (supplAttrs != null) {
                String[] list = ODLHandler.parseAttrList(supplAttrs);
                h.setSupplementalAttributes(list);
            }
            if (useSCMLevel != null) {
                h.setUseSourceClassAndMethod(useSCMLevel);
            }
            if (useDefAttr != null) {
                h.setUseDefaultAttributes(useDefAttr.equalsIgnoreCase("true"));
            } else if (format.equalsIgnoreCase("ODL-Text")) {
                h.setUseDefaultAttributes(false);
            }
            if (incMsgArgsLevel != null) {
                h.setIncludeMessageArgumentsLevel(incMsgArgsLevel);
            }
            if (deleteFiles != null) {
                h.setDeleteFiles(deleteFiles.equalsIgnoreCase("true"));
            }
            if (keepOpen != null) {
                h.setKeepOpen(keepOpen.equalsIgnoreCase("true"));
            }
            if (locale != null) {
                h.setLocale(locale);
            }
            if (autoFlushLevel != null) {
                h.setAutoFlushLevel(autoFlushLevel);
            }
            if (useThrName != null) {
                h.setUseThreadName(useThrName.equalsIgnoreCase("true"));
            }
            if (useRealThrId != null) {
                h.setUseRealThreadId(useRealThrId.equalsIgnoreCase("true"));
            }
            if (appCtx != null) {
                h.setApplicationContextProvider(appCtx);
            }
            if (usrCtx != null) {
                h.setUserContextProvider(usrCtx);
            }
            if (lockMode != null) {
                h.setLockMode(lockMode.equalsIgnoreCase("true"));
                if (lockTimeOut != Long.MIN_VALUE) {
                    h.setLockTimeOut(lockTimeOut);
                }
            }
        }
        catch (Exception e) {
            throw new HandlerFactoryException(Msgs.get("ODL-52035", e), e);
        }
        return h;
    }

    public static List<String> getValidPropertyNames() {
        return s_allProperties;
    }

    public static boolean isValidPropertyName(String name) {
        return s_allProperties.contains(name) || name.startsWith("metadata:") || name.startsWith("logreader:") || name.startsWith("logviewer:");
    }

    private String getEffectivePath(String path, String defaultFilename, boolean addJvmNumber) {
        File f = new File(path);
        String epath = defaultFilename != null && (f.isDirectory() || !f.exists() && (path.length() <= 4 || path.charAt(path.length() - 4) != '.')) ? new File(f, defaultFilename).getAbsolutePath() : path;
        String jvmNum = System.getProperty("oracle.process.index");
        if (addJvmNumber && jvmNum != null) {
            epath = epath.length() > 4 && epath.charAt(epath.length() - 4) == '.' ? epath.substring(0, epath.length() - 4) + "-jvm" + jvmNum + epath.substring(epath.length() - 4) : epath + "-jvm" + jvmNum;
        }
        return epath;
    }

    private long getLongProperty(String name, long defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException(this.invPropVal(name));
        }
    }

    private int getFreqProperty(String name, int defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        if (value.equalsIgnoreCase("hourly")) {
            return 60;
        }
        if (value.equalsIgnoreCase("daily")) {
            return 1440;
        }
        if (value.equalsIgnoreCase("weekly")) {
            return 10080;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException(this.invPropVal(name));
        }
    }

    private int getTimePeriodProperty(String name, int defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        if (value.equalsIgnoreCase("day")) {
            return 1440;
        }
        if (value.equalsIgnoreCase("week")) {
            return 10080;
        }
        if (value.equalsIgnoreCase("month")) {
            return 43200;
        }
        if (value.equalsIgnoreCase("year")) {
            return 525600;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException(this.invPropVal(name));
        }
    }

    private long getTimeProperty(String name, long defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        long t = Long.MIN_VALUE;
        for (int i = 0; i < s_timeFormats.length && (t = s_timeFormats[i].parse(value)) == Long.MIN_VALUE; ++i) {
        }
        return t;
    }

    private String getProperty(String name) {
        String pname = (String)this.m_nameMap.get(name.toLowerCase());
        if (pname != null) {
            return this.m_properties.getProperty(pname);
        }
        return null;
    }

    private String getProperty(String name, String defVal) {
        String value = this.getProperty(name);
        return value == null ? defVal : value;
    }

    private Level parseLevel(String levelName) {
        try {
            return ODLLevel.parse(levelName);
        }
        catch (IllegalArgumentException e1) {
            return ODLLevel.parse(levelName.toUpperCase());
        }
    }

    private String invPropVal(String name) {
        return Msgs.get("ODL-52033", name, this.getProperty(name));
    }
}

