/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.MT_UserContext;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.context.ApplicationContext;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.logging.context.UserContext;
import oracle.core.ojdl.logging.impl.MessageIdSupport;

public class ODLFormatter
extends Formatter {
    public static final String ODL_XML = "ODL-XML";
    public static final String ODL10_XML = "ODL10-XML";
    public static final String ODL_TEXT = "ODL-Text";
    private LogFormatter m_logFormatter;
    private String[] m_supplAttributes = null;
    private boolean m_useDefaultAttributes = true;
    private Level m_useSrcClassAndMethodLevel = Level.FINE;
    private Level m_includeMsgArgsLevel = ODLLevel.INCIDENT_ERROR;
    private Locale m_locale = null;
    private boolean m_useThreadName = false;
    private boolean m_useRealThreadId = false;
    private String m_appContextProvider;
    private ApplicationContext m_appContext;
    private String m_userContextProvider;
    private UserContext m_userContext;
    private String m_defaultComponentId;
    private ThreadLocal m_threadIds = new ThreadLocal();
    private MessageIdSupport m_msgIdSupport = new MessageIdSupport();
    private static LogMessage s_defaults = new LogMessage(true);
    private static final boolean s_isIBMJVM;

    public ODLFormatter() {
        this(new ODLTextFormatter());
    }

    public ODLFormatter(String format) {
        if (format.equalsIgnoreCase(ODL_XML)) {
            this.m_logFormatter = new ODL11Formatter();
        } else if (format.equalsIgnoreCase(ODL10_XML)) {
            this.m_logFormatter = new XMLFormatter();
        } else if (format.equalsIgnoreCase(ODL_TEXT)) {
            this.m_logFormatter = new ODLTextFormatter();
            this.setUseDefaultAttributes(false);
        } else {
            throw new IllegalArgumentException("format: " + format);
        }
        this.init();
    }

    ODLFormatter(LogFormatter logFormatter) {
        this.m_logFormatter = logFormatter;
        this.init();
    }

    private void init() {
        this.m_defaultComponentId = ODLFormatter.getSystemProperty("oracle.core.ojdl.logging.componentId");
        String appCtxProvider = ODLFormatter.getSystemProperty("oracle.core.ojdl.logging.applicationcontextprovider");
        this.setApplicationContextProvider(appCtxProvider);
        String userCtxProvider = ODLFormatter.getSystemProperty("oracle.core.ojdl.logging.usercontextprovider");
        this.setUserContextProvider(userCtxProvider);
    }

    @Override
    public String format(LogRecord rec) {
        return this.m_logFormatter.format(this.toLogMessage(rec));
    }

    @Override
    public String getHead(Handler h) {
        String header = this.m_logFormatter.header();
        return header != null ? header : "";
    }

    @Override
    public String getTail(Handler h) {
        String tail = this.m_logFormatter.tail();
        return tail != null ? tail : "";
    }

    public String format(LogRecord rec, Locale locale) {
        return this.m_logFormatter.format(this.toLogMessage(rec, locale, false));
    }

    public LogMessage toLogMessage(LogRecord rec) {
        return this.toLogMessage(rec, this.m_locale, false, null);
    }

    LogMessage toLogMessage(LogRecord rec, ODLHandler.RecursionCounter recursionCounter) {
        return this.toLogMessage(rec, this.m_locale, false, recursionCounter);
    }

    LogMessage toLogMessage(LogRecord rec, boolean useCachedCtxAttrs) {
        return this.toLogMessage(rec, this.m_locale, useCachedCtxAttrs);
    }

    LogMessage toLogMessage(LogRecord rec, Locale locale, boolean useCachedCtxAttrs) {
        return this.toLogMessage(rec, locale, useCachedCtxAttrs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogMessage toLogMessage(LogRecord rec, Locale locale, boolean useCachedCtxAttrs, ODLHandler.RecursionCounter recursionCounter) {
        Throwable t;
        String msgText;
        String errorId;
        String problemKey;
        String detailLoc;
        String msgId;
        String supplDet;
        Map<String, String> supplAttrs;
        String userId;
        LogMessage.InstanceId ecid;
        String componentId;
        String moduleId;
        block66: {
            String name = rec.getLoggerName();
            if (name == null) {
                name = "";
            }
            moduleId = name;
            if (this.m_defaultComponentId == null) {
                String orgId;
                int i = name.indexOf(46);
                if (i >= 0) {
                    orgId = name.substring(0, i);
                    int j = name.indexOf(46, i + 1);
                    componentId = j >= 0 ? name.substring(i + 1, j) : name.substring(i + 1);
                } else {
                    orgId = null;
                    componentId = name;
                }
            } else {
                componentId = this.m_defaultComponentId;
            }
            ecid = null;
            userId = null;
            supplAttrs = null;
            boolean isODLLogRecord = rec instanceof ODLLogRecord;
            LoggingContext ctx = null;
            if (isODLLogRecord) {
                ctx = ((ODLLogRecord)rec).getLoggingContext();
            }
            boolean isInternalCtx = recursionCounter != null ? recursionCounter.enterInternalCtx() : false;
            try {
                if (!useCachedCtxAttrs && !isInternalCtx) {
                    String appName;
                    if (this.m_appContext != null && (appName = this.m_appContext.getApplicationName()) != null && appName.length() > 0) {
                        supplAttrs = new HashMap<String, String>();
                        supplAttrs.put("APP", appName);
                    }
                    if (this.m_userContext != null) {
                        userId = this.m_userContext.getUserName();
                    }
                    if (ctx == null) {
                        try {
                            ctx = LoggingContextManager.getLoggingContext(name);
                        }
                        catch (Exception e) {
                            ctx = null;
                        }
                    }
                }
                if (ctx != null) {
                    String uid = ctx.getECID();
                    if (uid != null && uid.length() > 0) {
                        String rid = ctx.getRID();
                        if (rid == null || rid.length() == 0) {
                            rid = "0";
                        }
                        ecid = new LogMessage.InstanceId(uid, rid);
                    }
                    if (!useCachedCtxAttrs) {
                        Set<String> logKeys;
                        if (this.m_supplAttributes != null) {
                            for (int k = 0; k < this.m_supplAttributes.length; ++k) {
                                String attrName = this.m_supplAttributes[k];
                                String attrValue = ctx.getAttributeValue(attrName);
                                if (attrValue == null) continue;
                                if (supplAttrs == null) {
                                    supplAttrs = new HashMap();
                                }
                                supplAttrs.put(attrName, attrValue);
                            }
                        }
                        if ((logKeys = ctx.getLoggableAttributes()) != null && logKeys.size() > 0) {
                            for (String logKey : logKeys) {
                                String val = ctx.getAttributeValue(logKey);
                                if (val == null) continue;
                                if (supplAttrs == null) {
                                    supplAttrs = new HashMap();
                                }
                                supplAttrs.put(logKey, val);
                            }
                        }
                        if (this.m_userContext != null && this.m_userContext instanceof MT_UserContext) {
                            String entName = ctx.getAttributeValue("ENTERPRISE_NAME");
                            String entId = ctx.getAttributeValue("ENTERPRISE_ID");
                            if (entName != null || entId != null) {
                                if (supplAttrs == null) {
                                    supplAttrs = new HashMap(2);
                                }
                                if (entName != null) {
                                    supplAttrs.put("ENTERPRISE_NAME", entName);
                                }
                                if (entId != null) {
                                    supplAttrs.put("ENTERPRISE_ID", entId);
                                }
                            }
                        }
                    }
                }
            }
            finally {
                if (recursionCounter != null) {
                    recursionCounter.exitInternalCtx();
                }
            }
            ResourceBundle bundle = rec.getResourceBundle();
            String s = rec.getMessage();
            supplDet = null;
            msgId = null;
            detailLoc = null;
            problemKey = null;
            errorId = null;
            String[] supplAttributeKeys = null;
            String[] supplAttributeValues = null;
            if (isODLLogRecord) {
                ODLLogRecord orec = (ODLLogRecord)rec;
                msgId = orec.getMessageId();
                Map map = orec.getSupplAttributes();
                if (map != null) {
                    if (supplAttrs == null) {
                        supplAttrs = map;
                    } else {
                        supplAttrs.putAll(map);
                    }
                }
                supplAttributeKeys = orec.getSupplAttributeKeys();
                supplAttributeValues = orec.getSupplAttributeValues();
                if (supplAttributeKeys != null && supplAttributeKeys.length > 0 && supplAttributeValues != null && supplAttributeValues.length > 0) {
                    if (supplAttrs == null) {
                        supplAttrs = new HashMap();
                    }
                    int len = Math.min(supplAttributeKeys.length, supplAttributeValues.length);
                    for (int i = 0; i < len; ++i) {
                        if (supplAttributeKeys[i] == null) continue;
                        supplAttrs.put(supplAttributeKeys[i], supplAttributeValues[i]);
                    }
                }
                supplDet = orec.getSupplDetail();
                detailLoc = orec.getDetailLocation();
                problemKey = orec.getProblemKey();
                errorId = orec.getErrorInstanceId();
            }
            if (bundle != null) {
                try {
                    if (locale != null && !Locale.getDefault().equals(locale)) {
                        try {
                            bundle = this.getResourceBundle(rec.getResourceBundleName(), rec.getResourceBundle(), locale);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ((msgText = this.getString(bundle, s)) != null) {
                        if (msgId == null) {
                            msgId = this.m_msgIdSupport.getMessageId(bundle, s);
                        }
                        break block66;
                    }
                    msgText = s;
                }
                catch (Exception e) {
                    msgText = s;
                }
            } else {
                msgText = s;
            }
        }
        Level level = rec.getLevel();
        Object[] args = rec.getParameters();
        LogMessage.MessageArgument[] msgArgs = null;
        if (args != null && args.length > 0) {
            if (msgText != null && msgText.indexOf("{") >= 0) {
                try {
                    msgText = MessageFormat.format(msgText, args);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (msgId != null && level.intValue() >= this.m_includeMsgArgsLevel.intValue()) {
                msgArgs = new LogMessage.MessageArgument[args.length];
                for (int k = 0; k < args.length; ++k) {
                    String v = args[k] != null ? args[k].toString() : null;
                    msgArgs[k] = new LogMessage.MessageArgument(null, v);
                }
            }
        }
        if ((t = rec.getThrown()) != null) {
            supplDet = this.writeStackTrace(t);
        }
        if (level != null && level.intValue() <= this.m_useSrcClassAndMethodLevel.intValue()) {
            String srcMethod;
            String srcClass = rec.getSourceClassName();
            if (srcClass != null) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                supplAttrs.put("SRC_CLASS", srcClass);
            }
            if ((srcMethod = rec.getSourceMethodName()) != null) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                supplAttrs.put("SRC_METHOD", srcMethod);
            }
        }
        MessageType msgType = MessageType.UNKNOWN;
        int[] arbLevel = new int[]{16};
        if (level != null) {
            msgType = ODLLevel.getMsgTypeAndLevel(rec.getLevel(), arbLevel);
        }
        LogMessage msg = new LogMessage(false);
        msg.setTimestamp(rec.getMillis());
        msg.setComponentId(componentId);
        msg.setMessageId(msgId);
        msg.setMessageType(msgType);
        msg.setMessageLevel(arbLevel[0]);
        msg.setModuleId(moduleId);
        msg.setUserId(userId);
        msg.setExecContextId(ecid);
        msg.setMessageText(msgText);
        msg.setMessageArgs(msgArgs);
        msg.setDetailLocation(detailLoc);
        msg.setSupplementalDetail(supplDet);
        if (errorId != null) {
            msg.setErrorInstanceId(new LogMessage.InstanceId(errorId, null));
        }
        msg.setThreadId(this.getEffectiveThreadId(rec.getThreadID()));
        if (supplAttrs != null) {
            msg.setSupplAttrs(supplAttrs);
        }
        if (problemKey != null) {
            msg.setProblemKey(problemKey);
        }
        if (this.m_useDefaultAttributes) {
            msg.setHostId(s_defaults.getHostId());
            msg.setHostNwAddr(s_defaults.getHostNwAddr());
            if (userId == null) {
                msg.setUserId(s_defaults.getUserId());
            }
        }
        return msg;
    }

    public String getFormat() {
        if (this.m_logFormatter instanceof ODLTextFormatter) {
            return ODL_TEXT;
        }
        if (this.m_logFormatter instanceof ODL11Formatter) {
            return ODL_XML;
        }
        if (this.m_logFormatter instanceof XMLFormatter) {
            return ODL10_XML;
        }
        return this.m_logFormatter.getClass().getName();
    }

    public void setSupplementalAttributes(String[] attrNames) {
        if (attrNames != null) {
            for (int i = 0; i < attrNames.length; ++i) {
                attrNames[i] = attrNames[i].intern();
            }
        }
        this.m_supplAttributes = attrNames;
    }

    public String[] getSupplementalAttributes() {
        return this.m_supplAttributes;
    }

    public void setUseSourceClassAndMethod(boolean useSrcClassAndMethod) {
        this.setUseSourceClassAndMethod(useSrcClassAndMethod ? Level.OFF : Level.ALL);
    }

    public boolean getUseSourceClassAndMethod() {
        return this.m_useSrcClassAndMethodLevel == Level.OFF;
    }

    public void setUseSourceClassAndMethod(Level level) {
        this.m_useSrcClassAndMethodLevel = level;
    }

    public Level getUseSourceClassAndMethodLevel() {
        return this.m_useSrcClassAndMethodLevel;
    }

    public void setUseDefaultAttributes(boolean useDefaultAttributes) {
        this.m_useDefaultAttributes = useDefaultAttributes;
    }

    public boolean getUseDefaultAttributes() {
        return this.m_useDefaultAttributes;
    }

    public void setIncludeMessageArguments(boolean includeMessageArguments) {
        this.setIncludeMessageArgumentsLevel(includeMessageArguments ? Level.ALL : Level.OFF);
    }

    public boolean getIncludeMessageArguments() {
        return this.m_includeMsgArgsLevel == Level.ALL;
    }

    public void setIncludeMessageArgumentsLevel(Level includeMessageArgumentsLevel) {
        this.m_includeMsgArgsLevel = includeMessageArgumentsLevel;
    }

    public Level getIncludeMessageArgumentsLevel() {
        return this.m_includeMsgArgsLevel;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setUseThreadName(boolean useThreadName) {
        this.m_useThreadName = useThreadName;
    }

    public boolean getUseThreadName() {
        return this.m_useThreadName;
    }

    public void setUseRealThreadId(boolean useRealThreadId) {
        this.m_useRealThreadId = useRealThreadId;
    }

    public boolean getUseRealThreadId() {
        return this.m_useRealThreadId;
    }

    public void setApplicationContextProvider(String appCtxProvider) {
        this.m_appContextProvider = appCtxProvider;
        if (appCtxProvider == null || appCtxProvider.length() == 0 || "disabled".equalsIgnoreCase(appCtxProvider)) {
            this.m_appContext = null;
        } else {
            try {
                this.m_appContext = (ApplicationContext)Class.forName(appCtxProvider).newInstance();
            }
            catch (Throwable t) {
                System.out.println("ODLFormatter: unable to create instance of ApplicationContext class " + appCtxProvider + ": " + t);
            }
        }
    }

    public String getApplicationContextProvider() {
        return this.m_appContextProvider;
    }

    public void setUserContextProvider(String userCtxProvider) {
        this.m_userContextProvider = userCtxProvider;
        if (userCtxProvider == null || userCtxProvider.length() == 0 || "disabled".equalsIgnoreCase(userCtxProvider)) {
            this.m_userContext = null;
        } else {
            try {
                this.m_userContext = (UserContext)Class.forName(userCtxProvider).newInstance();
            }
            catch (Throwable t) {
                System.out.println("ODLFormatter: unable to create instance of ApplicationContext class " + userCtxProvider + ": " + t);
            }
        }
    }

    public String getUserContextProvider() {
        return this.m_userContextProvider;
    }

    protected final String writeStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private ResourceBundle getResourceBundle(String resourceBundleName, ResourceBundle defaultBundle, Locale locale) throws MissingResourceException {
        ClassLoader cl = null;
        if (defaultBundle != null) {
            cl = defaultBundle.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(resourceBundleName, locale, cl);
    }

    private String getEffectiveThreadId(int threadID) {
        if (this.m_useThreadName || this.m_useRealThreadId) {
            int id;
            Object obj = this.m_threadIds.get();
            if (obj == null) {
                LogRecord rec = new LogRecord(Level.FINEST, "");
                id = rec.getThreadID();
                this.m_threadIds.set(new Integer(id));
            } else {
                id = (Integer)obj;
            }
            if (id == threadID) {
                if (this.m_useThreadName) {
                    String name = Thread.currentThread().getName();
                    if (name != null) {
                        return name;
                    }
                } else {
                    return Long.toString(Thread.currentThread().getId());
                }
            }
        }
        return String.valueOf(threadID);
    }

    String getDefaultComponentId() {
        return this.m_defaultComponentId;
    }

    private final String getString(ResourceBundle rb, String key) {
        if (!s_isIBMJVM && !rb.containsKey(key)) {
            return null;
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static final String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static {
        String p = null;
        try {
            p = ODLFormatter.getSystemProperty("java.vm.vendor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_isIBMJVM = p != null && p.indexOf("IBM") >= 0;
    }
}

