/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Map;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.TimeFormatter;

public class ODLTextFormatter
implements LogFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private TimeFormatter m_timeFmt = new TimeFormatter();
    private static final String END_PATTERN = "]]";

    @Override
    public String format(LogMessage msg) {
        int nl;
        String txt = msg.getMessageText();
        String spl = msg.getSupplDetail();
        Map map = msg.getSupplAttrs();
        int size = 150 + (txt != null ? txt.length() : 0) + (spl != null ? spl.length() : 0);
        if (map != null) {
            size += 60 * map.size();
        }
        StringBuilder buf = new StringBuilder(size);
        buf.append("[");
        this.m_timeFmt.format(msg.getTimestamp(), buf);
        buf.append("] ");
        buf.append("[");
        if (msg.getComponentId() != null) {
            buf.append(msg.getComponentId());
        }
        buf.append("] [");
        MessageType msgtype = msg.getMessageType();
        if (msgtype != null) {
            buf.append(msgtype.toString());
            if (msg.getMessageLevel() > 1 && msgtype != MessageType.UNKNOWN) {
                buf.append(":");
                buf.append(msg.getMessageLevel());
            }
        } else {
            buf.append(MessageType.UNKNOWN.toString());
        }
        buf.append("] [");
        if (msg.getMessageId() != null) {
            buf.append(msg.getMessageId());
        }
        buf.append("] [");
        if (msg.getModuleId() != null) {
            buf.append(msg.getModuleId());
        }
        buf.append("] ");
        if (msg.getOrganizationId() != null) {
            this.writeAttr(buf, "org", msg.getOrganizationId());
        }
        if (msg.getHostingClientId() != null) {
            this.writeAttr(buf, "hostingClientId", msg.getHostingClientId());
        }
        if (msg.getMessageGroup() != null) {
            this.writeAttr(buf, "group", msg.getMessageGroup());
        }
        if (msg.getHostId() != null) {
            this.writeAttr(buf, "host", msg.getHostId());
        }
        if (msg.getHostNwAddr() != null) {
            this.writeAttr(buf, "nwaddr", msg.getHostNwAddr());
        }
        if (msg.getProcessId() != null) {
            this.writeAttr(buf, "pid", msg.getProcessId());
        }
        if (msg.getThreadId() != null) {
            this.writeAttr(buf, "tid", msg.getThreadId());
        }
        if (msg.getUserId() != null) {
            this.writeAttr(buf, "userId", msg.getUserId());
        }
        if (msg.getUpstreamCompId() != null) {
            this.writeAttr(buf, "upstreamComp", msg.getUpstreamCompId());
        }
        if (msg.getDownstreamCompId() != null) {
            this.writeAttr(buf, "downstreamComp", msg.getDownstreamCompId());
        }
        if (msg.getExecContextId() != null) {
            buf.append("[ecid: ");
            buf.append(msg.getExecContextId().getUniqueId());
            buf.append(",");
            buf.append(msg.getExecContextId().getRID());
            buf.append("] ");
        }
        if (msg.getErrorInstanceId() != null) {
            buf.append("[errid: ");
            buf.append(msg.getErrorInstanceId().getUniqueId());
            String rid = msg.getErrorInstanceId().getRID();
            if (rid != null) {
                buf.append(",");
                buf.append(msg.getErrorInstanceId().getRID());
            }
            buf.append("] ");
        }
        if (msg.getDetailLocation() != null) {
            this.writeAttr(buf, "detailLoc", msg.getDetailLocation());
        }
        if (msg.getProblemKey() != null) {
            this.writeAttr(buf, "probKey", msg.getProblemKey());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object v = entry.getValue();
                String s = v != null ? v.toString() : "";
                this.writeAttr(buf, entry.getKey().toString(), s);
            }
        }
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                buf.append("[arg: ");
                if (args[i].getName() != null) {
                    buf.append(args[i].getName());
                    buf.append("=");
                }
                this.writeValue(buf, args[i].getValue());
                buf.append("] ");
            }
        }
        if (txt == null) {
            txt = "";
        }
        if ((nl = txt.indexOf(10)) >= 0) {
            int len = 1;
            if (nl > 0 && txt.charAt(nl - 1) == '\r') {
                --nl;
                ++len;
            }
            String s = txt.substring(0, nl);
            spl = spl == null ? txt.substring(nl + len) : txt.substring(nl + len) + ' ' + spl;
            txt = s;
        }
        if (txt.startsWith("[")) {
            buf.append(" ");
        }
        buf.append(txt);
        if (spl != null) {
            buf.append("[[");
            buf.append(LSEP);
            this.escapeBracket(buf, spl);
            buf.append(LSEP);
            buf.append(END_PATTERN);
        }
        buf.append(LSEP);
        return buf.toString();
    }

    private void escapeBracket(StringBuilder buf, String s) {
        int end;
        int indx = s.indexOf(END_PATTERN);
        if (indx < 0) {
            buf.append(s);
            return;
        }
        int start = 0;
        do {
            int c2;
            end = indx + END_PATTERN.length();
            int c1 = indx > 0 ? (int)s.charAt(indx - 1) : 10;
            int n = c2 = end < s.length() ? (int)s.charAt(end) : 10;
            if (!(c1 != 10 && c1 != 13 || c2 != 10 && c2 != 13)) {
                buf.append(s.substring(start, end));
                buf.append(" ");
                continue;
            }
            buf.append(s.substring(start, end));
        } while ((indx = s.indexOf(END_PATTERN, start = end)) >= 0);
        buf.append(s.substring(start));
    }

    private final void writeAttr(StringBuilder buf, String name, String value) {
        buf.append("[");
        buf.append(name);
        buf.append(": ");
        this.writeValue(buf, value);
        buf.append("] ");
    }

    private final void writeValue(StringBuilder buf, String value) {
        if (value == null) {
            buf.append(value);
            return;
        }
        int k = 0;
        int i = 0;
        int len = value.length();
        while (i < len) {
            char ch;
            if ((ch = value.charAt(i++)) == '\n') {
                buf.append(value, k, i - 1);
                k = i;
                buf.append("\\n");
                continue;
            }
            if (ch == '\r') {
                buf.append(value, k, i - 1);
                k = i;
                buf.append("\\r");
                continue;
            }
            if (ch != ' ' || i <= 1 || value.charAt(i - 2) != ']') continue;
            buf.append(value, k, i - 1);
            k = i;
            buf.append(".");
        }
        if (k == 0) {
            buf.append(value);
        } else if (k < i) {
            buf.append(value, k, i);
        }
    }

    @Override
    public String header() {
        return null;
    }

    @Override
    public String tail() {
        return null;
    }
}

