/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Map;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.TimeFormatter;
import oracle.core.ojdl.util.XMLUtil;

public class ODL11Formatter
implements LogFormatter {
    public static final String MSG = "msg";
    public static final String TIMESTAMP = "time";
    public static final String TIMESTAMP_NORM = "time_norm";
    public static final String ORGANIZATION_ID = "org_id";
    public static final String INSTANCE_ID = "inst_id";
    public static final String COMPONENT_ID = "comp_id";
    public static final String MSG_ID = "msg_id";
    public static final String CLIENT_ID = "client_id";
    public static final String MSG_TYPE = "type";
    public static final String MSG_GROUP = "group";
    public static final String MSG_LEVEL = "level";
    public static final String HOST_ID = "host_id";
    public static final String HOST_ADDR = "host_addr";
    public static final String MODULE_ID = "module";
    public static final String PROCESS_ID = "pid";
    public static final String THREAD_ID = "tid";
    public static final String USER_ID = "user";
    public static final String SUPPL_ATTR = "attr";
    public static final String SUPPL_ATTR_NAME = "name";
    public static final String SUPPL_ATTR_VALUE = "value";
    public static final String UPSTREAM_COMP_ID = "upstream_comp";
    public static final String DOWNSTREAM_COMP_ID = "downstream_comp";
    public static final String ECID = "ecid";
    public static final String RID = "rid";
    public static final String ERROR_ID = "errid";
    public static final String ERROR_SEQ = "err_seq";
    public static final String MSG_TEXT = "txt";
    public static final String MSG_ARG = "arg";
    public static final String MSG_ARG_NAME = "name";
    public static final String MSG_ARG_VALUE = "value";
    public static final String DETAIL_PATH = "detail_path";
    public static final String SUPPL_DETAIL = "suppl_detail";
    public static final String PROBLEM_KEY = "prob_key";
    private TimeFormatter m_timeFmt = new TimeFormatter();
    private boolean m_escapeChars = true;
    private boolean m_useHeadAndTail = false;
    private static final String LSEP = System.getProperty("line.separator");
    private static final String START_MSG = "<msg";
    private static final String CLOSE_MSG = "</msg>" + LSEP;
    private static final String START_SUPPL_ATTR = " <attr";
    private static final String START_MSG_TXT = " <txt>";
    private static final String CLOSE_MSG_TXT = "</txt>" + LSEP;
    private static final String START_MSG_ARG = " <arg";
    private static final String START_SUPPL_DETAIL = " <suppl_detail>";
    private static final String CLOSE_SUPPL_DETAIL = "</suppl_detail>" + LSEP;
    private static final String CLOSE_START_ELEM = ">" + LSEP;
    private static final String CLOSE_ELEM = "/>" + LSEP;
    private static final String HEAD = "<?xml version='1.0'?>" + LSEP + "<LOG>" + LSEP;
    private static final String TAIL = "</LOG>" + LSEP;

    public ODL11Formatter(boolean useHeadAndTail) {
        String escapeProp = System.getProperty("oracle.core.ojdl.ODL11Formatter.escapeChars");
        if (escapeProp == null) {
            escapeProp = LogManager.getLogManager().getProperty("ODL11Formatter.escapeChars", "true");
        }
        this.m_escapeChars = escapeProp.equalsIgnoreCase("true");
        this.m_useHeadAndTail = useHeadAndTail;
    }

    public ODL11Formatter() {
        this(false);
    }

    @Override
    public String format(LogMessage msg) {
        String msgText = msg.getMessageText();
        String supplDet = msg.getSupplDetail();
        Map map = msg.getSupplAttrs();
        int size = 300 + (msgText != null ? msgText.length() : 0) + (supplDet != null ? supplDet.length() : 0);
        if (map != null) {
            size += 80 * map.size();
        }
        StringBuilder buf = new StringBuilder(size);
        buf.append(START_MSG);
        this.attr(buf, TIMESTAMP, msg.getTimestamp());
        if (msg.getNormalizedTimestamp() > 0L) {
            this.attr(buf, TIMESTAMP_NORM, msg.getNormalizedTimestamp());
        }
        if (msg.getOrganizationId() != null) {
            this.attrEsc(buf, ORGANIZATION_ID, msg.getOrganizationId());
        }
        if (msg.getComponentId() != null) {
            this.attrEsc(buf, COMPONENT_ID, msg.getComponentId());
        }
        if (msg.getInstanceId() != null) {
            this.attrEsc(buf, INSTANCE_ID, msg.getInstanceId());
        }
        if (msg.getMessageId() != null) {
            this.attrEsc(buf, MSG_ID, msg.getMessageId());
        }
        if (msg.getHostingClientId() != null) {
            this.attrEsc(buf, CLIENT_ID, msg.getHostingClientId());
        }
        if (msg.getMessageType() != null) {
            this.attr(buf, MSG_TYPE, msg.getMessageType().toString());
        } else {
            this.attr(buf, MSG_TYPE, MessageType.UNKNOWN.toString());
        }
        this.attr(buf, MSG_LEVEL, msg.getMessageLevel());
        if (msg.getMessageGroup() != null) {
            this.attrEsc(buf, MSG_GROUP, msg.getMessageGroup());
        }
        if (msg.getHostId() != null) {
            this.attrEsc(buf, HOST_ID, msg.getHostId());
        }
        if (msg.getHostNwAddr() != null) {
            this.attrEsc(buf, HOST_ADDR, msg.getHostNwAddr());
        }
        if (msg.getModuleId() != null) {
            this.attrEsc(buf, MODULE_ID, msg.getModuleId());
        }
        if (msg.getProcessId() != null) {
            this.attrEsc(buf, PROCESS_ID, msg.getProcessId());
        }
        if (msg.getThreadId() != null) {
            this.attrEsc(buf, THREAD_ID, msg.getThreadId());
        }
        if (msg.getUserId() != null) {
            this.attrEsc(buf, USER_ID, msg.getUserId());
        }
        if (msg.getUpstreamCompId() != null) {
            this.attrEsc(buf, UPSTREAM_COMP_ID, msg.getUpstreamCompId());
        }
        if (msg.getDownstreamCompId() != null) {
            this.attrEsc(buf, DOWNSTREAM_COMP_ID, msg.getDownstreamCompId());
        }
        if (msg.getExecContextId() != null) {
            this.attr(buf, ECID, msg.getExecContextId().getUniqueId());
            this.attr(buf, RID, msg.getExecContextId().getRID());
        }
        if (msg.getErrorInstanceId() != null) {
            this.attr(buf, ERROR_ID, msg.getErrorInstanceId().getUniqueId());
            String rid = msg.getErrorInstanceId().getRID();
            if (rid != null) {
                this.attr(buf, ERROR_SEQ, msg.getErrorInstanceId().getRID());
            }
        }
        if (msg.getDetailLocation() != null) {
            this.attrEsc(buf, DETAIL_PATH, msg.getDetailLocation());
        }
        if (msg.getProblemKey() != null) {
            this.attrEsc(buf, PROBLEM_KEY, msg.getProblemKey());
        }
        buf.append(CLOSE_START_ELEM);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                buf.append(START_SUPPL_ATTR);
                this.attrEsc(buf, "name", name);
                this.attrEsc(buf, "value", v.toString());
                buf.append(CLOSE_ELEM);
            }
        }
        buf.append(START_MSG_TXT);
        if (this.m_escapeChars) {
            XMLUtil.escapeXMLchars(msgText, buf);
        } else {
            buf.append(msgText);
        }
        buf.append(CLOSE_MSG_TXT);
        if (msg.getMessageArgs() != null) {
            LogMessage.MessageArgument[] args = msg.getMessageArgs();
            for (int i = 0; i < args.length; ++i) {
                buf.append(START_MSG_ARG);
                if (args[i].getName() != null) {
                    this.attrEsc(buf, "name", args[i].getName());
                }
                this.attrEsc(buf, "value", args[i].getValue());
                buf.append(CLOSE_ELEM);
            }
        }
        if (supplDet != null) {
            buf.append(START_SUPPL_DETAIL);
            if (!this.m_escapeChars || this.checkChars(supplDet)) {
                buf.append("<![CDATA[");
                buf.append(supplDet);
                buf.append("]]>");
            } else {
                XMLUtil.escapeXMLchars(supplDet, buf);
            }
            buf.append(CLOSE_SUPPL_DETAIL);
        }
        buf.append(CLOSE_MSG);
        return buf.toString();
    }

    @Override
    public String header() {
        if (this.m_useHeadAndTail) {
            return HEAD;
        }
        return "";
    }

    @Override
    public String tail() {
        if (this.m_useHeadAndTail) {
            return TAIL;
        }
        return "";
    }

    private final void attr(StringBuilder buf, String tag, String value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        buf.append(value);
        buf.append("'");
    }

    private final void attrEsc(StringBuilder buf, String tag, String value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        XMLUtil.escapeAttrChars(value, buf);
        buf.append("'");
    }

    private final void attr(StringBuilder buf, String tag, int value) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        buf.append(value);
        buf.append("'");
    }

    private final void attr(StringBuilder buf, String tag, long time) {
        buf.append(" ");
        buf.append(tag);
        buf.append("='");
        this.m_timeFmt.format(time, buf);
        buf.append("'");
    }

    private boolean checkChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ((ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') && (ch != ']' || i + 2 >= len || str.charAt(i + 1) != ']' || str.charAt(i + 2) != '>')) continue;
            return false;
        }
        return true;
    }
}

