/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.MessageType;

public class LogMessage
implements Serializable {
    static final int MAX_LEVEL = 32;
    public static final String ORGANIZATION_ID = "ORG_ID";
    public static final String COMPONENT_ID = "COMPONENT_ID";
    public static final String INSTANCE_ID = "INSTANCE_ID";
    public static final String MESSAGE_ID = "MSG_ID";
    public static final String HOSTING_CLIENT_ID = "HOSTING_CLIENT_ID";
    public static final String MESSAGE_TYPE = "MSG_TYPE";
    public static final String MESSAGE_GROUP = "MSG_GROUP";
    public static final String MESSAGE_LEVEL = "MSG_LEVEL";
    public static final String MODULE_ID = "MODULE_ID";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String THREAD_ID = "THREAD_ID";
    public static final String USER_ID = "USER_ID";
    public static final String SUPPL_ATTRS = "SUPPL_ATTRS";
    public static final String SUPPL_ATTR_NAME = "SUPPL_ATTR.NAME";
    public static final String SUPPL_ATTR_VALUE = "SUPPL_ATTR.VALUE";
    public static final String UPSTREAM_COMPONENT_ID = "UPSTREAM_COMPONENT_ID";
    public static final String DOWNSTREAM_COMPONENT_ID = "DOWNSTREAM_COMPONENT_ID";
    public static final String EXEC_CONTEXT_UNIQUE_ID = "EXEC_CONTEXT_UNIQUE_ID";
    public static final String EXEC_CONTEXT_SEQ = "EXEC_CONTEXT_SEQ";
    public static final String EXEC_CONTEXT_RID = "EXEC_CONTEXT_RID";
    public static final String ERROR_UNIQUE_ID = "ERROR_UNIQUE_ID";
    public static final String ERROR_SEQ = "ERROR_SEQ";
    public static final String MESSAGE_TEXT = "MSG_TEXT";
    public static final String MSG_ARGS = "MSG_ARGS";
    public static final String MSG_ARG_NAME = "NAME";
    public static final String MSG_ARG_VALUE = "VALUE";
    public static final String DETAIL_LOCATION = "DETAIL_PATH";
    public static final String SUPPL_DETAIL = "SUPPL_DETAIL";
    public static final String TSTZ = "TSTZ_ORIGINATING";
    public static final String TSTZ_ORIGINATING = "TSTZ_ORIGINATING";
    public static final String TSTZ_NORMALIZED = "TSTZ_NORMALIZED";
    public static final String HOST_ID = "HOST_ID";
    public static final String HOST_NWADDR = "HOST_NWADDR";
    public static final String PROBLEM_KEY = "PROB_KEY";
    public static final String SUPPL_ATTR_PREFIX = "SUPPL_ATTR.";
    static final long serialVersionUID = -189888222135417808L;
    private static final String ORG_ID_PROP = "OrganizationId";
    private static final String COMP_ID_PROP = "ComponentId";
    private static final String HOST_CLIENT_ID_PROP = "HostingClientId";
    private static final String INSTANCE_ID_PROP = "InstanceId";
    private static HashMap s_messageProperties;
    private static String s_defaultOrganizationId;
    private static String s_defaultComponentId;
    private static String s_defaultHostingClientId;
    private static String s_hostId;
    private static String s_hostNwAddr;
    private static String s_defaultUserId;
    private static String s_defaultInstanceId;
    private long m_timestamp;
    private long m_timestampNorm;
    private String m_organizationId;
    private String m_componentId;
    private String m_instanceId;
    private String m_messageId;
    private String m_hostingClientId;
    private MessageType m_messageType;
    private String m_messageGroup;
    private int m_messageLevel;
    private String m_hostId;
    private String m_hostNwAddr;
    private String m_moduleId;
    private String m_processId;
    private String m_userId;
    private String m_problemKey;
    private Map m_supplAttrs;
    private String m_upstreamCompId;
    private String m_downstreamCompId;
    private InstanceId m_execContextId;
    private InstanceId m_errorInstanceId;
    private String m_messageText;
    private MessageArgument[] m_messageArgs;
    private String m_detailLocation;
    private String m_supplDetail;
    private String m_threadId;

    public LogMessage(String organizationId, String componentId, String messageId, String hostingClientId, MessageType messageType, String messageGroup, int messageLevel, String moduleId, String processId, String userId, String upstreamCompId, String downstreamCompId, InstanceId execContextId, InstanceId errorInstanceId, String messageText, MessageArgument[] messageArgs, String detailLocation, String supplDetail) {
        this.m_timestamp = System.currentTimeMillis();
        this.m_organizationId = organizationId != null ? organizationId : s_defaultOrganizationId;
        if (componentId != null) {
            this.m_componentId = componentId;
        } else if (s_defaultComponentId != null) {
            this.m_componentId = s_defaultComponentId;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Missing value for componentId"));
            this.m_componentId = null;
        }
        this.m_instanceId = s_defaultInstanceId;
        this.m_messageId = messageId;
        this.m_hostingClientId = hostingClientId != null ? hostingClientId : s_defaultHostingClientId;
        this.m_messageType = messageType;
        this.m_messageGroup = messageGroup;
        if (messageLevel >= 1 && messageLevel <= 32) {
            this.m_messageLevel = messageLevel;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Invalid message level"));
            this.m_messageLevel = 16;
        }
        this.m_hostId = s_hostId;
        this.m_hostNwAddr = s_hostNwAddr;
        this.m_moduleId = moduleId;
        if (processId != null) {
            this.m_processId = processId;
            this.m_threadId = null;
        } else {
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
        }
        this.m_userId = userId != null ? userId : s_defaultUserId;
        this.m_upstreamCompId = upstreamCompId;
        this.m_downstreamCompId = downstreamCompId;
        this.m_execContextId = execContextId;
        this.m_errorInstanceId = errorInstanceId;
        this.m_messageText = messageText;
        this.m_messageArgs = messageArgs;
        this.m_detailLocation = detailLocation;
        this.m_supplDetail = supplDetail;
    }

    public LogMessage() {
        this(true);
    }

    public LogMessage(boolean initDefaults) {
        if (initDefaults) {
            this.m_timestamp = System.currentTimeMillis();
            this.m_organizationId = s_defaultOrganizationId;
            this.m_componentId = s_defaultComponentId;
            this.m_instanceId = s_defaultInstanceId;
            this.m_hostingClientId = s_defaultHostingClientId;
            this.m_messageType = MessageType.UNKNOWN;
            this.m_messageLevel = 16;
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
            this.m_hostId = s_hostId;
            this.m_hostNwAddr = s_hostNwAddr;
            this.m_userId = s_defaultUserId;
        } else {
            this.m_messageLevel = 1;
        }
    }

    public LogMessage(Properties props) {
        String errUId;
        String typeName;
        if (props == null) {
            this.m_organizationId = s_defaultOrganizationId;
            this.m_componentId = s_defaultComponentId;
            this.m_hostingClientId = s_defaultHostingClientId;
            this.m_messageType = MessageType.UNKNOWN;
            this.m_messageLevel = 16;
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
            this.m_userId = s_defaultUserId;
            return;
        }
        StringBuffer supplDet = null;
        String str = props.getProperty("TSTZ_ORIGINATING");
        if (str == null) {
            this.m_timestamp = System.currentTimeMillis();
        } else {
            try {
                this.m_timestamp = Long.parseLong(str);
            }
            catch (Exception e) {
                this.m_timestamp = System.currentTimeMillis();
                supplDet = new StringBuffer(str);
            }
        }
        str = props.getProperty(TSTZ_NORMALIZED);
        if (str != null) {
            try {
                this.m_timestampNorm = Long.parseLong(str);
            }
            catch (Exception e) {
                this.m_timestampNorm = 0L;
            }
        }
        this.m_hostId = props.getProperty(HOST_ID);
        if (this.m_hostId == null) {
            this.m_hostId = s_hostId;
        }
        this.m_hostNwAddr = props.getProperty(HOST_NWADDR);
        if (this.m_hostNwAddr == null) {
            this.m_hostNwAddr = s_hostNwAddr;
        }
        this.m_organizationId = props.getProperty(ORGANIZATION_ID);
        if (this.m_organizationId == null) {
            this.m_organizationId = s_defaultOrganizationId;
        }
        this.m_componentId = props.getProperty(COMPONENT_ID);
        if (this.m_componentId == null) {
            this.m_componentId = s_defaultComponentId;
        }
        this.m_instanceId = props.getProperty(INSTANCE_ID);
        if (this.m_instanceId == null) {
            this.m_instanceId = s_defaultInstanceId;
        }
        this.m_messageId = props.getProperty(MESSAGE_ID);
        this.m_hostingClientId = props.getProperty(HOSTING_CLIENT_ID);
        if (this.m_hostingClientId == null) {
            this.m_hostingClientId = s_defaultHostingClientId;
        }
        this.m_messageType = (typeName = props.getProperty(MESSAGE_TYPE)) != null ? MessageType.getMessageType(typeName) : MessageType.UNKNOWN;
        this.m_messageGroup = props.getProperty(MESSAGE_GROUP);
        String msgLevel = props.getProperty(MESSAGE_LEVEL);
        try {
            this.m_messageLevel = Integer.parseInt(msgLevel);
        }
        catch (Exception e) {
            this.m_messageLevel = 16;
        }
        if (this.m_messageLevel <= 0 || this.m_messageLevel > 32) {
            this.m_messageLevel = 16;
        }
        this.m_moduleId = props.getProperty(MODULE_ID);
        this.m_processId = props.getProperty(PROCESS_ID);
        if (this.m_processId == null) {
            this.m_processId = LogMessage.getDefaultProcessId();
        }
        this.m_threadId = props.getProperty(THREAD_ID);
        if (this.m_threadId == null) {
            this.m_threadId = Thread.currentThread().getName();
        }
        this.m_userId = props.getProperty(USER_ID);
        if (this.m_userId == null) {
            this.m_userId = s_defaultUserId;
        }
        this.m_problemKey = props.getProperty(PROBLEM_KEY);
        this.m_upstreamCompId = props.getProperty(UPSTREAM_COMPONENT_ID);
        this.m_downstreamCompId = props.getProperty(DOWNSTREAM_COMPONENT_ID);
        String exec = props.getProperty(EXEC_CONTEXT_UNIQUE_ID);
        if (exec != null) {
            String rid = props.getProperty(EXEC_CONTEXT_SEQ);
            if (rid == null) {
                rid = props.getProperty(EXEC_CONTEXT_SEQ);
            }
            this.m_execContextId = new InstanceId(exec, rid);
        }
        if ((errUId = props.getProperty(ERROR_UNIQUE_ID)) != null) {
            int seq;
            String strSeq = props.getProperty(ERROR_SEQ);
            if (strSeq != null) {
                try {
                    seq = Integer.parseInt(strSeq);
                }
                catch (Exception e) {
                    seq = 0;
                }
            } else {
                seq = 0;
            }
            this.m_errorInstanceId = new InstanceId(errUId, seq);
        }
        this.m_messageText = props.getProperty(MESSAGE_TEXT);
        this.m_detailLocation = props.getProperty(DETAIL_LOCATION);
        str = props.getProperty(SUPPL_DETAIL);
        if (str != null) {
            if (supplDet != null) {
                supplDet.append(str);
            } else {
                supplDet = new StringBuffer(str);
            }
        }
        ArrayList<MessageArgument> msgArgs = null;
        int i = 0;
        while (true) {
            String valueProp;
            String value;
            if ((value = props.getProperty(valueProp = "MSG_ARGS." + i + "." + MSG_ARG_VALUE)) == null) {
                if (msgArgs == null) break;
                MessageArgument[] args = new MessageArgument[msgArgs.size()];
                this.setMessageArgs(msgArgs.toArray(args));
                break;
            }
            String nameProp = "MSG_ARGS." + i + "." + MSG_ARG_NAME;
            String name = props.getProperty(nameProp);
            MessageArgument arg = new MessageArgument(name, value);
            if (msgArgs == null) {
                msgArgs = new ArrayList<MessageArgument>();
            }
            msgArgs.add(arg);
            ++i;
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if (s_messageProperties.containsKey(name) || name.startsWith(MSG_ARGS)) continue;
            if (this.m_supplAttrs == null) {
                this.m_supplAttrs = new HashMap();
            }
            this.m_supplAttrs.put(name, props.getProperty(name));
        }
        this.m_supplDetail = supplDet != null ? supplDet.toString() : null;
    }

    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setNormalizedTimestamp(long timestamp) {
        this.m_timestampNorm = timestamp;
    }

    public void setOrganizationId(String organizationId) {
        this.m_organizationId = organizationId;
    }

    public void setComponentId(String componentId) {
        this.m_componentId = componentId;
    }

    public void setInstanceId(String instanceId) {
        this.m_instanceId = instanceId;
    }

    public void setMessageId(String messageId) {
        this.m_messageId = messageId;
    }

    public void setHostingClientId(String hostingClientId) {
        this.m_hostingClientId = hostingClientId;
    }

    public void setMessageType(MessageType messageType) {
        this.m_messageType = messageType;
    }

    public void setMessageGroup(String messageGroup) {
        this.m_messageGroup = messageGroup;
    }

    public void setMessageLevel(int messageLevel) {
        if (messageLevel >= 1 && messageLevel <= 32) {
            this.m_messageLevel = messageLevel;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Invalid message level"));
            this.m_messageLevel = 16;
        }
    }

    public void setHostId(String hostId) {
        this.m_hostId = hostId;
    }

    public void setHostNwAddr(String hostNwAddr) {
        this.m_hostNwAddr = hostNwAddr;
    }

    public void setModuleId(String moduleId) {
        this.m_moduleId = moduleId;
    }

    public void setProcessId(String processId) {
        this.m_processId = processId;
    }

    public void setThreadId(String threadId) {
        this.m_threadId = threadId;
    }

    public void setUserId(String userId) {
        this.m_userId = userId;
    }

    public void setProblemKey(String problemKey) {
        this.m_problemKey = problemKey;
    }

    public void setSupplAttrs(Map supplAttrs) {
        this.m_supplAttrs = supplAttrs;
    }

    public void setUpstreamCompId(String upstreamCompId) {
        this.m_upstreamCompId = upstreamCompId;
    }

    public void setDownstreamCompId(String downstreamCompId) {
        this.m_downstreamCompId = downstreamCompId;
    }

    public void setExecContextId(InstanceId execContextId) {
        this.m_execContextId = execContextId;
    }

    public void setErrorInstanceId(InstanceId errorInstanceId) {
        this.m_errorInstanceId = errorInstanceId;
    }

    public void setMessageText(String messageText) {
        this.m_messageText = messageText;
    }

    public void setMessageArgs(MessageArgument[] messageArgs) {
        this.m_messageArgs = messageArgs;
    }

    public void setDetailLocation(String detailLocation) {
        this.m_detailLocation = detailLocation;
    }

    public void setSupplementalDetail(String supplementalDetail) {
        this.m_supplDetail = supplementalDetail;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public long getNormalizedTimestamp() {
        return this.m_timestampNorm;
    }

    public String getOrganizationId() {
        return this.m_organizationId;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public String getInstanceId() {
        return this.m_instanceId;
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public String getHostingClientId() {
        return this.m_hostingClientId;
    }

    public MessageType getMessageType() {
        return this.m_messageType;
    }

    public String getMessageGroup() {
        return this.m_messageGroup;
    }

    public int getMessageLevel() {
        return this.m_messageLevel;
    }

    public String getHostId() {
        return this.m_hostId;
    }

    public String getHostNwAddr() {
        return this.m_hostNwAddr;
    }

    public String getModuleId() {
        return this.m_moduleId;
    }

    public String getProcessId() {
        return this.m_processId;
    }

    public String getUserId() {
        return this.m_userId;
    }

    public String getProblemKey() {
        return this.m_problemKey;
    }

    public Map getSupplAttrs() {
        return this.m_supplAttrs;
    }

    public String getUpstreamCompId() {
        return this.m_upstreamCompId;
    }

    public String getDownstreamCompId() {
        return this.m_downstreamCompId;
    }

    public InstanceId getExecContextId() {
        return this.m_execContextId;
    }

    public InstanceId getErrorInstanceId() {
        return this.m_errorInstanceId;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public MessageArgument[] getMessageArgs() {
        return this.m_messageArgs;
    }

    public String getDetailLocation() {
        return this.m_detailLocation;
    }

    public String getSupplDetail() {
        return this.m_supplDetail;
    }

    public String getThreadId() {
        return this.m_threadId;
    }

    static void initDefaultValues() {
        LogManager mgr = LogManager.getLogManager();
        s_defaultOrganizationId = mgr.getProperty(ORG_ID_PROP, null);
        s_defaultComponentId = mgr.getProperty(COMP_ID_PROP, null);
        s_defaultHostingClientId = mgr.getProperty(HOST_CLIENT_ID_PROP, null);
        s_defaultInstanceId = mgr.getProperty(INSTANCE_ID_PROP, null);
    }

    private static void init() {
        try {
            s_hostId = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LogManager.getLogManager().getExceptionHandler().onException(e);
            s_hostId = null;
        }
        try {
            s_hostNwAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LogManager.getLogManager().getExceptionHandler().onException(e);
            s_hostNwAddr = null;
        }
        try {
            s_defaultUserId = System.getProperty("user.name");
        }
        catch (Exception e) {
            s_defaultUserId = null;
        }
        s_messageProperties = new HashMap();
        s_messageProperties.put(ORGANIZATION_ID, "");
        s_messageProperties.put(COMPONENT_ID, "");
        s_messageProperties.put(INSTANCE_ID, "");
        s_messageProperties.put(MESSAGE_ID, "");
        s_messageProperties.put(HOSTING_CLIENT_ID, "");
        s_messageProperties.put(MESSAGE_TYPE, "");
        s_messageProperties.put(MESSAGE_GROUP, "");
        s_messageProperties.put(MESSAGE_LEVEL, "");
        s_messageProperties.put(MODULE_ID, "");
        s_messageProperties.put(PROCESS_ID, "");
        s_messageProperties.put(THREAD_ID, "");
        s_messageProperties.put(USER_ID, "");
        s_messageProperties.put(UPSTREAM_COMPONENT_ID, "");
        s_messageProperties.put(DOWNSTREAM_COMPONENT_ID, "");
        s_messageProperties.put(EXEC_CONTEXT_UNIQUE_ID, "");
        s_messageProperties.put(EXEC_CONTEXT_RID, "");
        s_messageProperties.put(ERROR_UNIQUE_ID, "");
        s_messageProperties.put(ERROR_SEQ, "");
        s_messageProperties.put(MESSAGE_TEXT, "");
        s_messageProperties.put(DETAIL_LOCATION, "");
        s_messageProperties.put(SUPPL_DETAIL, "");
        s_messageProperties.put("TSTZ_ORIGINATING", "");
        s_messageProperties.put(TSTZ_NORMALIZED, "");
        s_messageProperties.put(HOST_ID, "");
        s_messageProperties.put(HOST_NWADDR, "");
        s_messageProperties.put(PROBLEM_KEY, "");
    }

    static String getDefaultProcessId() {
        return LogManager.getLogManager().getProcessId();
    }

    static {
        s_defaultOrganizationId = null;
        s_defaultComponentId = null;
        s_defaultHostingClientId = null;
        s_hostId = null;
        s_hostNwAddr = null;
        s_defaultUserId = null;
        s_defaultInstanceId = null;
        LogMessage.init();
    }

    public static class InstanceId
    implements Serializable {
        private String m_uid;
        private String m_rid;
        private int m_sequenceNum;

        public InstanceId(String uniqueId, int sequenceNum) {
            this(uniqueId, String.valueOf(sequenceNum), sequenceNum);
        }

        public InstanceId(String uniqueId, String rid) {
            this(uniqueId, rid, 0);
        }

        InstanceId(String uniqueId, String rid, int sequenceNum) {
            this.m_uid = uniqueId;
            this.m_rid = rid;
            this.m_sequenceNum = sequenceNum;
        }

        public String getUniqueId() {
            return this.m_uid;
        }

        public String getRID() {
            return this.m_rid;
        }

        public int getSequenceNumber() {
            return this.m_sequenceNum;
        }
    }

    public static class MessageArgument
    implements Serializable {
        private String m_name;
        private String m_value;

        public MessageArgument(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

