/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;

public class ECID
extends LogMessage.InstanceId {
    private static final int MAX_UNIQUE_LEN = 64;

    public ECID() {
        super(ECID.createUniqueId(), "0");
    }

    public ECID(String uniqueId, int sequenceNumber) {
        super(uniqueId, sequenceNumber);
        if (uniqueId == null) {
            throw new NullPointerException();
        }
        ECID.checkValid(uniqueId);
        if (sequenceNumber < 0) {
            throw new IllegalArgumentException("ECID: illegal sequenceNumber");
        }
    }

    public ECID(String uniqueId, String rid) {
        super(uniqueId, rid);
        if (uniqueId == null) {
            throw new NullPointerException();
        }
        ECID.checkValid(uniqueId);
        ECID.checkValid(rid);
    }

    public ECID increment() {
        return new ECID(this.getUniqueId(), this.getSequenceNumber() + 1);
    }

    public ECID decrement() {
        return new ECID(this.getUniqueId(), this.getSequenceNumber() - 1);
    }

    public static ECID parse(String s) {
        int index = s.indexOf(44);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid ECID: " + s);
        }
        String uniqueId = s.substring(0, index);
        ECID.checkValid(uniqueId);
        if (++index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        String rid = s.substring(index);
        ECID.checkValid(rid);
        return new ECID(uniqueId, rid);
    }

    public String toString() {
        return this.getUniqueId() + "," + this.getRID();
    }

    private static void checkValid(String uniqueId) {
        if (uniqueId == null || uniqueId.length() == 0 || uniqueId.length() > 64 || uniqueId.indexOf(44) >= 0) {
            throw new IllegalArgumentException("Invalid ECID.uniqueId: " + uniqueId);
        }
    }

    private static String createUniqueId() {
        return LogManager.getLogManager().getUniqueId();
    }
}

