/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import oracle.core.ojdl.BusStopLogWriterException;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.FileLogWriterException;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.messages.Msgs;

public class BusStopLogWriter
extends FileLogWriter {
    private static final String LOG_FILE_NAME = "log.xml";
    private static final String SEGMENT_FILE_PREFIX = "log";
    private static final String SEGMENT_FILE_SUFFIX = ".xml";
    private static Hashtable s_instances = new Hashtable();

    private BusStopLogWriter(File logDir, File logFile, String canonicalPath, long maxSegmentSize, long maxSize, String encoding) throws FileLogWriterException {
        super(new ODL11Formatter(), logFile, logDir, true, canonicalPath, maxSegmentSize, maxSize, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusStopLogWriter create(String location, long maxSegmentSize, long maxSize, String encoding) throws BusStopLogWriterException {
        if (maxSegmentSize <= 0L) {
            throw new BusStopLogWriterException(Msgs.get("ODL-52002", "maxFileSize", maxSegmentSize));
        }
        if (maxSize <= 0L) {
            throw new BusStopLogWriterException(Msgs.get("ODL-52002", "maxLogSize", maxSize));
        }
        if (maxSize < maxSegmentSize) {
            throw new BusStopLogWriterException(Msgs.get("ODL-52003", maxSize, maxSegmentSize));
        }
        if (encoding != null) {
            LogManager.getLogManager();
            if (LogManager.checkEncoding(encoding) == null) {
                throw new BusStopLogWriterException(Msgs.get("ODL-52004", encoding));
            }
        } else {
            encoding = LogManager.getLogManager().getEncoding();
        }
        Class<FileLogWriter> clazz = FileLogWriter.class;
        synchronized (FileLogWriter.class) {
            String canonicalPath;
            File dir = BusStopLogWriter.getBusStopDir(location);
            File logFile = new File(dir, LOG_FILE_NAME);
            try {
                canonicalPath = logFile.getCanonicalPath();
            }
            catch (IOException e) {
                canonicalPath = logFile.getAbsolutePath();
            }
            FileLogWriter writer = BusStopLogWriter.getInstance(canonicalPath);
            if (writer == null) {
                try {
                    writer = new BusStopLogWriter(dir, logFile, canonicalPath, maxSegmentSize, maxSize, encoding);
                }
                catch (FileLogWriterException e) {
                    throw new BusStopLogWriterException(e);
                }
                BusStopLogWriter.putInstance(canonicalPath, writer);
            } else if (!(writer instanceof BusStopLogWriter)) {
                throw new BusStopLogWriterException(Msgs.get("ODL-52005", location));
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return (BusStopLogWriter)writer;
        }
    }

    public static BusStopLogWriter create(String location) throws BusStopLogWriterException {
        return BusStopLogWriter.create(location, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    private static File getBusStopDir(String name) throws BusStopLogWriterException {
        File logDir = null;
        if (name == null) {
            throw new BusStopLogWriterException(Msgs.get("ODL-52006", new Object[0]));
        }
        logDir = new File(name);
        try {
            if (logDir.exists()) {
                if (!logDir.isDirectory()) {
                    throw new BusStopLogWriterException(Msgs.get("ODL-52007", name));
                }
            } else if (!logDir.mkdirs()) {
                throw new BusStopLogWriterException(Msgs.get("ODL-52008", name));
            }
            if (!logDir.canWrite()) {
                throw new BusStopLogWriterException(Msgs.get("ODL-52009", name));
            }
        }
        catch (SecurityException e) {
            throw new BusStopLogWriterException(Msgs.get("ODL-52010", name));
        }
        return logDir;
    }
}

