/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import oracle.as.management.logging.LogMetaData;
import oracle.as.management.logging.impl.LogMetaDataUtil;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.loader.Registration;
import oracle.core.ojdl.query.Condition;
import oracle.core.ojdl.query.LogRepository;
import oracle.core.ojdl.query.LogRepositoryQuery;
import oracle.core.ojdl.query.LogResultSet;
import oracle.core.ojdl.query.SimpleCondition;
import oracle.core.ojdl.reader.LogRecord;

public class TraceDump {
    protected String m_instanceHome = System.getProperty("domain.home");
    private String m_target = System.getProperty("weblogic.Name");

    protected List<LogMetaData> getLogMetaData() throws Exception {
        return LogMetaDataUtil.getLogMetaDataForLocalInstance((String)this.m_instanceHome, (String)this.m_target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDump(String path, String traceId, long startTime, long stopTime) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "utf-8"));
        try {
            LogRepository rep = LogRepository.getInstanceAggregateRepository((String)this.m_instanceHome, (Registration)LogMetaDataUtil.toRegistration(this.getLogMetaData()), null, (boolean)false);
            LogRepositoryQuery q = rep.newQuery();
            this.setQueryParameters(q, traceId, startTime, stopTime);
            LogResultSet rs = q.executeQuery();
            ODLTextFormatter formatter = new ODLTextFormatter();
            while (rs.next()) {
                LogRecord rec = rs.getLogRecord();
                writer.write(formatter.format(rec.toLogMessage()));
            }
        }
        finally {
            writer.close();
        }
    }

    private void setQueryParameters(LogRepositoryQuery q, String traceId, long startTime, long stopTime) throws Exception {
        SimpleCondition c = new SimpleCondition("ODL_TRACE_ID", traceId, true, 1);
        q.setCondition((Condition)c);
        q.setTimestampRange(startTime, stopTime);
    }
}

