/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import oracle.bm.util.ui.table.AbstractRenderer;
import oracle.bm.util.ui.table.CellUtils;

public class StringRenderer
extends AbstractRenderer {
    private static final StringRenderer[] INSTANCES = new StringRenderer[3];

    protected StringRenderer(int canEdit) {
        super(CellUtils.createLabelRenderer(), canEdit);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        renderer.setText(value == null ? "" : value.toString());
        return renderer;
    }

    public static StringRenderer getStringRenderer(int canEdit) {
        return INSTANCES[canEdit];
    }

    static {
        StringRenderer.INSTANCES[0] = new StringRenderer(0);
        StringRenderer.INSTANCES[1] = new StringRenderer(1);
        StringRenderer.INSTANCES[2] = new StringRenderer(2);
    }
}

