/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.bm.util.ui.table.CellUtils;

public abstract class AbstractRenderer
implements TableCellRenderer {
    public static final int EDITABLE = 0;
    public static final int NON_EDITABLE = 1;
    public static final int USE_MODEL = 2;
    private JComponent m_renderer;
    private int m_canEdit;

    public AbstractRenderer(JComponent renderer, int canEdit) {
        if (renderer == null) {
            throw new IllegalArgumentException("Missing renderer");
        }
        if (canEdit < 0 || canEdit > 2) {
            throw new IllegalArgumentException("Illegal value for canEdit: " + canEdit);
        }
        this.m_renderer = renderer;
        this.m_canEdit = canEdit;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        CellUtils.setUpRenderer(this.m_renderer, table, isSelected, hasFocus, this.m_canEdit == 0 || hasFocus && this.m_canEdit == 2 && table.isCellEditable(row, column));
        return this.m_renderer;
    }
}

