/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bm.util.ui.RolloverJButton;
import oracle.bm.util.ui.RolloverJToggle;

public class CompositeToolButton
extends JComponent
implements ActionListener,
ChangeListener,
MouseListener {
    protected static ImageIcon s_ARROW = new ImageIcon(CompositeToolButton.loadArrow());
    protected JPopupMenu m_menu = new JPopupMenu();
    protected JMenuItem m_activeItem = null;
    protected boolean m_bAutoDefault = true;
    protected AbstractButton m_button = null;

    public CompositeToolButton() {
        this(false);
    }

    public CompositeToolButton(boolean bToggle) {
        this.m_button = bToggle ? new RolloverJToggle() : new RolloverJButton();
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.add(this.m_button);
        this.add(new ArrowPanel());
        this.m_button.addActionListener(this);
        MyPopupButtonModel model = new MyPopupButtonModel(this.m_button, this.m_menu);
        this.m_button.setModel(model);
        this.m_button.setEnabled(false);
        this.m_button.addMouseListener(this);
    }

    public void addCompositeItem(JMenuItem item) {
        this.m_menu.add(item);
        item.addActionListener(this);
        item.addChangeListener(this);
        item.addItemListener((ItemListener)((Object)this.m_button.getModel()));
        if (this.m_activeItem == null) {
            this.setActiveItem(item);
            if (item.isEnabled()) {
                this.m_button.setEnabled(true);
            }
        }
    }

    public void addSeparator() {
        this.m_menu.addSeparator();
    }

    public AbstractButton getRealButton() {
        return this.m_button;
    }

    public JPopupMenu getPopupMenu() {
        return this.m_menu;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.m_button.isEnabled()) {
            ((MyPopupButtonModel)this.m_button.getModel()).__showPopup();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1001) {
            if (e.getSource() == this.m_button) {
                if (this.m_activeItem != null) {
                    try {
                        this.m_activeItem.doClick();
                    }
                    catch (Exception exception) {}
                }
            } else if (this.m_bAutoDefault) {
                this.setActiveItem((JMenuItem)e.getSource());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.m_button.isEnabled()) {
            if (this.m_activeItem.isEnabled()) {
                this.m_button.setEnabled(true);
            }
        } else if (this.m_activeItem != null && e.getSource() == this.m_activeItem && !this.m_activeItem.isEnabled()) {
            this.m_button.setEnabled(false);
        }
    }

    protected JMenuItem findNewActiveItem() {
        MenuElement[] elems = this.m_menu.getSubElements();
        for (int n = 0; n < elems.length; ++n) {
            Component component = elems[n].getComponent();
            if (!component.isEnabled() || !(component instanceof JMenuItem)) continue;
            return (JMenuItem)component;
        }
        return null;
    }

    protected synchronized void setActiveItem(JMenuItem item) {
        this.m_activeItem = item;
        this.m_button.setIcon(item.getIcon());
        this.m_button.setName(item.getName());
        this.m_button.setToolTipText(item.getToolTipText());
    }

    protected static Image loadArrow() {
        String strImage = "image/composite_tool_arrow.gif";
        Image imgNew = ImageUtils.getImageResource(CompositeToolButton.class, (String)strImage);
        if (ImageUtils.loadImage((Image)imgNew)) {
            return imgNew;
        }
        return ImageUtils.getNotLoadedImage();
    }

    private class MyPopupButtonModel
    extends DefaultButtonModel
    implements ItemListener {
        private AbstractButton _button;
        private JPopupMenu _popupMenu;
        private PopupMenuListener _pml;
        private Timer _timer;
        private boolean _bFiring = false;
        private static final int _POPUP_DELAY = 250;
        private boolean _selected = false;

        public MyPopupButtonModel(AbstractButton button) {
            this._button = button;
            Listen listen = new Listen();
            this._timer = new Timer(250, listen);
            this._timer.setRepeats(false);
            this._pml = listen;
        }

        public MyPopupButtonModel(AbstractButton button, JPopupMenu popup) {
            this(button);
            this.setPopupMenu(popup);
        }

        public JPopupMenu getPopupMenu() {
            return this._popupMenu;
        }

        public synchronized void setPopupMenu(JPopupMenu popupMenu) {
            if (popupMenu != this._popupMenu) {
                if (this._popupMenu != null) {
                    this._popupMenu.removePopupMenuListener(this._pml);
                }
                this._popupMenu = popupMenu;
                if (popupMenu != null) {
                    popupMenu.addPopupMenuListener(this._pml);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.isMenuItemMine(e.getItem())) {
                    this._selected = true;
                }
                this._button.repaint();
            } else if (e.getStateChange() == 2) {
                if (this.isMenuItemMine(e.getItem())) {
                    this._selected = false;
                }
                this._button.repaint();
            }
        }

        @Override
        public boolean isSelected() {
            return this._selected;
        }

        @Override
        public boolean isPressed() {
            return super.isPressed() || this._isMenuVisible();
        }

        @Override
        public boolean isArmed() {
            return super.isArmed() || this._isMenuVisible();
        }

        @Override
        public void setPressed(boolean isPressed) {
            if (isPressed != super.isPressed()) {
                super.setPressed(isPressed);
                if (isPressed) {
                    if (this._isMenuVisible()) {
                        this._hidePopup();
                    } else {
                        this._timer.start();
                    }
                } else {
                    this._timer.stop();
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled()) {
                if (!enabled) {
                    this.setArmed(false);
                    this.setPressed(false);
                }
                super.setEnabled(enabled);
            }
        }

        protected boolean isMenuItemMine(Object item) {
            MenuElement[] elems = this.getPopupMenu().getSubElements();
            for (int n = 0; n < elems.length; ++n) {
                Component component = elems[n].getComponent();
                if (item != component) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (this._isMenuVisible()) {
                return;
            }
            this._bFiring = true;
            super.fireActionPerformed(e);
            this._bFiring = false;
        }

        void __showPopup() {
            this.setArmed(false);
            super.setPressed(false);
            if (this._bFiring) {
                return;
            }
            JPopupMenu popup = this.getPopupMenu();
            if (popup != null) {
                MenuUtils.showPopupMenu((JPopupMenu)popup, (Component)this._button, (int)0, (int)this._button.getHeight());
            }
        }

        private void _hidePopup() {
            JPopupMenu popup = this.getPopupMenu();
            if (popup != null) {
                popup.setVisible(false);
            }
        }

        private boolean _isMenuVisible() {
            JPopupMenu popup = this.getPopupMenu();
            if (popup == null) {
                return false;
            }
            return popup.isVisible();
        }

        private class Listen
        implements ActionListener,
        PopupMenuListener {
            private Listen() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                MyPopupButtonModel.this.__showPopup();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MyPopupButtonModel.this._button.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }
    }

    private class ArrowPanel
    extends JPanel {
        public ArrowPanel() {
            this.setMaximumSize(new Dimension(s_ARROW.getIconWidth() * 2, 1024));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle bounds = this.getBounds();
            s_ARROW.paintIcon(this, g, 0, bounds.height - s_ARROW.getIconHeight() - 2);
        }
    }
}

