/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.util.HashMap;
import java.util.logging.Logger;
import oracle.ide.Version;

public final class LoggerUtils {
    private static HashMap<String, Long> _timingMap;
    private static int timingThreshold;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LoggerUtils() {
    }

    public static Logger getLoggerForClass(Class caller) {
        return Logger.getLogger(caller.getName());
    }

    private static String getTimingKey(String key) {
        if (!$assertionsDisabled && Version.DEBUG_BUILD == 0) {
            throw new AssertionError();
        }
        return Thread.currentThread().getName() + ":" + key;
    }

    public static void startTiming(Logger logger, String key, String msg, boolean quietStart) {
        if (Version.DEBUG_BUILD != 0) {
            LoggerUtils.startTiming(logger, key, msg, quietStart, true);
        }
    }

    public static synchronized void startTiming(Logger logger, String key, String msg, boolean quietStart, boolean prefixThread) {
        if (Version.DEBUG_BUILD != 0) {
            if (!quietStart) {
                LoggerUtils.printHeader(logger, msg);
            }
            String storeKey = prefixThread ? LoggerUtils.getTimingKey(key) : key;
            _timingMap.put(storeKey, System.nanoTime());
        }
    }

    public static void endTiming(Logger logger, String key, String msg, String indent, boolean quietStart) {
        if (Version.DEBUG_BUILD != 0) {
            LoggerUtils.endTiming(logger, key, msg, indent, quietStart, true, 0L);
        }
    }

    public static void endTiming(Logger logger, String key, String msg, String indent, boolean quietStart, long timeThreshold) {
        if (Version.DEBUG_BUILD != 0) {
            LoggerUtils.endTiming(logger, key, msg, indent, quietStart, true, timeThreshold);
        }
    }

    public static synchronized void endTiming(Logger logger, String key, String msg, String indent, boolean quietStart, boolean prefixThread) {
        if (Version.DEBUG_BUILD != 0) {
            LoggerUtils.endTiming(logger, key, msg, indent, quietStart, prefixThread, 0L);
        }
    }

    public static synchronized void endTiming(Logger logger, String key, String msg, String indent, boolean quietStart, boolean prefixThread, long timeThreshold) {
        if (Version.DEBUG_BUILD != 0) {
            String storeKey;
            long endTime = System.nanoTime();
            String string = storeKey = prefixThread ? LoggerUtils.getTimingKey(key) : key;
            if (msg != null) {
                if (!_timingMap.containsKey(storeKey)) {
                    logger.fine("Assert.endTiming could not find key: " + storeKey);
                    return;
                }
                long startTime = _timingMap.get(storeKey);
                long msElapsed = (endTime - startTime) / 1000000L;
                LoggerUtils.printTiming(logger, msElapsed, msg, indent, timeThreshold);
            }
            _timingMap.remove(storeKey);
        }
    }

    public static void printTiming(Logger logger, long time, String msg, String indent) {
        if (Version.DEBUG_BUILD != 0) {
            LoggerUtils.printTiming(logger, time, msg, indent, 0L);
        }
    }

    public static void printTiming(Logger logger, long time, String msg, String indent, long threshold) {
        if (Version.DEBUG_BUILD != 0 && time >= threshold && time > (long)LoggerUtils.printTimingThreshold()) {
            StringBuffer sb = new StringBuffer(10 + msg.length());
            sb.append("[").append(time).append("ms] ");
            while (sb.length() < 11) {
                sb.insert(0, " ");
            }
            if (indent == null || indent.length() == 0) {
                sb.append(msg);
            } else {
                sb.append(indent).append(msg);
            }
            logger.fine(sb.toString());
        }
    }

    public static void printHeader(Logger logger, String msg) {
        if (Version.DEBUG_BUILD != 0 && msg != null) {
            logger.fine("      [--] " + msg + "...");
        }
    }

    public static int printTimingThreshold() {
        if (timingThreshold == -2) {
            try {
                timingThreshold = Integer.valueOf(System.getProperty("PrintTimingThreshold", "50"));
                if (timingThreshold < 0) {
                    timingThreshold = -1;
                }
            }
            catch (Exception e) {
                timingThreshold = -1;
            }
        }
        return timingThreshold;
    }

    static {
        boolean bl = $assertionsDisabled = !LoggerUtils.class.desiredAssertionStatus();
        if (Version.DEBUG_BUILD != 0) {
            _timingMap = new HashMap();
        }
        timingThreshold = -2;
    }
}

