/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse.util;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.tree.TreeModel;
import oracle.bm.browse.util.ProxyTreeModel;

public class MultiTreeModel
extends ProxyTreeModel {
    private final TreeModel[] m_models;

    public MultiTreeModel(TreeModel[] models) {
        if (models == null || models.length == 0) {
            throw new IllegalArgumentException("Missing models");
        }
        this.m_models = models;
    }

    @Override
    protected RootNode createRoot() {
        return new RootNode();
    }

    private class MultiTreeListener
    extends ProxyTreeModel.ProxyListener {
        public MultiTreeListener(Object ... parents) {
            super(MultiTreeModel.this, parents);
        }

        @Override
        protected void updateRoot(Object oldRoot, Object newRoot) {
            ((RootNode)MultiTreeModel.this.getRoot()).updateRoot(oldRoot, newRoot);
        }
    }

    private class RootNode
    implements ProxyTreeModel.ProxyNode {
        private Object[] m_roots;

        private RootNode() {
            this.m_roots = new Object[MultiTreeModel.this.m_models.length];
            for (int i = MultiTreeModel.this.m_models.length - 1; i >= 0; --i) {
                Object root;
                TreeModel model = MultiTreeModel.this.m_models[i];
                if (model == null) {
                    throw new IllegalArgumentException("Missing model");
                }
                this.m_roots[i] = root = model.getRoot();
                MultiTreeModel.this.m_modelMappings.put(root, model);
                model.addTreeModelListener(new MultiTreeListener(this, root));
            }
            Arrays.sort(this.m_roots, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }

        @Override
        public Object getChild(int index) {
            return this.m_roots[index];
        }

        @Override
        public int getChildCount() {
            return this.m_roots.length;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getIndexOfChild(Object child) {
            for (int i = this.m_roots.length - 1; i >= 0; --i) {
                if (this.m_roots[i] != child) continue;
                return i;
            }
            return -1;
        }

        private void updateRoot(Object oldRoot, Object newRoot) {
            this.m_roots[this.getIndexOfChild((Object)oldRoot)] = newRoot;
        }
    }
}

