/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bm.browse.BrowseModelProvider;
import oracle.bm.browse.BrowseTreeModel;
import oracle.bm.browse.util.MultiTreeModel;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorHandlerManager;
import oracle.bm.javatools.util.MultivaluedMap;

public class BrowseModelManager {
    private FlavorHandlerManager<BrowseModelProvider> m_handlerManager;

    public BrowseModelManager(FlavorHandlerManager<BrowseModelProvider> handlerManager) {
        this.m_handlerManager = handlerManager;
    }

    public BrowseTreeModel createTreeModel(Transferable context, Flavor[] selectableFlavors) {
        MultivaluedMap<BrowseModelProvider, Flavor> providers = this.m_handlerManager.getHandlers(selectableFlavors);
        HashMap<BrowseModelProvider, TreeModel> models = new HashMap<BrowseModelProvider, TreeModel>();
        for (BrowseModelProvider provider : providers.keySet()) {
            Collection<Flavor> flavors = providers.get(provider);
            models.put(provider, provider.createTreeModel(context, flavors.toArray(new Flavor[flavors.size()])));
        }
        return models.isEmpty() ? new EmptyBrowseTreeModel() : new BrowseProviderTreeModel(models);
    }

    private class BrowseProviderTreeModel
    extends MultiTreeModel
    implements BrowseTreeModel {
        private Map<BrowseModelProvider, TreeModel> m_models;

        public BrowseProviderTreeModel(Map<BrowseModelProvider, TreeModel> models) {
            super(models.values().toArray(new TreeModel[models.size()]));
            this.m_models = models;
        }

        @Override
        public TreePath getPathForObject(Object object, Flavor flavor) {
            MultivaluedMap providers = BrowseModelManager.this.m_handlerManager.getHandlers(new Flavor[]{flavor});
            for (BrowseModelProvider provider : providers.keySet()) {
                TreePath path;
                TreeModel model = this.m_models.get(provider);
                if (model == null || !(model instanceof BrowseTreeModel) || (path = ((BrowseTreeModel)model).getPathForObject(object, flavor)) == null) continue;
                return this.findProxyPath(new TreePath(this.getRoot()).pathByAddingChild(model.getRoot()), path, model);
            }
            return null;
        }
    }

    private static class EmptyBrowseTreeModel
    extends DefaultTreeModel
    implements BrowseTreeModel {
        public EmptyBrowseTreeModel() {
            super(new DefaultMutableTreeNode());
        }

        @Override
        public TreePath getPathForObject(Object object, Flavor flavor) {
            return null;
        }
    }
}

