/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.ideimpl.vcs.VCSRecognizer;
import oracle.ideimpl.vcs.VCSRecognizers;

public final class VCSRecognizerHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "vcs-recognizer-hook");
    private static final ElementName ADMINISTRATIVE_PATH = new ElementName("http://xmlns.oracle.com/ide/extension", "administrative-path");
    private static final ElementName ENVIRONMENT_VARIABLE = new ElementName("http://xmlns.oracle.com/ide/extension", "environment-variable");
    private final ElementVisitor _administrativePathHandler = new AdministrativePathHandler();
    private final ElementVisitor _environmentVariableHandler = new EnvironmentVariableHandler();
    private static final String KEY_SCOPE_RECOGNIZER = "oide_vcs_recognizer";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ADMINISTRATIVE_PATH, this._administrativePathHandler);
        context.registerChildVisitor(ENVIRONMENT_VARIABLE, this._environmentVariableHandler);
        context.getScopeData().put(KEY_SCOPE_RECOGNIZER, VCSRecognizer.getInstance(context.getExtension().getID()));
    }

    public void end(ElementEndContext context) {
        VCSRecognizer recognizer = (VCSRecognizer)context.getScopeData().get(KEY_SCOPE_RECOGNIZER);
        VCSRecognizers.getInstance().register(recognizer);
    }

    private final class EnvironmentVariableHandler
    extends ElementVisitor {
        private EnvironmentVariableHandler() {
        }

        public final void start(ElementStartContext context) {
            String valueRegexp = context.getAttributeValue("value-regexp");
            if (valueRegexp != null) {
                VCSRecognizer recognizer = (VCSRecognizer)context.getScopeData().get(VCSRecognizerHook.KEY_SCOPE_RECOGNIZER);
                recognizer.setEnvironmentVariableValueRegexp(valueRegexp);
            }
        }

        public final void end(ElementEndContext context) {
            VCSRecognizer recognizer = (VCSRecognizer)context.getScopeData().get(VCSRecognizerHook.KEY_SCOPE_RECOGNIZER);
            recognizer.setEnvironmentVariableName(context.getText());
        }
    }

    private final class AdministrativePathHandler
    extends ElementVisitor {
        private AdministrativePathHandler() {
        }

        public final void end(ElementEndContext context) {
            VCSRecognizer recognizer = (VCSRecognizer)context.getScopeData().get(VCSRecognizerHook.KEY_SCOPE_RECOGNIZER);
            recognizer.setAdministrativePath(context.getText());
        }
    }
}

