/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.util.JDK;
import oracle.ideimpl.plaf.DefaultTreeCellRendererFocusFix;
import oracle.ideimpl.plaf.TreeUIHelper;

public class WindowsTreeUI
extends BasicTreeUI {
    protected TreeUIHelper helper;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.helper = new TreeUIHelper((JTree)c);
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.helper = null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.helper.installKeyboardActionsHook();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        if (JDK.HAS_BUG_4674205) {
            return new DefaultTreeCellRendererFocusFix();
        }
        return super.createDefaultCellRenderer();
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        this.drawDashedHorizontalLine(g, y, left, right);
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        this.drawDashedVerticalLine(g, x, top, bottom);
    }

    @Override
    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
            Rectangle visRect = this.tree.getVisibleRect();
            if (beginRow == endRow) {
                Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (scrollBounds != null) {
                    scrollBounds.x = visRect.x;
                    scrollBounds.width = visRect.width;
                    this.tree.scrollRectToVisible(scrollBounds);
                }
            } else {
                Rectangle beginRect;
                Rectangle testRect = beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                int beginY = beginRect.y;
                int maxY = beginY + visRect.height;
                for (int counter = beginRow + 1; counter <= endRow; ++counter) {
                    testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                    if (testRect.y + testRect.height <= maxY) continue;
                    counter = endRow;
                }
                this.tree.scrollRectToVisible(new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY));
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (WindowsTreeUI.this.tree != null && WindowsTreeUI.this.tree.isEnabled() && !event.isConsumed()) {
                if (JDK.HAS_BUG_MENU_RESTORES_WRONG_FOCUS) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
                WindowsTreeUI.this.tree.requestFocus();
                TreePath path = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.this.tree, event.getX(), event.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.this.tree, path);
                    if (event.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        WindowsTreeUI.this.checkForClickInExpandControl(path, event.getX(), event.getY());
                    }
                    if ((x = event.getX()) > bounds.x && x <= bounds.x + bounds.width && !WindowsTreeUI.this.startEditing(path, event)) {
                        if (WindowsTreeUI.this.tree.isPathSelected(path)) {
                            this.lastSelectedPath = path;
                        } else {
                            this.lastSelectedPath = null;
                            WindowsTreeUI.this.selectPathForEvent(path, event);
                        }
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreePath path;
            if (WindowsTreeUI.this.tree != null && WindowsTreeUI.this.tree.isEnabled() && !event.isConsumed() && (path = WindowsTreeUI.this.getClosestPathForLocation(WindowsTreeUI.this.tree, event.getX(), event.getY())) != null) {
                Rectangle bounds = WindowsTreeUI.this.getPathBounds(WindowsTreeUI.this.tree, path);
                if (event.getY() > bounds.y + bounds.height) {
                    return;
                }
                int x = event.getX();
                if (x > bounds.x && x <= bounds.x + bounds.width && path.equals(this.lastSelectedPath)) {
                    WindowsTreeUI.this.selectPathForEvent(path, event);
                }
            }
            this.lastSelectedPath = null;
        }
    }
}

