/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.WorkingSets;
import oracle.javatools.data.HashStructure;

public final class WorkingSetCustomizationHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "working-set-customizations");
    private static final String WS_DATA_KEY = "default-working-set";
    private static final String NAME_DATA_KEY = "name";
    private boolean initialized = false;
    private String _workingSetName = null;

    public static WorkingSetCustomizationHook get() {
        return (WorkingSetCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    @Override
    public void start(ElementStartContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.start(context);
        }
    }

    @Override
    public void end(ElementEndContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.end(context);
        }
    }

    public String getDefaultEditableWorkingSet() {
        if (!this.initialized) {
            this.initialize();
        }
        return this._workingSetName;
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    Logger.getLogger(WorkingSetCustomizationHook.class.getName()).log(Level.SEVERE, "The working-set-customizations hook can be used once, in the role file.");
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    HashStructure hash = e.getCombinedHashStructure();
                    HashStructure wsHash = hash.getHashStructure(WorkingSetCustomizationHook.WS_DATA_KEY);
                    if (wsHash != null) {
                        String name = wsHash.getString(WorkingSetCustomizationHook.NAME_DATA_KEY);
                        if (WorkingSets.validateName(name)) {
                            WorkingSetCustomizationHook.this._workingSetName = name;
                        } else {
                            Logger.getLogger(WorkingSetCustomizationHook.class.getName()).log(Level.SEVERE, name + " is not a valid working set name");
                        }
                    }
                }
            });
        }
    }
}

