/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.Version;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.migration.MigrationManagerImpl;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ArrayPairList;
import oracle.javatools.util.Pair;

public final class MigrationDialog
extends DetailDialog {
    private static final long serialVersionUID = -5754471162744200006L;
    private final JPanel contentPanel;
    private final ComponentWithTitlebar<JScrollPane> previousInstallationsPanel;
    private final JMultiLineLabel headerLabel1;
    private final JMultiLineLabel headerLabel2;
    private final JLabel versionLabel;
    private final JLabel availableInstallationsLabel;
    private final JList availableInstallationsList;
    private final VersionListModel availableSelectionListModel;
    private final transient Version currentVersion;
    private final boolean migrateFlag;
    private URL userDirectory;
    private URL systemDirectory = null;
    private final String product;
    private final JCheckBox userChoiceCheckBox;
    private final transient MigrationManagerImpl impl;

    public MigrationDialog(Frame parent, SortedMap<Version, String> availableInstallations, boolean migrateFlag, Version currentVersion, MigrationManagerImpl impl) {
        super(parent, IdeArb.getString(372), 19);
        super.setOKButtonText(StringUtils.stripMnemonic((String)DialogsArb.getString(2)));
        super.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsArb.getString(2)));
        super.setCancelButtonText(StringUtils.stripMnemonic((String)DialogsArb.getString(4)));
        super.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsArb.getString(4)));
        super.setResizable(false);
        this.currentVersion = currentVersion;
        this.migrateFlag = migrateFlag;
        this.impl = impl;
        this.userDirectory = URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
        this.product = ProductInformation.getProductInformation().getShortName();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        this.headerLabel1 = new JMultiLineLabel();
        this.headerLabel1.setText(migrateFlag ? IdeArb.getString(374) : IdeArb.getString(373));
        this.headerLabel1.setPreferredRows(2);
        this.headerLabel1.setPreferredColumns(60);
        this.headerLabel1.setVerticalShrinking(true);
        this.headerLabel1.setText(IdeArb.format(375, this.product));
        this.headerLabel1.setFont(this.headerLabel1.getFont().deriveFont(1));
        this.headerLabel2 = new JMultiLineLabel();
        this.headerLabel2.setPreferredColumns(60);
        this.headerLabel2.setPreferredRows(2);
        this.headerLabel2.setVerticalShrinking(true);
        this.headerLabel2.setFont(this.headerLabel2.getFont().deriveFont(0));
        if (availableInstallations.isEmpty() || migrateFlag) {
            this.headerLabel2.setText(IdeArb.format(505, currentVersion));
        } else {
            impl.setSourceVersion(availableInstallations.lastKey());
            this.headerLabel2.setText(IdeArb.format(374, availableInstallations.lastKey(), currentVersion));
        }
        this.contentPanel.add(iconLabel);
        this.contentPanel.add(Box.createHorizontalStrut(5));
        Box b1 = Box.createVerticalBox();
        b1.add((Component)((Object)this.headerLabel1));
        b1.add(Box.createVerticalStrut(10));
        b1.add((Component)((Object)this.headerLabel2));
        this.contentPanel.add(Box.createHorizontalStrut(5));
        this.contentPanel.add(b1);
        this.contentPanel.add(Box.createHorizontalStrut(10));
        super.setContent((Component)this.contentPanel);
        this.availableSelectionListModel = new VersionListModel(IdeArb.getString(504));
        TreeMap reverse = new TreeMap(Collections.reverseOrder());
        reverse.putAll(availableInstallations);
        for (Map.Entry entry : reverse.entrySet()) {
            this.availableSelectionListModel.addElement((Pair<Version, String>)new Pair((Object)((Version)entry.getKey()), (Object)((String)entry.getValue())));
        }
        this.availableInstallationsList = new JList(this.availableSelectionListModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (index > -1) {
                    String item = (String)((Pair)MigrationDialog.this.availableSelectionListModel.data.get(index)).getSecond();
                    return item;
                }
                return null;
            }
        };
        this.availableInstallationsList.setSelectionMode(0);
        this.availableInstallationsList.getSelectionModel().addListSelectionListener(new AvailableListSelectionListener());
        this.availableInstallationsLabel = new JLabel();
        this.availableInstallationsLabel.setFocusable(false);
        ResourceUtils.resLabel((JLabel)this.availableInstallationsLabel, (Component)this.availableInstallationsList, (String)IdeArb.format(501, this.product));
        JScrollPane listScrollPane = new JScrollPane(this.availableInstallationsList);
        listScrollPane.setOpaque(true);
        listScrollPane.setVerticalScrollBarPolicy(20);
        this.versionLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.versionLabel, (Component)this.availableInstallationsList, (String)IdeArb.getString(376));
        ControlBar cb = new ControlBar();
        cb.add((Action)new BrowseButtonAction());
        this.previousInstallationsPanel = new ComponentWithTitlebar((JComponent)listScrollPane, this.availableInstallationsLabel, cb);
        Box userChoiceBox = new Box(0);
        userChoiceBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.userChoiceCheckBox = new JCheckBox(IdeArb.getString(506));
        userChoiceBox.add(this.userChoiceCheckBox);
        userChoiceBox.add(Box.createHorizontalGlue());
        super.setButtonTextWhenDetailsHidden(IdeArb.getString(502), true);
        super.setButtonTextWhenDetailsShown(IdeArb.getString(503), false);
        super.setDetailContent(this.previousInstallationsPanel);
        if (availableInstallations.isEmpty() || migrateFlag) {
            super.setOKButtonEnabled(false);
            super.setDetailVisible(true);
        } else {
            this.availableInstallationsList.setSelectedIndex(0);
            this.availableInstallationsList.getSelectionModel().setSelectionInterval(0, 0);
            this.availableInstallationsList.ensureIndexIsVisible(this.availableInstallationsList.getSelectedIndex());
            this.systemDirectory = URLFactory.newFileURL((String)this.availableSelectionListModel.getPathAt(this.availableInstallationsList.getSelectedIndex()));
            super.setOKButtonEnabled(true);
            super.setInitialFocus(1);
        }
    }

    public File sourceSelected() {
        if (this.systemDirectory != null) {
            return new File(this.systemDirectory.getPath());
        }
        return null;
    }

    public boolean userChoiceCheckBoxIsSelelected() {
        return this.userChoiceCheckBox.isSelected();
    }

    class AvailableListSelectionListener
    implements ListSelectionListener {
        AvailableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (lsm.isSelectionEmpty()) {
                MigrationDialog.super.setOKButtonEnabled(false);
            } else if (!isAdjusting) {
                int index = lsm.getMinSelectionIndex();
                Version selectedVersion = MigrationDialog.this.availableSelectionListModel.getVersionAt(index);
                MigrationDialog.this.impl.setSourceVersion(selectedVersion);
                MigrationDialog.this.headerLabel2.setText(IdeArb.format(374, selectedVersion, MigrationDialog.this.currentVersion));
                MigrationDialog.this.systemDirectory = URLFactory.newFileURL((String)MigrationDialog.this.availableSelectionListModel.getPathAt(index));
                MigrationDialog.super.setOKButtonEnabled(true);
            }
        }
    }

    class BrowseButtonAction
    extends AbstractAction {
        public BrowseButtonAction() {
            super(IdeArb.getString(515), OracleIcons.getIcon((String)"lov.png"));
            this.putValue("ShortDescription", IdeArb.getString(515));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URLChooser chooser = DialogUtil.newURLChooser(MigrationDialog.this.userDirectory);
            chooser.setShowJarsAsDirs(false);
            chooser.setSelectionScope(1);
            chooser.setHelpID(null);
            if (chooser.showOpenDialog((Component)((Object)MigrationDialog.this), IdeArb.format(384, MigrationDialog.this.product)) == 0) {
                try {
                    URL selectionTemp = chooser.getSelectedURL();
                    Version version = MigrationDialog.this.impl.versionFromFolderName(selectionTemp);
                    if (!MigrationDialog.this.availableSelectionListModel.hasVersion(version)) {
                        MigrationDialog.this.availableSelectionListModel.addElement((Pair<Version, String>)new Pair((Object)version, (Object)URLFileSystem.getPlatformPathName((URL)selectionTemp)));
                        MigrationDialog.this.impl.setSourceVersion(version);
                        MigrationDialog.this.availableInstallationsList.setSelectedValue(version, true);
                        MigrationDialog.this.systemDirectory = selectionTemp;
                    }
                }
                catch (Throwable ee) {
                    Logger logger = Logger.getLogger("MigrationDialog");
                    logger.log(Level.WARNING, "Invalid directory selected, ignoring selection", ee);
                    MigrationDialog.this.availableInstallationsList.clearSelection();
                }
            }
        }
    }

    class VersionListModel
    extends AbstractListModel {
        private ArrayPairList<Version, String> data = new ArrayPairList();
        private static final long serialVersionUID = -4030783181930726906L;
        private final String otherText;

        public VersionListModel(String otherText) {
            this.otherText = otherText;
        }

        public boolean isOther(String text) {
            if (text == this.otherText) {
                return true;
            }
            return text.equalsIgnoreCase(this.otherText);
        }

        public void addElement(Pair<Version, String> obj) {
            this.data.add(obj);
            super.fireIntervalAdded(obj, this.size() - 1, this.size());
        }

        public void insertElementAt(Pair<Version, String> obj, int index) {
            this.data.add(index - 1, obj);
            super.fireIntervalAdded(obj, index - 1, index);
        }

        public Object remove(int index) {
            Object obj = this.data.remove(index);
            super.fireIntervalRemoved(obj, index - 1, index);
            return obj;
        }

        public int size() {
            return this.data.size();
        }

        public Version get(int index) {
            return (Version)((Pair)this.data.get(index)).getFirst();
        }

        @Override
        public Version getElementAt(int index) {
            return this.getVersionAt(index);
        }

        public Version getVersionAt(int index) {
            return (Version)((Pair)this.data.get(index)).getFirst();
        }

        public String getPathAt(int index) {
            return (String)((Pair)this.data.get(index)).getSecond();
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        public boolean hasVersion(Version v) {
            return this.data.indexOfFirstType((Object)v) >= 0;
        }
    }
}

