/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ideimpl.memwatch.ConfFileUtils;
import oracle.ideimpl.memwatch.LowMemoryDetector;
import oracle.ideimpl.memwatch.MemoryArb;
import oracle.javatools.dialogs.BaseMessageDialog;

final class LowMemoryHandler {
    static final int TYPE_HEAP = 0;
    private static String heapConfPath;
    private static String confPath;

    LowMemoryHandler() {
    }

    static void handleLowMemory(int type, long current, long max) {
        if (LowMemoryDetector.DEBUG) {
            System.out.println("notifyManual");
        }
        LowMemoryHandler.notifyManual(type, current, max);
    }

    private static void notifyManual(int type, long current, long max) {
        SwingUtilities.invokeLater(WarningRunnable.manual(type, current, max));
    }

    private static String getConfFilePath(int type) {
        if (confPath == null && (confPath = (confPath = System.getProperty("user.conf")) != null ? confPath.replace("\"", "") : System.getProperty("ide.conf")) == null) {
            confPath = "";
        }
        if (confPath.isEmpty()) {
            return null;
        }
        if (type == 0) {
            if (heapConfPath == null) {
                File file = new File(confPath);
                if (file.exists()) {
                    List<String> incls = ConfFileUtils.getConfIncludes(file);
                    for (String incl : incls) {
                        if (!incl.endsWith("ide.conf")) continue;
                        File heapFile = new File(file.getParent(), incl);
                        try {
                            heapConfPath = heapFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            heapConfPath = heapFile.getAbsolutePath();
                        }
                        break;
                    }
                }
                if (heapConfPath == null) {
                    heapConfPath = confPath;
                }
            }
            return heapConfPath;
        }
        return null;
    }

    private static final class WarningRunnable
    implements Runnable {
        private final int type;
        private final long current;
        private final long max;

        static WarningRunnable manual(int type, long current, long max) {
            return new WarningRunnable(type, current, max);
        }

        private WarningRunnable(int type, long current, long max) {
            this.type = type;
            this.current = current;
            this.max = max;
        }

        @Override
        public void run() {
            if (LowMemoryDetector.DEBUG) {
                System.out.println("Warning about low memory");
            }
            if (this.type != 0) {
                if (LowMemoryDetector.DEBUG) {
                    System.out.println("Not TYPE_HEAP");
                }
                return;
            }
            String confPath = LowMemoryHandler.getConfFilePath(this.type);
            String message = null;
            if (confPath != null) {
                message = MemoryArb.getString(1);
                message = MessageFormat.format(message, this.current, this.max, confPath);
            } else {
                message = MemoryArb.getString(2);
                message = MessageFormat.format(message, this.current, this.max);
            }
            if (LowMemoryDetector.DEBUG) {
                System.out.println("message = " + message);
            }
            BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)((Object)Ide.getMainWindow()), (String)MemoryArb.getString(0), (int)2);
            dialog.setMessageText(message);
            dialog.runDialog();
        }
    }
}

