/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.ide.extension.ExtensionQueue;
import oracle.ide.extension.ExtensionQueueLoadStrategy;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.extension.ExemptedRunnable;
import oracle.ideimpl.extension.ExtensionLoaderThread;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.internal.ui.AbstractInvocationEventFilter;
import oracle.javatools.internal.ui.EventQueueFilter;
import oracle.javatools.internal.ui.EventQueueWrapper;

public class SwingWorkerExtensionQueueLoadStrategy
implements ExtensionQueueLoadStrategy {
    private Timer m_progressMonitor = new Timer(ISDONE_CHECK_INTERVAL, new ProgressMonitorActionListener());
    private final Component m_dialogParent;
    private DeterminateProgressMonitor m_monitor;
    private volatile ExtensionLoaderThread m_activity;
    private static int ISDONE_CHECK_INTERVAL = 100;
    private AtomicLong m_startTimestamp;
    private State m_feedbackState;
    private final EventQueueFilter m_extensionLoadingInvocationFilter = new ExtensionLoadingInvocationFilter();
    private AtomicBoolean m_hourGlassOn = new AtomicBoolean(false);
    private static final int NOFEEDBACK_DURATION = 1000;
    private static final int HOURGLASS_DURATION = 3000;
    private static final int MODAL_UP_FOR_LESS_THAN_A_SECOND_DURATION = 4000;

    public SwingWorkerExtensionQueueLoadStrategy() {
        this((Component)((Object)Ide.getMainWindow()));
    }

    public SwingWorkerExtensionQueueLoadStrategy(Component dialogParent) {
        assert (dialogParent != null);
        this.m_dialogParent = dialogParent;
    }

    @Override
    public void load(ExtensionQueue queueOfExtensions) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._loadOnEDT(queueOfExtensions);
        }
    }

    private void _loadOnEDT(ExtensionQueue queueOfExtensions) {
        this.m_monitor = new DeterminateProgressMonitor(this.m_dialogParent, IdeArb.getString(524), (Object)MessageFormat.format(IdeArb.getString(525), Ide.getProgramShortName()), MessageFormat.format(IdeArb.getString(526), "extensions"));
        this.m_monitor.setMaximum(100);
        this.m_monitor.setMillisToDecideToPopup(3000);
        this.m_monitor.setModal(true);
        this.m_monitor.setCancellable(false);
        this.m_startTimestamp = new AtomicLong(System.currentTimeMillis());
        this.m_activity = new ExtensionLoaderThread(queueOfExtensions, this.m_monitor.getPanel());
        this.m_activity.execute();
        this.m_progressMonitor.start();
        this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_hourGlassOn.set(true);
        this._setInvocationFilter();
        try {
            this.m_monitor.start();
        }
        finally {
            this._removeInvocationFilter();
        }
    }

    private synchronized State _updateAndGetState() {
        long timePassed = System.currentTimeMillis() - this.m_startTimestamp.get();
        this.m_feedbackState = timePassed < 1000L ? State.NOFEEDBACK : (timePassed < 3000L ? State.HOURGLASS : (timePassed < 4000L ? State.MODAL_UP_FOR_LESS_THAN_A_SECOND : State.MODAL_UP));
        return this.m_feedbackState;
    }

    boolean isRunning() {
        return this.m_activity != null;
    }

    private void _setInvocationFilter() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (queue instanceof EventQueueWrapper) {
            EventQueueWrapper wrapper = (EventQueueWrapper)queue;
            wrapper.setFilter(this.m_extensionLoadingInvocationFilter);
        }
    }

    private void _removeInvocationFilter() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (queue instanceof EventQueueWrapper) {
            EventQueueWrapper wrapper = (EventQueueWrapper)queue;
            wrapper.deliverPostponedEventsOnNextDispatch();
            wrapper.removeFilter(this.m_extensionLoadingInvocationFilter);
        }
    }

    private class ExtensionLoadingInvocationFilter
    extends AbstractInvocationEventFilter {
        private ExtensionLoadingInvocationFilter() {
        }

        public EventQueueFilter.Result filterInvocationEvent(EventQueueWrapper eventQueueWrapper, InvocationEvent invocationEvent, Runnable runnable) {
            EventQueueFilter.Result result = EventQueueFilter.Result.DELIVER_EVENT;
            if (runnable == null) {
                return result;
            }
            Class<?> runnableClass = runnable.getClass();
            if (this._isSystemClass(runnableClass)) {
                if (ExtensionLoadingInvocationFilter.isSwingTimerRunnable((Runnable)runnable)) {
                    for (ActionListener listener : ExtensionLoadingInvocationFilter.getSwingTimerActionListeners((Runnable)runnable)) {
                        Class<?> listenerClass = listener.getClass();
                        if (this._isSystemClass(listenerClass) || listenerClass == ProgressMonitorActionListener.class) continue;
                        result = EventQueueFilter.Result.POSTPONE_EVENT;
                        break;
                    }
                }
            } else {
                result = runnable instanceof ExemptedRunnable ? EventQueueFilter.Result.DELIVER_EVENT : EventQueueFilter.Result.POSTPONE_EVENT;
            }
            return result;
        }

        private boolean _isSystemClass(Class clazz) {
            String className = clazz.getName();
            return className.startsWith("java") || className.startsWith("com.sun.") || className.startsWith("sun");
        }
    }

    private static enum State {
        NOFEEDBACK,
        HOURGLASS,
        MODAL_UP_FOR_LESS_THAN_A_SECOND,
        MODAL_UP;

    }

    private class ProgressMonitorActionListener
    implements ActionListener {
        private ProgressMonitorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingWorkerExtensionQueueLoadStrategy.this.m_monitor.isCanceled()) {
                SwingWorkerExtensionQueueLoadStrategy.this.m_activity.cancel(true);
                SwingWorkerExtensionQueueLoadStrategy.this.m_monitor.close();
            } else if (SwingWorkerExtensionQueueLoadStrategy.this.m_activity.isDone()) {
                State state = SwingWorkerExtensionQueueLoadStrategy.this._updateAndGetState();
                switch (state) {
                    case NOFEEDBACK: 
                    case HOURGLASS: 
                    case MODAL_UP: {
                        if (SwingWorkerExtensionQueueLoadStrategy.this.m_hourGlassOn.get()) {
                            SwingWorkerExtensionQueueLoadStrategy.this.m_dialogParent.setCursor(Cursor.getDefaultCursor());
                        }
                        SwingWorkerExtensionQueueLoadStrategy.this.m_monitor.close();
                        SwingWorkerExtensionQueueLoadStrategy.this.m_progressMonitor.stop();
                        SwingWorkerExtensionQueueLoadStrategy.this.m_activity = null;
                    }
                }
            } else {
                State state = SwingWorkerExtensionQueueLoadStrategy.this._updateAndGetState();
                switch (state) {
                    case HOURGLASS: {
                        if (SwingWorkerExtensionQueueLoadStrategy.this.m_hourGlassOn.get()) break;
                        SwingWorkerExtensionQueueLoadStrategy.this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
                        SwingWorkerExtensionQueueLoadStrategy.this.m_hourGlassOn.set(true);
                        break;
                    }
                    case MODAL_UP: 
                    case MODAL_UP_FOR_LESS_THAN_A_SECOND: {
                        if (SwingWorkerExtensionQueueLoadStrategy.this.m_hourGlassOn.get()) break;
                        SwingWorkerExtensionQueueLoadStrategy.this.m_dialogParent.setCursor(Cursor.getPredefinedCursor(3));
                        SwingWorkerExtensionQueueLoadStrategy.this.m_hourGlassOn.set(true);
                    }
                }
                SwingWorkerExtensionQueueLoadStrategy.this.m_monitor.setProgress(SwingWorkerExtensionQueueLoadStrategy.this.m_activity.getProgress());
            }
        }
    }
}

