/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Element;

final class TransferableEditorTab
extends ArrayList
implements Transferable {
    public static final DataFlavor contextFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + TransferableEditorTab.class.getName(), "IDE Document Tab");
    private static final DataFlavor[] flavors = new DataFlavor[]{contextFlavor, DataFlavor.stringFlavor};
    private Context context;

    public TransferableEditorTab(Context context) {
        if (context == null) {
            return;
        }
        this.context = context;
        Element[] selection = context.getSelection();
        if (selection == null || selection.length < 1) {
            return;
        }
        this.ensureCapacity(selection.length);
        for (int i = 0; i < selection.length; ++i) {
            this.add(selection[i]);
        }
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        try {
            if (flavor.equals(contextFlavor)) {
                return this;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                String path = this.context.getNode().getURL().getPath();
                return path;
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor df : flavors) {
            if (!df.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

