/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.IteratorFilter;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class HashStructureStructuredPropertyAccess
implements StructuredPropertyAccess {
    private static final String NAME = "name";
    private static final String CHILDREN = "children";
    private final HashStructure hs;

    public HashStructureStructuredPropertyAccess(HashStructure hs) {
        this.hs = hs;
    }

    @Override
    public String getName() {
        return this.hs.getString(NAME);
    }

    @Override
    public void setName(String name) {
        this.hs.putString(NAME, name);
    }

    @Override
    public Iterator getChildNodes() {
        return this.children().iterator();
    }

    private ListStructure childListStructure() {
        return this.hs.getOrCreateListStructure(CHILDREN);
    }

    private List<HashStructureStructuredPropertyAccess> children() {
        ArrayList<HashStructureStructuredPropertyAccess> children = new ArrayList<HashStructureStructuredPropertyAccess>();
        for (Object o : this.childListStructure()) {
            if (!(o instanceof HashStructure)) continue;
            children.add(new HashStructureStructuredPropertyAccess((HashStructure)o));
        }
        return children;
    }

    @Override
    public Iterator getChildNodes(final String name) {
        return new IteratorFilter(this.getChildNodes()){

            @Override
            protected boolean isValid(Object o) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)o;
                return name.equals(child.getName());
            }
        };
    }

    @Override
    public StructuredPropertyAccess getChildNode(String name) {
        Iterator i = this.getChildNodes(name);
        if (!i.hasNext()) {
            return null;
        }
        return (StructuredPropertyAccess)i.next();
    }

    @Override
    public void insertChild(int position, StructuredPropertyAccess childNode) {
        this.childListStructure().add(position, (Object)HashStructureStructuredPropertyAccess.copyOf((StructuredPropertyAccess)childNode).hs);
    }

    @Override
    public void appendChild(StructuredPropertyAccess childNode) {
        this.childListStructure().add((Object)HashStructureStructuredPropertyAccess.copyOf((StructuredPropertyAccess)childNode).hs);
    }

    @Override
    public void removeChild(StructuredPropertyAccess childNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getProperties() {
        return new IteratorFilter(this.hs.persistentKeySet().iterator()){

            @Override
            protected boolean isValid(Object o) {
                return !HashStructureStructuredPropertyAccess.NAME.equals(o) && !HashStructureStructuredPropertyAccess.CHILDREN.equals(o);
            }
        };
    }

    @Override
    public void addAll(StructuredPropertyAccess other) {
        Iterator properties = other.getProperties();
        while (properties.hasNext()) {
            String key = (String)properties.next();
            String value = other.getProperty(key, null);
            this.setProperty(key, value);
        }
        Iterator childNodes = other.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
            this.appendChild(child);
        }
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Object property = this.hs.getObject(key);
        boolean ret = property != null ? Boolean.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    @Override
    public void setIntegerProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    @Override
    public int getIntegerProperty(String key, int defaultValue) {
        Object property = this.hs.getObject(key);
        int ret = property != null ? Integer.valueOf(property.toString()) : defaultValue;
        return ret;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.hs.getString(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        Object old = this.hs.getObject(key);
        this.hs.putString(key, value);
        return old;
    }

    @Override
    public Object removeProperty(String key) {
        Object old = this.hs.getObject(key);
        this.hs.remove(key);
        return old;
    }

    private static HashStructureStructuredPropertyAccess copyOf(StructuredPropertyAccess access) {
        Object o;
        HashStructureStructuredPropertyAccess copy = new HashStructureStructuredPropertyAccess(HashStructure.newInstance());
        copy.setName(access.getName());
        Iterator i = access.getChildNodes();
        while (i.hasNext()) {
            o = i.next();
            copy.appendChild((StructuredPropertyAccess)o);
        }
        i = access.getProperties();
        while (i.hasNext()) {
            o = i.next();
            copy.setProperty((String)o, access.getProperty((String)o, null));
        }
        return copy;
    }
}

