/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.layout.ViewId;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.ideimpl.docking.ProxyDockable;

@Deprecated
final class ProxyDockableFactory
implements DockableFactory {
    private MetaClass<DockableFactory> metaClass;
    private Map<ViewId, ProxyDockable> proxyDockables = new LinkedHashMap<ViewId, ProxyDockable>();
    private String factoryId;
    private DockableFactory dockableFactory;
    private boolean needToBeinstall;
    private DrawerConfig drawerConfig;

    ProxyDockableFactory(MetaClass<DockableFactory> metaClass, String factoryId) {
        this.metaClass = metaClass;
        this.factoryId = factoryId;
    }

    @Override
    public Dockable getDockable(ViewId viewId) {
        if (this.dockableFactory != null) {
            return this.dockableFactory.getDockable(viewId);
        }
        if (this.proxyDockables.get(viewId) == null) {
            this.proxyDockables.put(viewId, new ProxyDockable(viewId, this.factoryId, this));
        }
        return this.proxyDockables.get(viewId);
    }

    @Override
    public void install() {
        if (this.dockableFactory == null) {
            for (ProxyDockable proxyDockable : this.proxyDockables.values()) {
                if (proxyDockable.getDrawerWindow() == null || !proxyDockable.getDrawerWindow().drawerViews().contains(proxyDockable)) continue;
                proxyDockable.getDrawerWindow().show(proxyDockable);
            }
        }
        this.needToBeinstall = true;
    }

    synchronized Dockable getRealDockable(ViewId viewId) {
        if (this.dockableFactory != null) {
            if (this.needToBeinstall) {
                DockStationImpl.getInstance().executeInstall(this.dockableFactory);
                this.needToBeinstall = false;
            }
            return this.dockableFactory.getDockable(viewId);
        }
        this.activate();
        return this.dockableFactory.getDockable(viewId);
    }

    synchronized DockableFactory getRealDockableFactory() {
        if (this.dockableFactory != null) {
            return this.dockableFactory;
        }
        this.activate();
        return this.dockableFactory;
    }

    synchronized void setDrawerConfig(DrawerConfig drawerConfig) {
        this.drawerConfig = drawerConfig;
    }

    synchronized DrawerConfig getDrawerConfig() {
        return this.drawerConfig;
    }

    Collection<ProxyDockable> getProxyDockables() {
        return this.proxyDockables.values();
    }

    boolean isExtensionFullyLoaded() {
        return DockableFactoryHook.get().isExtensionFullyLoaded(this.factoryId);
    }

    private void activate() {
        try {
            this.dockableFactory = (DockableFactory)this.metaClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (this.needToBeinstall) {
            DockStationImpl.getInstance().executeInstall(this.dockableFactory);
            this.needToBeinstall = false;
        }
    }

    String getFactoryId() {
        return this.factoryId;
    }
}

