/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;

public abstract class DockableHolderImpl
implements DockableHolder {
    public final boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        Dockable dockable;
        switch (criteria.getSearchFor()) {
            case 3: {
                Object criteriaObject = criteria.getCriteria();
                if (criteriaObject == null || !criteriaObject.equals(this)) break;
                path.setParentHolder(this);
                return true;
            }
            case 2: {
                dockable = this.getDockable();
                Object criteriaObject = criteria.getCriteria();
                if (criteriaObject == null || !criteriaObject.equals(dockable)) break;
                path.setParentHolder(this);
                return true;
            }
        }
        dockable = this.getDockable();
        if (dockable instanceof DrawerDockableWindow) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable;
            List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
            for (int i = 0; i < containedHolders.size(); ++i) {
                DockableHolderImpl contained = (DockableHolderImpl)containedHolders.get(i);
                if (!contained.getDockablePath(path, criteria)) continue;
                path.setParentHolder(this);
                return true;
            }
        }
        return false;
    }

    public void getDockablePaths(List<DockablePath> dockablePaths) {
        int from = dockablePaths.size();
        DockablePath path = new DockablePath();
        dockablePaths.add(path);
        Dockable dockable = this.getDockable();
        if (dockable instanceof DrawerDockableWindow) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable;
            List<? extends DockableHolder> containedHolders = drawerDockableWindow.getContainedHolders();
            for (DockableHolderImpl dockableHolderImpl : containedHolders) {
                dockableHolderImpl.getDockablePaths(dockablePaths);
            }
        }
        int to = dockablePaths.size();
        for (int i = from; i < to; ++i) {
            DockablePath dockablePath = dockablePaths.get(i);
            dockablePath.setParentHolder(this);
        }
    }

    abstract void undock(DockablePath var1, int var2);

    public abstract void disposeComponent();
}

