/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import oracle.ide.util.BitField;

public class OneLineBorder
implements Border {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private int _sides;
    private Color _color;

    public OneLineBorder(int sides, Color color) {
        this._sides = sides;
        this._color = color;
    }

    private Color getLineColor(Component c) {
        return this._color != null ? this._color : c.getBackground().darker();
    }

    public void setLineColor(Color lineColor) {
        this._color = lineColor;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int sides) {
        this._sides = sides;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        Color lineColor = this.getLineColor(c);
        g.setColor(lineColor);
        if (BitField.isSet(this._sides, 1)) {
            g.drawLine(x, 0, x + width, 0);
        }
        if (BitField.isSet(this._sides, 2)) {
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
        if (BitField.isSet(this._sides, 4)) {
            g.drawLine(0, y, 0, y + height);
        }
        if (BitField.isSet(this._sides, 8)) {
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(BitField.isSet(this._sides, 1) ? 1 : 0, BitField.isSet(this._sides, 4) ? 1 : 0, BitField.isSet(this._sides, 2) ? 1 : 0, BitField.isSet(this._sides, 8) ? 1 : 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

