/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.menu.spi.ContextMenuHookHelper;
import javax.ide.menu.spi.MenuModel;
import javax.ide.util.MetaClass;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ideimpl.controller.SimpleRule;
import oracle.ideimpl.controller.SimpleRuleVisitor;
import oracle.ideimpl.jsr198.OracleActionRegistry;

public class ContextMenuHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "context-menu-hook");
    private static final ElementName SITE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "site");
    private static final ElementName EXTENSION_LISTENER_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "extension-listener");
    private static final ElementName INSERT_WHEN_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "insert-when");
    private static final ElementName MENU_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "menu");
    private static final String RULE_ATTRIBUTE_NAME = "rule";
    private ContextMenuHookHelper _helper = new ContextMenuHookHelper();
    private HashMap<String, List<HookData>> _siteToHook = new HashMap();
    private static final HashMap<String, BaseListener> _siteToListener = new HashMap(15);
    private SiteElementVisitor _siteVisitor = new SiteElementVisitor();
    private ExtensionListenerElementVisitor _listenerVisitor = new ExtensionListenerElementVisitor();
    private InsertWhenElementVisitor _insertWhenVisitor = new InsertWhenElementVisitor();
    private String _extensionId;
    private String[] _site;
    private MetaClass _metaListener;
    private SimpleRule _legacyRule;
    private String _ruleId;
    private boolean _error;
    private String _popupId;
    private MenuModel _menuModel;
    private HashMap<String, List<ExtensionListener>> _listeners = new HashMap();
    private SimpleRuleVisitor _visitor;

    private void clearHookData() {
        this._extensionId = null;
        this._site = null;
        this._metaListener = null;
        this._ruleId = null;
        this._legacyRule = null;
        this._error = false;
        this._popupId = null;
    }

    private boolean siteListenerAdded(String site) {
        return _siteToListener.containsKey(site);
    }

    private MetaClass getListenerForSite(String site) {
        BaseListener listener = _siteToListener.get(site);
        if (listener == null) {
            listener = new BaseListener(site);
            _siteToListener.put(site, listener);
        }
        return listener;
    }

    public void start(ElementStartContext context) {
        RuleEngine ruleEngine;
        this._extensionId = context.getExtension().getID();
        String possibleRuleId = this.getAttributeHelper(context, RULE_ATTRIBUTE_NAME, true, false);
        if (possibleRuleId != null && (ruleEngine = RuleEngine.getInstance()).validateRuleReference(possibleRuleId, (ElementContext)context)) {
            this._ruleId = possibleRuleId;
        }
        context.registerChildVisitor(SITE_ELEMENT, (ElementVisitor)this._siteVisitor);
        context.registerChildVisitor(EXTENSION_LISTENER_ELEMENT, (ElementVisitor)this._listenerVisitor);
        context.registerChildVisitor(INSERT_WHEN_ELEMENT, (ElementVisitor)this._insertWhenVisitor);
        context.registerChildVisitor(MENU_ELEMENT, (ElementVisitor)this._helper);
    }

    public void end(ElementEndContext context) {
        this._menuModel = this._helper.getMenuModel();
        this._popupId = this._helper.getPopupId();
        if (this._site == null) {
            this.error((ElementContext)context, "Missing <site> element");
        }
        if (this._legacyRule == null && this._ruleId == null) {
            this.error((ElementContext)context, "<context-menu-hook> requires a valid value for the rule attribute or the deprecated <insert-when> child element");
        }
        if (this._popupId == null) {
            this.error((ElementContext)context, "Missing <menu> element");
        }
        if (!this._error) {
            for (String site : this._site) {
                this.addHookData(site, new HookData(this._ruleId, this._legacyRule, this._popupId, this._metaListener, this._extensionId));
                if (this.siteListenerAdded(site)) continue;
                ContextMenuListenersHook cmlHook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
                cmlHook.addListenerForSite(site, this.getListenerForSite(site));
            }
        }
        this.clearHookData();
    }

    private void error(ElementContext context, String msg) {
        this.log(context, Level.SEVERE, msg);
        this._error = true;
    }

    private void error(String msg) {
        ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, msg);
    }

    private void addHookData(String site, HookData data) {
        List<HookData> list = this._siteToHook.get(site);
        if (list == null) {
            list = new ArrayList<HookData>(2);
            this._siteToHook.put(site, list);
        }
        list.add(data);
    }

    private ExtensionListener getExtensionListener(HookData data) {
        if (data.metaListener != null && data.listener == null) {
            ExtensionRegistry registry;
            String className = data.metaListener.getClassName();
            List<ExtensionListener> extensionListeners = this._listeners.get(data.extensionId);
            if (extensionListeners != null) {
                for (ExtensionListener listener : extensionListeners) {
                    if (!className.equals(listener.getClassName())) continue;
                    data.listener = listener;
                    break;
                }
            }
            if (data.listener == null && (registry = ExtensionRegistry.getExtensionRegistry()).isFullyLoaded(data.extensionId)) {
                try {
                    data.listener = new ExtensionListener(className, (ContextMenuListener)data.metaListener.newInstance());
                    if (extensionListeners == null) {
                        extensionListeners = new ArrayList<ExtensionListener>(2);
                        this._listeners.put(data.extensionId, extensionListeners);
                    }
                    extensionListeners.add(data.listener);
                }
                catch (ClassCastException e) {
                    this.error("context-menu-hook extension-listener " + className + " is not a ContextMenuListener");
                }
                catch (InstantiationException e) {
                    this.error("context-menu-hook extension-listener " + className + " cannot instantiate");
                }
                catch (IllegalAccessException e) {
                    this.error("context-menu-hook extension-listener " + className + " illegal access");
                }
                catch (ClassNotFoundException e) {
                    this.error("context-menu-hook extension-listener " + className + " class not found");
                }
            }
        }
        return data.listener;
    }

    private void doMenuWillShow(String site, ContextMenu popup) {
        ArrayList list = new ArrayList(this._siteToHook.get(site));
        for (HookData data : list) {
            this.doShow(data, popup.getContext(), popup);
        }
    }

    private void doShow(HookData data, Context context, ContextMenu popup) {
        if (data.evaluateRule(context)) {
            ExtensionListener extensionListener = this.getExtensionListener(data);
            if (extensionListener != null) {
                if (!extensionListener.isAlreadyShown()) {
                    data.listener.getContextMenuListener().menuWillShow(popup);
                    data.listener.setAlreadyShown();
                }
            } else {
                OracleActionRegistry registry = (OracleActionRegistry)OracleActionRegistry.getActionRegistry();
                registry.addToContextMenu(popup, data.popupId, this._menuModel);
            }
        }
    }

    private void doMenuWillHide(String site, ContextMenu popup) {
        ArrayList list = new ArrayList(this._siteToHook.get(site));
        for (HookData data : list) {
            this.doHide(data, popup);
        }
    }

    private void doHide(HookData data, ContextMenu popup) {
        ExtensionListener extensionListener;
        if (data.evaluateRule(popup.getContext()) && (extensionListener = this.getExtensionListener(data)) != null && !extensionListener.isAlreadyHidden()) {
            data.listener.getContextMenuListener().menuWillHide(popup);
            data.listener.setAlreadyHidden();
        }
    }

    private boolean doHandleDefaultAction(String site, Context context) {
        ArrayList list = new ArrayList(this._siteToHook.get(site));
        for (HookData data : list) {
            if (!this.doDefault(data, context)) continue;
            return true;
        }
        return false;
    }

    private boolean doDefault(HookData data, Context context) {
        ExtensionListener extensionListener;
        if (data.evaluateRule(context) && (extensionListener = this.getExtensionListener(data)) != null && !extensionListener.isAlreadyCalled()) {
            boolean handled = data.listener.getContextMenuListener().handleDefaultAction(context);
            data.listener.setAlreadyCalled();
            if (handled) {
                return true;
            }
        }
        return false;
    }

    private void addToList(String s, List<String> list, ElementContext context, String site) {
        if (s.length() == 0) {
            this.error(context, "Zero-length site name in idref=\"" + site + "\"");
        } else {
            list.add(s);
        }
    }

    static /* synthetic */ String[] access$802(ContextMenuHook x0, String[] x1) {
        x0._site = x1;
        return x1;
    }

    public static class BaseListener
    extends MetaClass<BaseListener>
    implements ContextMenuListener {
        private String site;
        ContextMenuHook hook;

        public BaseListener(String site) {
            super(BaseListener.class.getClassLoader(), BaseListener.class.getName());
            this.site = site;
        }

        public BaseListener newInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return this;
        }

        private ContextMenuHook getContextMenuHook() {
            if (this.hook == null) {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                this.hook = (ContextMenuHook)extensionRegistry.getHook(ELEMENT);
            }
            return this.hook;
        }

        @Override
        public void menuWillShow(ContextMenu contextMenu) {
            assert (this.site != null);
            this.getContextMenuHook().doMenuWillShow(this.site, contextMenu);
        }

        @Override
        public void menuWillHide(ContextMenu contextMenu) {
            assert (this.site != null);
            this.getContextMenuHook().doMenuWillHide(this.site, contextMenu);
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            assert (this.site != null);
            return this.getContextMenuHook().doHandleDefaultAction(this.site, context);
        }
    }

    private class InsertWhenElementVisitor
    extends ElementVisitor {
        private InsertWhenElementVisitor() {
        }

        public void start(ElementStartContext context) {
            if (ContextMenuHook.this._ruleId == null) {
                this.log((ElementContext)context, Level.WARNING, "Deprecated <insert-when> element encountered, instead use the rule attribute on <context-menu-hook>");
                ContextMenuHook.this._visitor = new SimpleRuleVisitor(context);
            } else {
                this.log((ElementContext)context, Level.WARNING, "Both the <context-menu-hook> rule attribute and <insert-when> child were provided, this <insert-when> will be ignored");
            }
        }

        public void end(ElementEndContext context) {
            if (ContextMenuHook.this._ruleId == null) {
                ContextMenuHook.this._legacyRule = ContextMenuHook.this._visitor.getRule();
                ContextMenuHook.this._visitor = null;
            }
        }
    }

    private class ExtensionListenerElementVisitor
    extends ElementVisitor {
        private ExtensionListenerElementVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null) {
                ContextMenuHook.this.error((ElementContext)context, "Missing attribute class");
            }
            ContextMenuHook.this._metaListener = new MetaClass(this.getMetaClassLoader((ElementContext)context), className);
        }
    }

    private class SiteElementVisitor
    extends ElementVisitor {
        private SiteElementVisitor() {
        }

        public void start(ElementStartContext context) {
            String site = context.getAttributeValue("idref");
            if (site == null) {
                ContextMenuHook.this.error((ElementContext)context, "Missing attribute idref");
            } else {
                int last = 0;
                ArrayList list = new ArrayList(3);
                int comma = site.indexOf(44);
                while (comma >= 0) {
                    String s = site.substring(last, comma).trim();
                    last = comma + 1;
                    ContextMenuHook.this.addToList(s, list, (ElementContext)context, site);
                    comma = site.indexOf(44, last);
                }
                String s = site.substring(last).trim();
                ContextMenuHook.this.addToList(s, list, (ElementContext)context, site);
                if (list.isEmpty()) {
                    ContextMenuHook.this.error((ElementContext)context, "No site ids in idref=\"" + site + "\"");
                } else {
                    ContextMenuHook.access$802(ContextMenuHook.this, list.toArray(new String[list.size()]));
                    if (ContextMenuHook.this._site.length > 1) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < ContextMenuHook.this._site.length; ++i) {
                            if (i > 0) {
                                sb.append("_");
                            }
                            sb.append(ContextMenuHook.this._site[i]);
                        }
                        ContextMenuHook.this._helper.setSite(sb.toString());
                    } else {
                        ContextMenuHook.this._helper.setSite(ContextMenuHook.this._site[0]);
                    }
                }
            }
        }
    }

    private static class ExtensionListener {
        private String className;
        private ContextMenuListener listener;
        private boolean alreadyCalled;
        private boolean alreadyShown;
        private boolean alreadyHidden;

        public ExtensionListener(String className, ContextMenuListener listener) {
            this.className = className;
            this.listener = listener;
        }

        public String getClassName() {
            return this.className;
        }

        public ContextMenuListener getContextMenuListener() {
            return this.listener;
        }

        public boolean isAlreadyCalled() {
            return this.alreadyCalled;
        }

        public void setAlreadyCalled() {
            if (!this.alreadyCalled) {
                this.alreadyCalled = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        alreadyCalled = false;
                    }
                });
            }
        }

        void setAlreadyShown() {
            if (!this.alreadyShown) {
                this.alreadyShown = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        alreadyShown = false;
                    }
                });
            }
        }

        boolean isAlreadyShown() {
            return this.alreadyShown;
        }

        void setAlreadyHidden() {
            if (!this.alreadyHidden) {
                this.alreadyHidden = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        alreadyHidden = false;
                    }
                });
            }
        }

        boolean isAlreadyHidden() {
            return this.alreadyHidden;
        }
    }

    private static class HookData {
        SimpleRule legacyRule;
        String ruleId;
        String popupId;
        MetaClass metaListener;
        ExtensionListener listener;
        String extensionId;

        HookData(String ruleId, SimpleRule legacyRule, String p, MetaClass m, String e) {
            if (ruleId == null && legacyRule == null) {
                throw new IllegalArgumentException("ruleId and legacyRule parameters cannot both be null");
            }
            this.ruleId = ruleId;
            this.legacyRule = legacyRule;
            this.popupId = p;
            this.metaListener = m;
            this.extensionId = e;
        }

        boolean evaluateRule(Context context) {
            if (this.ruleId != null) {
                return RuleEngine.getInstance().evaluateRule(this.ruleId, context);
            }
            return this.legacyRule.evaluate(context);
        }
    }
}

