/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import javax.ide.util.MetaClass;
import oracle.ide.Condition;
import oracle.ide.Context;
import oracle.ide.controller.ActionCondition;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ideimpl.condition.ConditionManager;
import oracle.ideimpl.condition.ConditionSpec;

public class CommandInvokingController
implements Controller {
    private ActionCondition condition;
    private ConditionSpec conditionSpec;
    private final MetaClass commandClass;
    private Command command;

    @Deprecated
    public CommandInvokingController(ConditionSpec conditionSpec, String commandClass) {
        this.conditionSpec = conditionSpec;
        this.commandClass = new MetaClass(Thread.currentThread().getContextClassLoader(), commandClass);
    }

    public CommandInvokingController(ConditionSpec conditionSpec, MetaClass commandClass) {
        this.conditionSpec = conditionSpec;
        this.commandClass = commandClass;
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (this.command == null) {
            this.command = CommandProcessor.createCommandFromMeta(this.commandClass, context);
        }
        try {
            CommandProcessor.getInstance().invoke(this.command);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        if (this.condition == null) {
            Condition tmpCondition = ConditionManager.newInstance(this.conditionSpec);
            this.condition = !(tmpCondition instanceof ActionCondition) ? new ActionConditionWrapper(tmpCondition) : (ActionCondition)tmpCondition;
        }
        if (this.condition.evaluate(context)) {
            this.condition.updateState(context, action);
        }
        return true;
    }

    private class ActionConditionWrapper
    implements ActionCondition {
        private Condition condition;

        private ActionConditionWrapper(Condition condition) {
            this.condition = condition;
        }

        @Override
        public void updateState(Context context, IdeAction action) {
            action.setEnabled(true);
        }

        @Override
        public boolean evaluate(Context context) {
            return this.condition.evaluate(context);
        }
    }
}

