/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.cmd;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.AddinManager;
import oracle.ide.IdeHook;
import oracle.ide.util.Pair;
import oracle.ideimpl.extension.AddinManagerImpl;

public class CommandsHandler
extends IdeHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "commands");
    private static final ElementName COMMAND = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "command");
    private static final String KEY_COMMAND_LIST = "command-list";
    private static final String KEY_COMMAND = "command-data";
    private final ElementVisitor _commandHandler = new CommandVisitor();

    public void start(ElementStartContext context) {
        context.getScopeData().put(KEY_COMMAND_LIST, new ArrayList());
        context.registerChildVisitor(COMMAND, this._commandHandler);
    }

    public void end(ElementEndContext context) {
        List commands = (List)context.getScopeData().get(KEY_COMMAND_LIST);
        for (Pair command : commands) {
            ((AddinManagerImpl)AddinManager.getAddinManager()).addCommand((String)command.getFirst(), (String)command.getSecond());
        }
    }

    private class CommandVisitor
    extends ElementVisitor {
        private final ElementVisitor _actionHandler = new ActionRefVisitor();
        private final ElementVisitor _commandClassHandler = new CommandClassVisitor();
        private final ElementName ACTION_REF = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "action-ref");
        private final ElementName COMMAND_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "command-class");

        private CommandVisitor() {
        }

        public void start(ElementStartContext context) {
            Pair command = new Pair();
            context.getScopeData().put(CommandsHandler.KEY_COMMAND, command);
            context.registerChildVisitor(this.ACTION_REF, this._actionHandler);
            context.registerChildVisitor(this.COMMAND_CLASS, this._commandClassHandler);
        }

        public void end(ElementEndContext context) {
            List commands = (List)context.getScopeData().get(CommandsHandler.KEY_COMMAND_LIST);
            Pair command = this.getCommand((ElementContext)context);
            commands.add(command);
        }

        private Pair getCommand(ElementContext context) {
            return (Pair)((Object)context.getScopeData().get(CommandsHandler.KEY_COMMAND));
        }

        private class CommandClassVisitor
        extends ElementVisitor {
            private CommandClassVisitor() {
            }

            public void end(ElementEndContext context) {
                CommandVisitor.this.getCommand((ElementContext)context).setSecond(context.getText().trim());
            }
        }

        private class ActionRefVisitor
        extends ElementVisitor {
            private ActionRefVisitor() {
            }

            public void end(ElementEndContext context) {
                CommandVisitor.this.getCommand((ElementContext)context).setFirst(context.getText().trim());
            }
        }
    }
}

