/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.IdeHook;

public final class SystemPropertiesHook
extends IdeHook {
    public static final ElementName ELEMENT = SystemPropertiesHook.element("system-properties");
    private static final ElementName PROPERTY = SystemPropertiesHook.element("property");
    private final ElementVisitor _propertyVisitor = new PropertyVisitor();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PROPERTY, this._propertyVisitor);
    }

    private class PropertyVisitor
    extends ElementVisitor {
        private PropertyVisitor() {
        }

        public void start(ElementStartContext context) {
            String name = context.getAttributeValue("name");
            if (name == null || (name = name.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'name'.");
                return;
            }
            String value = context.getAttributeValue("value");
            if (value == null) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute 'value'.");
                return;
            }
            String force = context.getAttributeValue("force");
            boolean bForce = Boolean.parseBoolean(force);
            String propertyValue = System.getProperty(name);
            if (bForce || propertyValue == null) {
                System.setProperty(name, value);
            } else if (!value.equals(propertyValue)) {
                this.log((ElementContext)context, Level.WARNING, "Property " + name + " is already set to " + propertyValue + ", ignoring new setting of " + value);
            }
        }
    }
}

