/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;

final class MonitorThread {
    private static int threadInitNumber;
    private boolean _go = true;
    private int _interval = 2000;
    private Thread _thread;
    private ArrayList _objects = new ArrayList();

    MonitorThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void monitorObject(Object object, MonitorListener listener) {
        ArrayList arrayList = this._objects;
        synchronized (arrayList) {
            this._objects.add(new MonitorData(object, listener));
        }
    }

    void finish() {
        this._go = false;
    }

    int getInterval() {
        return this._interval;
    }

    void setInterval(int interval) {
        this._interval = interval;
    }

    void start() {
        if (this._thread != null) {
            return;
        }
        this._thread = new Thread("MonitorThread-" + MonitorThread.nextThreadNum()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MonitorThread.this._go) {
                    int i = 0;
                    ArrayList arrayList = MonitorThread.this._objects;
                    synchronized (arrayList) {
                        while (i < MonitorThread.this._objects.size()) {
                            MonitorData data = (MonitorData)MonitorThread.this._objects.get(i);
                            if (data.getObject() == null) {
                                MonitorThread.this._objects.remove(i);
                                continue;
                            }
                            data.getListener().monitor(data.getObject());
                            ++i;
                        }
                    }
                    try {
                        Thread.sleep(MonitorThread.this._interval);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this._thread.start();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static class MonitorData {
        private final WeakReference _objectRef;
        private final MonitorListener _listener;

        MonitorData(Object object, MonitorListener listener) {
            this._objectRef = new WeakReference<Object>(object);
            this._listener = listener;
        }

        Object getObject() {
            return this._objectRef.get();
        }

        MonitorListener getListener() {
            return this._listener;
        }
    }

    static interface MonitorListener {
        public void monitor(Object var1);
    }
}

