/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ideimpl.MonitorThread;
import oracle.ideimpl.resource.IdeImplArb;

public final class MemoryMonitor
implements Controller,
Runnable,
MonitorThread.MonitorListener {
    private static final long FACTOR = 0x100000L;
    private static final CopyOnWriteArrayList<ActionListener> _actionListeners = new CopyOnWriteArrayList();
    private JLabel _memLabel;
    private IdeAction _action;
    private long _lastTotal;
    private long _lastFree;
    private final int GC_CMD_ID = Ide.findOrCreateCmdID("MemoryMonitor.GC_CMD_ID");

    public MemoryMonitor(StatusBar statusBar) {
        Toolbar toolbar = statusBar.getToolbar();
        this._memLabel = new JLabel();
        this._memLabel.setHorizontalAlignment(0);
        this._memLabel.setVerticalAlignment(0);
        this.updateText();
        toolbar.add(this.getAction());
        toolbar.add(this._memLabel);
        statusBar.getGUI().validate();
    }

    public void startMonitor() {
        MonitorThread monitor = new MonitorThread();
        monitor.monitorObject(this, this);
        monitor.start();
    }

    public static void addActionListener(ActionListener actionListener) {
        _actionListeners.add(actionListener);
    }

    public static void removeActionListener(ActionListener actionListener) {
        _actionListeners.remove(actionListener);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this.GC_CMD_ID) {
            Runtime runtime = Runtime.getRuntime();
            for (int i = 0; i < 3; ++i) {
                runtime.gc();
                runtime.runFinalization();
            }
            if (!_actionListeners.isEmpty()) {
                ActionEvent actionEvent = new ActionEvent(this, 0, null);
                for (ActionListener actionListener : _actionListeners) {
                    try {
                        actionListener.actionPerformed(actionEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        return false;
    }

    private static Object[] getParams(String p1, String p2, String p3, String p4, String p5) {
        Object[] params = new Object[]{p1, p2, p3, p4, p5};
        return params;
    }

    private IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get(this.GC_CMD_ID, AddinManager.getAddinManager().getCommand(this.GC_CMD_ID, null), StringUtils.stripMnemonic((String)IdeImplArb.getString(70)), null, (Integer)StringUtils.getMnemonicKeyCode((String)IdeImplArb.getString(70)), IdeImplArb.getInstance(), 72, null, true);
            this._action.addController(this);
        }
        return this._action;
    }

    private void updateText() {
        long used = this._lastTotal - this._lastFree;
        MemoryPoolMXBean metaspaceMemoryPoolMXBean = MemoryMonitor.getMetaspaceMemoryPoolMXBean();
        MemoryUsage metaspaceMemoryUsage = metaspaceMemoryPoolMXBean != null ? metaspaceMemoryPoolMXBean.getUsage() : null;
        String text = IdeImplArb.format(69, MemoryMonitor.getParams(" ", Long.toString(used), Long.toString(this._lastTotal), metaspaceMemoryUsage != null ? Long.toString(metaspaceMemoryUsage.getUsed() / 0x100000L) : "N/A", " "));
        this._memLabel.setText(text);
    }

    private static MemoryPoolMXBean getMetaspaceMemoryPoolMXBean() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            String poolName = memoryPoolMXBean.getName();
            if (!poolName.equals("Metaspace")) continue;
            return memoryPoolMXBean;
        }
        return null;
    }

    @Override
    public void monitor(Object object) {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory() / 0x100000L;
        long free = runtime.freeMemory() / 0x100000L;
        if (total != this._lastTotal || free != this._lastFree) {
            this._lastTotal = total;
            this._lastFree = free;
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updateText();
    }
}

