/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Image;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ide.extension.Extension;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.IconDescription;
import javax.ide.util.MissingIconException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeMainWindow;
import oracle.ide.IdeRunStatus;
import oracle.ide.IdeUIManager;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.RoleManager;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.IdeInputMapUIResource;
import oracle.ide.layout.Layouts;
import oracle.ide.migration.MigrationManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.URLCopier;
import oracle.ide.util.URLCopierProvider;
import oracle.ideimpl.IdeUIManagerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProductHook;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.extension.AddinManagerImpl;
import oracle.ideimpl.help.AboutPropertiesPage;
import oracle.ideimpl.help.AboutVersionPage;
import oracle.ideimpl.jsr198.ToolbarManagerImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.migration.MigrationManagerImpl;
import oracle.ideimpl.migration.UserDataHandler;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.SwingUtils2;

public class DefaultIdeCore
extends IdeCore {
    public DefaultIdeCore(IdeArgs args) {
        super(args);
    }

    public DefaultIdeCore(IdeArgs args, String id) {
        this(args);
        this.productID = id;
    }

    @Override
    protected void initializeLookAndFeel() {
        if (this.isHeadless()) {
            return;
        }
        IdeUIManager uiManager = this.createUIManager(Names.newInitialContext());
        if (uiManager != null) {
            EnvironOptions environOptions = Ide.getEnvironOptions();
            String lookAndFeel = !SwingUtils2.isInHighConstrastMode() ? environOptions.getLafClass() : UIManager.getSystemLookAndFeelClassName();
            uiManager.setLookAndFeel(lookAndFeel, null);
        }
        IdeInputMapUIResource.replaceInputMapUIResources();
    }

    @Override
    protected SecurityManager getSecurityManager() {
        if (this.isHeadless()) {
            return new NullSecurityManager();
        }
        return super.getSecurityManager();
    }

    @Override
    protected AddinManager getAddinManager() {
        InitialContext ic = Names.newInitialContext();
        this.createMigrationManager(ic);
        return this.createAddinManager(ic);
    }

    @Override
    protected Addin[] createCoreModules(IdeMainWindow mainWindow) {
        return this.createCoreModules(Names.newInitialContext(), mainWindow);
    }

    protected Addin[] createCoreModules(InitialContext ic, IdeMainWindow mainWindow) {
        if (this.isHeadless()) {
            return new Addin[0];
        }
        return new Addin[]{this.createToolbarManager(ic), this.createMainWindow(ic, mainWindow), this.createDockStation(ic), this.createEditorManager(ic), this.createLayouts(ic)};
    }

    @Override
    protected final void installAboutBox(AboutBoxFactory factory) {
        factory.addPage(AboutVersionPage.class);
        factory.addPage(AboutPropertiesPage.class);
    }

    private ProductInformation getProductInformation() {
        ProductHook hook = (ProductHook)ExtensionRegistry.getExtensionRegistry().getHook(ProductHook.NAME);
        hook.finish();
        return ProductInformation.getProductInformation();
    }

    @Override
    protected void brandMainWindow() {
        ProductInformation productInfo = this.getProductInformation();
        if (this.isHeadless()) {
            return;
        }
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            IdeUtil.setProgramName(productInfo.getName());
            mainWindow.updateTitle();
            ArrayList<Image> images = new ArrayList<Image>();
            DefaultIdeCore.addToImagesList(productInfo.getIcon(), images);
            for (IconDescription iconDesc : productInfo.getAdditionalIcons()) {
                DefaultIdeCore.addToImagesList(iconDesc, images);
            }
            mainWindow.setBrandingIcons(images);
            if (images.size() > 0) {
                mainWindow.setMainIcon((Image)images.get(0));
            }
        }
    }

    private static boolean addToImagesList(IconDescription idesc, List<Image> images) {
        try {
            if (idesc != null && idesc.getURL() != null) {
                ImageIcon icon = new ImageIcon(idesc.getURL());
                images.add(icon.getImage());
            }
            return true;
        }
        catch (MissingIconException missingIconException) {
            return false;
        }
    }

    @Override
    protected String getProductNameFromBranding() {
        return this.getProductInformation().getName();
    }

    @Override
    protected String getProductShortNameFromBranding() {
        return this.getProductInformation().getShortName();
    }

    @Override
    protected void initAboutBoxModel() {
        String roleString;
        String activeRoleName;
        if (this.isHeadless()) {
            return;
        }
        AboutBoxModel model = new AboutBoxModel(){

            @Override
            public Icon getBannerImage() {
                try {
                    return DefaultIdeCore.this.getOptionalIcon(DefaultIdeCore.this.getProductInformation().getBannerImage());
                }
                catch (MissingIconException mie) {
                    return null;
                }
            }

            @Override
            public Icon getHeaderImage() {
                try {
                    return DefaultIdeCore.this.getOptionalIcon(DefaultIdeCore.this.getProductInformation().getImage());
                }
                catch (MissingIconException mie) {
                    return null;
                }
            }
        };
        model.setProductName(this.getProductInformation().getName());
        model.setCopyrightMessage(this.getProductInformation().getCopyright());
        int lastDot = Ide.getProductVersion().lastIndexOf(46);
        String version = lastDot == -1 ? Ide.getProductVersion() : Ide.getProductVersion().substring(0, lastDot);
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        RoleManager roleManager = er.getRoleManager();
        String versionString = roleManager.isDefaultRoleActive() ? IdeArb.format(465, this.getProductInformation().getEditionName(), version) : IdeArb.format((activeRoleName = roleManager.getActiveRole().getName()).endsWith(roleString = IdeArb.getString(547)) ? 465 : 546, activeRoleName, version);
        model.setVersionString(versionString);
        model.setBuildString(IdeArb.format(466, Version.BUILD_LABEL));
        model.setDialogTitle(Ide.getProgramName());
        model.setProductVersion(version);
        AboutBoxFactory.getAboutBoxFactory().setModel(model);
    }

    private Icon getOptionalIcon(IconDescription icon) throws MissingIconException {
        if (icon != null) {
            URL url = icon.getURL();
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        return null;
    }

    @Override
    protected void copyExtensionUserData() {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        UserDataHandler userDataHook = (UserDataHandler)extReg.getHook(UserDataHandler.ELEMENT);
        for (Extension extension : extReg.getExtensions()) {
            String extID = extension.getID();
            try {
                Collection uris;
                URL destinationURL = extReg.getSystemDirectory(extID);
                if (!URLFileSystem.mkdirs((URL)destinationURL)) {
                    Assert.println((String)("Failed to create system directory " + URLFileSystem.toDisplayString((URL)destinationURL)));
                }
                if ((uris = userDataHook.getUserDataURIs(extID)) == null) continue;
                URLCopier uc = URLCopierProvider.getURLCopier();
                for (URI uri : uris) {
                    if (IdeRunStatus.getInstance().isExtensionDataCopied(extension, uri.getPath())) continue;
                    try {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        uc.copyURL(url, destinationURL);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    IdeRunStatus.getInstance().setExtensionDataCopied(extension, uri.getPath());
                }
            }
            catch (RuntimeException re) {
                System.err.println(re.getMessage() + "! Failed to create extension directory " + extension.getID());
                re.printStackTrace();
            }
        }
    }

    protected IdeMainWindow createMainWindow(InitialContext ic, IdeMainWindow mainWindow) {
        PerformanceLogger.get().startTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0");
        if (mainWindow == null) {
            mainWindow = new MainWindowImpl();
        }
        mainWindow.preInitialize();
        MainWindow.setMainWindow((Context)ic, (MainWindow)mainWindow, (int)1);
        PerformanceLogger.get().stopTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0", "Created main window");
        return mainWindow;
    }

    protected ToolbarManager createToolbarManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        ToolbarManagerImpl mgr = new ToolbarManagerImpl();
        ToolbarManager.setToolbarManager(mgr);
        return mgr;
    }

    protected DockStation createDockStation(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DockStation.setDockStation(dockStation);
        return dockStation;
    }

    protected IdeUIManager createUIManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        IdeUIManagerImpl uiManager = IdeUIManagerImpl.getInstance();
        IdeUIManager.setUIManager((IdeUIManager)uiManager);
        return uiManager;
    }

    protected MigrationManager createMigrationManager(InitialContext ic) {
        MigrationManager migrationMgr = MigrationManagerImpl.getInstance();
        MigrationManager.setMigrationManager(migrationMgr);
        return migrationMgr;
    }

    protected AddinManager createAddinManager(InitialContext ic) {
        AddinManager addinMan = AddinManagerImpl.createInstance();
        AddinManager.setAddinManager(addinMan);
        return addinMan;
    }

    protected EditorManager createEditorManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        EditorManagerImpl editorMgr = EditorManagerImpl.createInstance();
        EditorManager.setEditorManager(editorMgr);
        return editorMgr;
    }

    protected Layouts createLayouts(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        LayoutsImpl layouts = LayoutsImpl.createInstance();
        Layouts.setLayouts(layouts);
        return layouts;
    }
}

