/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ide.view.ViewStateListener;

public class ViewProxy
extends View {
    private final Reference<View> viewRef;

    public static ViewProxy newWeakProxy(View delegate) {
        return new ViewProxy(new WeakReference<View>(delegate));
    }

    public static ViewProxy newSoftProxy(View delegate) {
        return new ViewProxy(new SoftReference<View>(delegate));
    }

    private ViewProxy(Reference<View> viewRef) {
        super(viewRef.get().getId());
        this.viewRef = viewRef;
    }

    @Override
    public Component getGUI() {
        View view = this.viewRef.get();
        return null != view ? view.getGUI() : null;
    }

    @Override
    public void activate() {
        View view = this.viewRef.get();
        if (null != view) {
            view.activate();
        }
    }

    @Override
    public void addViewListener(ViewListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.addViewListener(l);
        }
    }

    @Override
    public void addViewSelectionListener(ViewSelectionListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.addViewSelectionListener(l);
        }
    }

    @Override
    void addViewStateListenerImpl(ViewStateListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.addViewStateListenerImpl(l);
        }
    }

    @Override
    public void close() {
        View view = this.viewRef.get();
        if (null != view) {
            view.close();
        }
    }

    @Override
    public void deactivate() {
        View view = this.viewRef.get();
        if (null != view) {
            view.deactivate();
        }
    }

    @Override
    void fireViewClosed() {
        View view = this.viewRef.get();
        if (null != view) {
            view.fireViewClosed();
        }
    }

    @Override
    void fireViewCollapsedImpl() {
        View view = this.viewRef.get();
        if (null != view) {
            view.fireViewCollapsedImpl();
        }
    }

    @Override
    void fireViewExpandedImpl() {
        View view = this.viewRef.get();
        if (null != view) {
            view.fireViewExpandedImpl();
        }
    }

    @Override
    void fireViewSelectionChangedImpl(ViewSelectionEvent e) {
        View view = this.viewRef.get();
        if (null != view) {
            view.fireViewSelectionChangedImpl(e);
        }
    }

    @Override
    public Context getContext(EventObject event) {
        View view = this.viewRef.get();
        return null != view ? view.getContext(event) : null;
    }

    @Override
    public ContextMenu getContextMenu() {
        View view = this.viewRef.get();
        return null != view ? view.getContextMenu() : null;
    }

    @Override
    public Controller getController() {
        View view = this.viewRef.get();
        return null != view ? view.getController() : null;
    }

    @Override
    public HelpInfo getHelpInfo() {
        View view = this.viewRef.get();
        return null != view ? view.getHelpInfo() : null;
    }

    @Override
    String getIdImpl() {
        View view = this.viewRef.get();
        return null != view ? view.getIdImpl() : null;
    }

    @Override
    protected Element[] getSelectionFromUI() {
        View view = this.viewRef.get();
        return null != view ? view.getSelectionFromUI() : new Element[]{};
    }

    @Override
    Element[] getSelectionImpl() {
        View view = this.viewRef.get();
        return null != view ? view.getSelectionImpl() : new Element[]{};
    }

    @Override
    public String getTabName() {
        View view = this.viewRef.get();
        return null != view ? view.getTabName() : null;
    }

    @Override
    public Toolbar getToolbar() {
        View view = this.viewRef.get();
        return null != view ? view.getToolbar() : null;
    }

    @Override
    public View getViewWithoutDecoration() {
        View view = this.viewRef.get();
        return null != view ? view.getViewWithoutDecoration() : null;
    }

    @Override
    public boolean isVisible() {
        View view = this.viewRef.get();
        return null != view ? view.isVisible() : false;
    }

    @Override
    public void loadLayout(PropertyAccess p) {
        View view = this.viewRef.get();
        if (null != view) {
            view.loadLayout(p);
        }
    }

    @Override
    protected String newId() {
        View view = this.viewRef.get();
        return null != view ? view.newId() : null;
    }

    @Override
    View ownerImpl() {
        View view = this.viewRef.get();
        return null != view ? view.ownerImpl() : null;
    }

    @Override
    public void removeViewListener(ViewListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.removeViewListener(l);
        }
    }

    @Override
    void removeViewListenerImpl(ViewListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.removeViewListenerImpl(l);
        }
    }

    @Override
    public void removeViewSelectionListener(ViewSelectionListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.removeViewSelectionListener(l);
        }
    }

    @Override
    void removeViewSelectionListenerImpl(ViewSelectionListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.removeViewSelectionListenerImpl(l);
        }
    }

    @Override
    void removeViewStateListenerImpl(ViewStateListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.removeViewStateListenerImpl(l);
        }
    }

    @Override
    public void saveLayout(PropertyAccess p) {
        View view = this.viewRef.get();
        if (null != view) {
            view.saveLayout(p);
        }
    }

    @Override
    void scheduleUpdateSelectionImpl() {
        View view = this.viewRef.get();
        if (null != view) {
            view.scheduleUpdateSelectionImpl();
        }
    }

    @Override
    void setIdImpl(String id) {
        View view = this.viewRef.get();
        if (null != view) {
            view.setIdImpl(id);
        }
    }

    @Override
    protected void setOwner(View owner) {
        View view = this.viewRef.get();
        if (null != view) {
            view.setOwner(owner);
        }
    }

    @Override
    public void setToolbarVisible(boolean visible) {
        View view = this.viewRef.get();
        if (null != view) {
            super.setToolbarVisible(visible);
        }
    }

    @Override
    public void show() {
        View view = this.viewRef.get();
        if (null != view) {
            view.show();
        }
    }

    @Override
    public String toString() {
        View view = this.viewRef.get();
        return null != view ? view.toString() : null;
    }

    @Override
    void updateSelectionImpl0(boolean doNotifyOnInvokeLater) {
        View view = this.viewRef.get();
        if (null != view) {
            view.updateSelectionImpl0(doNotifyOnInvokeLater);
        }
    }

    @Override
    public void updateTitle(Object obj) {
        View view = this.viewRef.get();
        if (null != view) {
            view.updateTitle(obj);
        }
    }

    @Override
    public void updateVisibleActions(UpdateMessage updateMessage) {
        View view = this.viewRef.get();
        if (null != view) {
            view.updateVisibleActions(updateMessage);
        }
    }

    @Override
    void updateVisibleActionsImpl() {
        View view = this.viewRef.get();
        if (null != view) {
            view.updateVisibleActionsImpl();
        }
    }

    @Override
    void addViewListenerImpl(ViewListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.addViewListenerImpl(l);
        }
    }

    @Override
    void addViewSelectionListenerImpl(ViewSelectionListener l) {
        View view = this.viewRef.get();
        if (null != view) {
            view.addViewSelectionListenerImpl(l);
        }
    }
}

