/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.marshal.StringConversion;
import oracle.javatools.parser.java.v2.JdkVersion;

public final class VersionNumber
implements Comparable,
StringConversion {
    private final List<String> _versionParts;
    private transient int _hash;

    public VersionNumber(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("VersionString is null");
        }
        int numTokens = 0;
        int index = -1;
        while ((index = versionString.indexOf(46, index + 1)) >= 0) {
            ++numTokens;
        }
        this._versionParts = new ArrayList<String>(numTokens + 1);
        while ((index = versionString.indexOf(46)) >= 0) {
            this._versionParts.add(versionString.substring(0, index));
            versionString = versionString.substring(index + 1);
        }
        this._versionParts.add(versionString);
    }

    public int countParts() {
        return this._versionParts.size();
    }

    public String getPart(int index) {
        if (index < 0 || index >= this._versionParts.size()) {
            return null;
        }
        return this._versionParts.get(index);
    }

    public final boolean isAfter(VersionNumber version) {
        int compare = this.compareToImpl(version);
        return compare > 0;
    }

    public final boolean isAfter(String version) {
        return version == null ? true : this.isAfter(new VersionNumber(version));
    }

    public final boolean isAfter(VersionNumber version, boolean orEquals) {
        int compare = this.compareToImpl(version);
        return orEquals ? compare >= 0 : compare > 0;
    }

    public final boolean isAfter(String version, boolean orEquals) {
        return version == null ? true : this.isAfter(new VersionNumber(version), orEquals);
    }

    public final boolean isBefore(VersionNumber version) {
        int compare = this.compareToImpl(version);
        return compare < 0;
    }

    public final boolean isBefore(String version) {
        return version == null ? false : this.isBefore(new VersionNumber(version));
    }

    public boolean isBefore(VersionNumber version, boolean orEquals) {
        int compare = this.compareToImpl(version);
        return orEquals ? compare <= 0 : compare < 0;
    }

    public boolean isBefore(String version, boolean orEquals) {
        return version == null ? false : this.isBefore(new VersionNumber(version), orEquals);
    }

    public String getJdkSourceTargetString() {
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)this.toString());
        return jdkVersion == JdkVersion.JDK_UNKNOWN ? null : jdkVersion.getVersionString();
    }

    public int compareTo(Object o) {
        return this.compareToImpl((VersionNumber)o);
    }

    private int compareToImpl(VersionNumber other) {
        if (other == null) {
            return 1;
        }
        int myParts = this._versionParts.size();
        int otherParts = other.countParts();
        for (int i = 0; i < myParts; ++i) {
            String otherPart = other.getPart(i);
            if (otherPart == null) {
                return 1;
            }
            String[] otherPartsToCompare = this.getPartsToCompare(otherPart);
            String[] myPartsToCompare = this.getPartsToCompare(this._versionParts.get(i));
            for (int x = 0; x < myPartsToCompare.length; ++x) {
                if (x >= otherPartsToCompare.length) {
                    return 1;
                }
                try {
                    int myInt = Integer.parseInt(myPartsToCompare[x]);
                    int otherInt = Integer.parseInt(otherPartsToCompare[x]);
                    if (myInt < otherInt) {
                        return -1;
                    }
                    if (myInt <= otherInt) continue;
                    return 1;
                }
                catch (NumberFormatException nfe) {
                    for (int y = 0; y < myPartsToCompare[x].length(); ++y) {
                        if (y >= otherPartsToCompare[x].length()) {
                            return 1;
                        }
                        int compare = Character.compare(myPartsToCompare[x].charAt(y), otherPartsToCompare[x].charAt(y));
                        if (compare < 0) {
                            return -1;
                        }
                        if (compare <= 0) continue;
                        return 1;
                    }
                    if (myPartsToCompare[x].length() == otherPartsToCompare[x].length()) continue;
                    return -1;
                }
            }
            if (myPartsToCompare.length == otherPartsToCompare.length) continue;
            return -1;
        }
        if (myParts == otherParts) {
            return 0;
        }
        return -1;
    }

    private String[] getPartsToCompare(String versionPart) {
        for (int x = 0; x < versionPart.length(); ++x) {
            char c = versionPart.charAt(x);
            if (c >= '0' && c <= '9') continue;
            if (x == 0) break;
            return new String[]{versionPart.substring(0, x), versionPart.substring(x)};
        }
        return new String[]{versionPart};
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((VersionNumber)o);
    }

    private boolean equalsImpl(VersionNumber other) {
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        int h = this._hash;
        if (h == 0) {
            for (String part : this._versionParts) {
                int partLen = part.length();
                for (int j = 0; j < partLen; ++j) {
                    h = 31 * h + part.charAt(j);
                }
            }
            this._hash = h;
        }
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(25);
        int n = this._versionParts.size();
        for (int i = 0; i < n; ++i) {
            sb.append(this._versionParts.get(i)).append('.');
        }
        if (n > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

