/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.util.Assert;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFiltersOptimizer;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class PatternFilters
extends HashStructureAdapter {
    public static final String DATA_KEY = "pattern-filters";
    private transient PatternFilter[] _filters;
    private transient PatternFiltersOptimizer _optimizer = new PatternFiltersOptimizer();

    private PatternFilters(HashStructure contentSetHash) {
        super(contentSetHash);
        this.refreshFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFilters() {
        ListStructure list = this._hash.getListStructure(DATA_KEY);
        if (list != null) {
            ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>();
            Object object = list.iteratorLock();
            synchronized (object) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String str = iter.next().toString();
                    if (str == null || str.length() < 2) continue;
                    filters.add(PatternFilter.fromStr(str));
                }
            }
            this._filters = PatternFilters.toArray(filters);
        } else {
            this._filters = null;
        }
        this._optimizer.setPatternFilters(this._filters);
    }

    public static PatternFilters getInstance(HashStructure contentSetHash) {
        return new PatternFilters(contentSetHash);
    }

    public Object copyTo(Object target) {
        PatternFilters copy = (PatternFilters)((Object)super.copyTo(target));
        copy.refreshFilters();
        return copy;
    }

    public PatternFilter[] getFilters() {
        return this._filters != null ? (PatternFilter[])this._filters.clone() : null;
    }

    public void setFilters(PatternFilter[] filters) {
        if (filters != null) {
            int n = filters.length;
            for (int i = 0; i < n; ++i) {
                if (filters[i] != null) continue;
                throw new IllegalArgumentException();
            }
            if (this._filters != null && Arrays.equals(this._filters, filters)) {
                return;
            }
        }
        this._filters = filters;
        this._optimizer.setPatternFilters(this._filters);
        this.updateListStructure();
    }

    public void addInclude(String pattern) {
        this.addInclude(pattern, true);
    }

    public void addInclude(String pattern, boolean simplify) {
        if (pattern != null) {
            this.addFilterImpl(PatternFilter.newInclude(pattern), simplify);
        }
    }

    public void addExclude(String pattern) {
        this.addExclude(pattern, true);
    }

    public void addExclude(String pattern, boolean simplify) {
        if (pattern != null) {
            this.addFilterImpl(PatternFilter.newExclude(pattern), simplify);
        }
    }

    public boolean containsFilters() {
        return this._hash.containsKey(DATA_KEY);
    }

    public void removeFilters() {
        this._hash.remove(DATA_KEY);
    }

    public static boolean containsFilters(HashStructure contentSetHash) {
        return contentSetHash.containsKey(DATA_KEY);
    }

    public static void removeFilters(HashStructure contentSetHash) {
        contentSetHash.remove(DATA_KEY);
    }

    public PatternFilter findMatchingFilter(String path) {
        PatternFilter optimizedPatternFilter = this._optimizer.getMatchingFilter(path);
        return optimizedPatternFilter;
    }

    public boolean isIncluded(String path) {
        PatternFilter matchingFilter = this.findMatchingFilter(path);
        return matchingFilter != null ? matchingFilter.isInclude() : false;
    }

    public TriStateBoolean inferFromFilters(String relPath) {
        if (this._filters != null) {
            for (PatternFilter filter : this._filters) {
                if (filter == null) continue;
                int consumeType = filter.consumes(relPath);
                if (consumeType == 0) {
                    if (!filter.isInclude()) continue;
                    return TriStateBoolean.TRI_STATE;
                }
                if (consumeType != 1) continue;
                return TriStateBoolean.getState((boolean)filter.isInclude());
            }
        }
        return TriStateBoolean.FALSE;
    }

    private void addFilterImpl(PatternFilter filter, boolean simplify) {
        ArrayList<PatternFilter> filtersList;
        block23: {
            String pattern = filter.getPattern();
            Assert.precondition((pattern != null ? 1 : 0) != 0);
            filtersList = new ArrayList<PatternFilter>();
            if (this._filters != null) {
                filtersList.addAll(Arrays.asList(this._filters));
            }
            if (filtersList.size() == 0) {
                if (filter.isExclude()) {
                    return;
                }
            } else if (simplify) {
                PatternFilter firstFilter;
                Assert.precondition((filtersList.size() > 0 ? 1 : 0) != 0);
                if ("**".equals(pattern) && (firstFilter = (PatternFilter)filtersList.get(0)) != null && "**".equals(firstFilter.getPattern())) {
                    filtersList.remove(0);
                }
                if (!PatternFilters.containsWildcard(pattern)) {
                    Iterator iterSimplify = filtersList.iterator();
                    boolean matchingAntagonistRemoved = false;
                    while (iterSimplify.hasNext()) {
                        PatternFilter curFilter = (PatternFilter)iterSimplify.next();
                        if (curFilter == null) continue;
                        String curPattern = curFilter.getPattern();
                        if (curPattern != null) {
                            if ("**".equals(curPattern)) {
                                if (curFilter.isInclude() == filter.isInclude()) {
                                    this.setFiltersImpl(filtersList);
                                    return;
                                }
                            } else if (curFilter.matches(pattern)) {
                                boolean isSameType;
                                boolean bl = isSameType = curFilter.isInclude() == filter.isInclude();
                                if (PatternFilters.containsWildcard(curPattern)) {
                                    if (isSameType) {
                                        this.setFiltersImpl(filtersList);
                                        return;
                                    }
                                } else {
                                    if (curPattern.equals(pattern)) {
                                        Assert.precondition((!PatternFilters.containsWildcard(pattern) ? 1 : 0) != 0);
                                        iterSimplify.remove();
                                        if (isSameType) continue;
                                        matchingAntagonistRemoved = true;
                                        continue;
                                    }
                                    if (isSameType) {
                                        this.setFiltersImpl(filtersList);
                                        return;
                                    }
                                }
                            } else {
                                if (curPattern.startsWith(pattern) && (pattern.endsWith("/") || curPattern.charAt(pattern.length()) == '/')) {
                                    iterSimplify.remove();
                                    continue;
                                }
                                if (!pattern.startsWith(curPattern) || !curPattern.endsWith("/") && pattern.charAt(curPattern.length()) != '/') continue;
                                if (curFilter.isInclude() == filter.isInclude()) {
                                    this.setFiltersImpl(filtersList);
                                    return;
                                }
                            }
                        }
                        break block23;
                    }
                    if (matchingAntagonistRemoved && filter.isExclude()) {
                        this.setFiltersImpl(filtersList);
                        return;
                    }
                    if (filtersList.size() == 0 && filter.isExclude()) {
                        this.setFiltersImpl(filtersList);
                        return;
                    }
                }
            }
        }
        filtersList.add(0, filter);
        this.setFiltersImpl(filtersList);
    }

    private void setFiltersImpl(ArrayList filtersList) {
        this._filters = PatternFilters.toArray(filtersList);
        this._optimizer.setPatternFilters(this._filters);
        this.updateListStructure();
    }

    private void updateListStructure() {
        if (this._filters == null) {
            this._hash.remove(DATA_KEY);
        } else {
            ListStructure list = this._hash.getListStructure(DATA_KEY);
            if (list == null) {
                list = ListStructure.newInstance();
                this._hash.putListStructure(DATA_KEY, list);
            }
            list.clear();
            int n = this._filters.length;
            for (int i = 0; i < n; ++i) {
                list.add((Object)this._filters[i].toStr());
            }
        }
    }

    private static PatternFilter[] toArray(ArrayList filters) {
        return filters.toArray(new PatternFilter[filters.size()]);
    }

    private static boolean containsWildcard(String pattern) {
        return pattern.indexOf(42) >= 0;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof PatternFilters && Arrays.equals(this._filters, ((PatternFilters)((Object)object))._filters);
    }

    public int hashCode() {
        int code = 0;
        if (this._filters == null) {
            return 0;
        }
        for (PatternFilter filter : this._filters) {
            code = code * 37 + filter.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PatternFilters [");
        for (int i = 0; i < this._filters.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this._filters[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

