/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class JDK {
    private static final long V_1_3_0_2 = 2L;
    private static final long V_1_3_1_0 = 4L;
    private static final long V_1_3_1_1 = 8L;
    private static final long V_1_3_1_2 = 16L;
    private static final long V_1_3_1_3 = 32L;
    private static final long V_1_3_1_4 = 64L;
    private static final long V_1_4_0_0 = 128L;
    private static final long V_1_4_1_0 = 256L;
    private static final long V_1_4_2_0 = 512L;
    private static final long V_1_5 = 1024L;
    private static final long V_1_6 = 2048L;
    private static final long V_1_7 = 4096L;
    private static final long V_1_8 = 8192L;
    private static final long V_9 = 16384L;
    private static final long V_10 = 32768L;
    private static final long V_11 = 65536L;
    private static final long V_12 = 131072L;
    private static final long V_13 = 262144L;
    private static final long V_14 = 524288L;
    private static final long V_15 = 0x100000L;
    private static final long V_16 = 0x200000L;
    private static final long V_17 = 0x400000L;
    private static final long V_18 = 0x800000L;
    private static final long V_19 = 0x1000000L;
    private static final long V_20 = 0x2000000L;
    private static final long V_21 = 0x4000000L;
    private static final long V_22 = 0x8000000L;
    private static final long V_23 = 0x10000000L;
    private static final long V_24 = 0x20000000L;
    private static final long V_25 = 0x40000000L;
    private static final long V_1_3_1 = 124L;
    private static final long V_1_4_0 = 128L;
    private static final long V_DEFAULT = 8192L;
    private static final String JDK_VERSION_KEY = "java.version";
    private static final String[] JDK_VERSIONS_VALUES = new String[]{"1.3.1", "1.3.1_01", "1.3.1_02", "1.3.1_03", "1.3.1_04", "1.4.0", "1.4.1", "1.4.2", "1.5", "1.6", "1.7", "1.8", "1.9", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"};
    private static final long[] JDK_VERSIONS = new long[]{4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L};
    private static final long STATIC_VERSION = 16L;
    private static final long DYNAMIC_VERSION = JDK.getJDKVersion();
    public static final boolean IS_JDK14 = DYNAMIC_VERSION >= 128L;
    public static final boolean IS_JDK141 = DYNAMIC_VERSION >= 256L;
    public static final boolean IS_JDK142 = DYNAMIC_VERSION >= 512L;
    public static final boolean IS_JDK15 = DYNAMIC_VERSION >= 1024L;
    public static final boolean IS_JDK16 = DYNAMIC_VERSION >= 2048L;
    public static final boolean IS_JDK17 = DYNAMIC_VERSION >= 4096L;
    public static final boolean IS_JDK18 = DYNAMIC_VERSION >= 8192L;
    public static final boolean IS_JDK19 = DYNAMIC_VERSION >= 16384L;
    public static final boolean IS_JDK9 = DYNAMIC_VERSION >= 16384L;
    public static final boolean IS_JDK010 = DYNAMIC_VERSION >= 32768L;
    public static final boolean IS_JDK011 = DYNAMIC_VERSION >= 65536L;
    public static final boolean IS_JDK012 = DYNAMIC_VERSION >= 131072L;
    public static final boolean IS_JDK013 = DYNAMIC_VERSION >= 262144L;
    public static final boolean IS_JDK014 = DYNAMIC_VERSION >= 524288L;
    public static final boolean IS_JDK015 = DYNAMIC_VERSION >= 0x100000L;
    public static final boolean IS_JDK016 = DYNAMIC_VERSION >= 0x200000L;
    public static final boolean IS_JDK017 = DYNAMIC_VERSION >= 0x400000L;
    public static final boolean IS_JDK_018 = DYNAMIC_VERSION >= 0x800000L;
    public static final boolean IS_JDK_019 = DYNAMIC_VERSION >= 0x1000000L;
    public static final boolean IS_JDK_020 = DYNAMIC_VERSION >= 0x2000000L;
    public static final boolean IS_JDK_021 = DYNAMIC_VERSION >= 0x4000000L;
    public static final boolean IS_JDK_022 = DYNAMIC_VERSION >= 0x8000000L;
    public static final boolean IS_JDK_023 = DYNAMIC_VERSION >= 0x10000000L;
    public static final boolean IS_JDK_024 = DYNAMIC_VERSION >= 0x20000000L;
    public static final boolean IS_JDK_025 = DYNAMIC_VERSION >= 0x40000000L;
    public static final boolean HAS_BUG_4199374 = JDK.getBooleanProperty("HAS_BUG_4199374", true);
    public static final boolean HAS_BUG_J2D_ROTATE = JDK.getBooleanProperty("HAS_BUG_J2D_ROTATE", false);
    public static final boolean HAS_BUG_NOREMOVEFOCUS = JDK.getBooleanProperty("HAS_BUG_NOREMOVEFOCUS", true);
    public static final boolean HAS_BUG_4336775 = JDK.getBooleanProperty("HAS_BUG_4336775", false);
    public static final boolean HAS_BUG_4776532 = JDK.getBooleanProperty("HAS_BUG_4776532", true);
    public static final boolean HAS_BUG_GETKEYMODIFIERSTEXT = JDK.getBooleanProperty("HAS_BUG_GETKEYMODIFIERSTEXT", true);
    public static final boolean HAS_BUG_4502288 = JDK.getBooleanProperty("HAS_BUG_4502288", true);
    public static final boolean HAS_BUG_TABBEDPANE_NPE_JAWS = JDK.getBooleanProperty("HAS_BUG_TABBEDPANE_NPE_JAWS", true);
    public static final boolean HAS_BUG_4381959 = JDK.getBooleanProperty("HAS_BUG_4381959", DYNAMIC_VERSION < 128L);
    public static final boolean HAS_BUG_2435195 = JDK.getBooleanProperty("HAS_BUG_2435195", DYNAMIC_VERSION >= 128L);
    public static final boolean HAS_BUG_4519411 = JDK.getBooleanProperty("HAS_BUG_4519411", DYNAMIC_VERSION == 8L || DYNAMIC_VERSION == 16L);
    public static final boolean HAS_BUG_4647105 = JDK.getBooleanProperty("HAS_BUG_4647105", DYNAMIC_VERSION <= 64L);
    public static final boolean HAS_BUG_4765282 = JDK.getBooleanProperty("HAS_BUG_4765282", IS_JDK14);
    public static final boolean WA_ORABUG_1963899 = JDK.getBooleanProperty("RestoreAppDefaultSize", false);
    public static final boolean HAS_BUG_4390137 = JDK.getBooleanProperty("FrameNotRevisible", false);
    public static final boolean HAS_BUG_4674205 = JDK.getBooleanProperty("HAS_BUG_4674205", true);
    public static final boolean HAS_BUG_4551985 = JDK.getBooleanProperty("HAS_BUG_4551985", DYNAMIC_VERSION < 512L);
    public static final boolean HAS_BUG_2645826 = JDK.getBooleanProperty("WrongSystemFontOnWindows", !IS_JDK15);
    public static final boolean SEARCH_ACCELERATORS_IN_MENUS = JDK.getBooleanProperty("SearchAcceleratorsInMenus", false);
    public static final boolean HAS_BUG_4753146 = JDK.getBooleanProperty("HAS_BUG_4753146", IS_JDK141);
    public static final boolean HAS_BUG_4749792 = JDK.getBooleanProperty("HAS_BUG_4749792", IS_JDK14);
    public static final boolean HAS_BUG_4812991 = JDK.getBooleanProperty("HAS_BUG_4812991", true);
    public static final boolean HAS_BUG_MENU_RESTORES_WRONG_FOCUS = JDK.getBooleanProperty("HAS_BUG_MENU_RESTORES_WRONG_FOCUS", true);
    public static final boolean HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST = JDK.getBooleanProperty("HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST", true);
    public static final boolean HAS_BUG_METAL_MAXIMIZE_DOES_NOT_WORK_ON_LINUX = JDK.getBooleanProperty("HAS_BUG_METAL_MAXIMIZE_DOES_NOT_WORK_ON_LINUX", true);
    public static final boolean HAS_BUG_METAL_CURSOR_SHAPE = JDK.getBooleanProperty("HAS_BUG_METAL_CURSOR_SHAPE", true);
    public static final boolean HAS_BUG_BROKEN_TYPE_AHEAD = JDK.getBooleanProperty("HAS_BUG_BROKEN_TYPE_AHEAD", true);
    public static final boolean HAS_BUG_4552322 = JDK.getBooleanProperty("HAS_BUG_4552322", IS_JDK15);
    public static final boolean HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT = JDK.getBooleanProperty("HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT", IS_JDK15 && !IS_JDK16);
    public static final boolean HAS_BUG_4699831 = JDK.getBooleanProperty("HAS_BUG_4699831", true);

    private JDK() {
    }

    private static long getJDKVersion() {
        String jdkVersion = System.getProperty(JDK_VERSION_KEY);
        for (int i = JDK_VERSIONS_VALUES.length - 1; i >= 0; --i) {
            if (!jdkVersion.startsWith(JDK_VERSIONS_VALUES[i])) continue;
            return JDK_VERSIONS[i];
        }
        return 8192L;
    }

    private static boolean getBooleanProperty(String sName, boolean bDefault) {
        String sProp = System.getProperty(sName, bDefault ? "true" : "false");
        return Boolean.valueOf(sProp);
    }
}

