/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.resource.UtilArb;
import oracle.ide.util.Assert;

public final class FileCopyUtil {
    private FileCopyUtil() {
    }

    public static void copyFile(File src, File target) throws IOException {
        block20: {
            FileInputStream in = null;
            FileOutputStream out = null;
            long srcDate = src.lastModified();
            long targetDate = target.lastModified();
            try {
                if (srcDate > targetDate) {
                    FileCopyUtil.ensureParent(target);
                    in = new FileInputStream(src);
                    out = new FileOutputStream(target);
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int bytesRead;
                        if ((bytesRead = in.read(buffer)) == -1) {
                            break block20;
                        }
                        out.write(buffer, 0, bytesRead);
                    }
                }
                Assert.println((String)("WARNING:Source File " + src.getName() + "[" + srcDate + "] is not newer than targetination file. [" + targetDate + "] No file copied."));
            }
            catch (IOException ioEx) {
                target = null;
                throw ioEx;
            }
            catch (Exception ex) {
                target = null;
                throw new IOException(UtilArb.format(0, src.getName()));
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (null != out) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                if (null != target) {
                    target.setLastModified(srcDate);
                }
            }
        }
    }

    private static void ensureParent(File file) throws IOException {
        File parent;
        String parentName = file.getParent();
        if (null != parentName && null != (parent = new File(parentName)) && !parent.exists()) {
            parent.mkdirs();
        }
    }
}

