/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.ide.util.FastStringBuffer;

public class FastStringWriter
extends PrintWriter {
    private FastStringBuffer buf;
    private String lineSeparator;

    public FastStringWriter() {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer();
        this.lock = null;
        this.lineSeparator = System.lineSeparator();
    }

    public FastStringWriter(int initialSize) {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer(initialSize);
        this.lock = null;
        this.lineSeparator = System.lineSeparator();
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    public String toString() {
        return this.buf.toString();
    }

    public FastStringBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private void newLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.flush();
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        try {
            this.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }
}

