/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import oracle.ide.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class ExecUtil {
    public static final boolean quoteExec = ExecUtil.canQuoteExecName();
    public static final boolean quoteArgs = ExecUtil.canQuoteArgs();
    public static final char argQuoteChar = ExecUtil.getArgQuoteChar();
    public static final String argQuoteString = ExecUtil.getArgQuoteString();

    private ExecUtil() {
    }

    private static boolean canQuoteExecName() {
        return PlatformUtils.isWindows();
    }

    private static boolean canQuoteArgs() {
        return PlatformUtils.isWindows();
    }

    private static char getArgQuoteChar() {
        return PlatformUtils.isWindows() ? (char)'\"' : ' ';
    }

    private static String getArgQuoteString() {
        return PlatformUtils.isWindows() ? "\"" : "";
    }

    private static String[] _makeNewStringArray(String[] s1, String[] s2) {
        int len1 = s1.length;
        int len2 = s2.length;
        int newLen = len1 + len2;
        String[] result = new String[newLen];
        System.arraycopy(s1, 0, result, 0, len1);
        System.arraycopy(s2, 0, result, len1, len2);
        return result;
    }

    public static String[] getExecCommandArray(String[] cmd) {
        if (PlatformUtils.isWindows()) {
            String[] cmdSlashC = new String[]{"CMD.EXE", "/C", "START"};
            return ExecUtil._makeNewStringArray(cmdSlashC, cmd);
        }
        return cmd;
    }

    public static String[] cleanUpCommand(String[] command) {
        int length = command.length;
        String[] result = new String[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (!ModelUtil.hasLength((String)command[i])) continue;
            result[count++] = command[i];
        }
        if (count < length) {
            String[] tmp = new String[count];
            System.arraycopy(result, 0, tmp, 0, count);
            result = tmp;
        }
        return result;
    }

    public static String adjustArgument(String arg) {
        String res = arg;
        if (!PlatformUtils.isWindows()) {
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                res = arg.substring(1, arg.length() - 1);
            }
            StringBuffer sb = new StringBuffer(arg.length());
            for (int i = 0; i < res.length(); ++i) {
                char c = res.charAt(i);
                if (c == '\\' && ++i < res.length()) {
                    c = res.charAt(i);
                }
                sb.append(c);
            }
            res = sb.toString();
        }
        return res;
    }
}

