/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public class FileWatcher {
    private URL _fileURL;
    private String _filename;
    private FileListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = DirectoryWatcher.WATCH_LOCK;
    private static List _watchEntryList = new ArrayList();

    public static FileWatcher createFileWatcher(URL fileURL, FileListener listener) {
        return FileWatcher.createFileWatcherImpl(fileURL, listener);
    }

    public static void destroyFileWatcher(FileWatcher watcher) {
        FileWatcher.destroyFileWatcherImpl(watcher);
    }

    private FileWatcher(URL fileURL, String filename, FileListener listener) {
        this._fileURL = URLFactory.intern((URL)fileURL);
        this._filename = filename;
        this._listener = listener;
        this._active = true;
    }

    public URL getFileURL() {
        return this._fileURL;
    }

    public String getFileName() {
        return this._filename;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String platformName = URLFileSystem.getPlatformPathName((URL)this.getFileURL());
        return "FW: " + platformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileWatcher createFileWatcherImpl(URL fileURL, FileListener listener) {
        if (fileURL == null) {
            return null;
        }
        URL normalizedURL = fileURL;
        while (JarUtil.isJarURL((URL)normalizedURL)) {
            normalizedURL = FileWatcher.getFileURLFor(normalizedURL);
        }
        URL rootURL = FileWatcher.getRootURLFor(normalizedURL);
        if (!"file".equals(normalizedURL.getProtocol())) {
            return null;
        }
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = FileWatcher.findWatchEntry(rootURL);
            if (entry == null) {
                WatchEntry tmpEntry = new WatchEntry(new ArrayList(), rootURL);
                DirectoryWatcher dirWatcher = DirectoryWatcher.createDirectoryWatcherImpl(rootURL, false, tmpEntry);
                if (dirWatcher == null) {
                    return null;
                }
                tmpEntry.dirWatcher = dirWatcher;
                entry = tmpEntry;
                _watchEntryList.add(entry);
            }
            String filename = URLFileSystem.getFileName((URL)normalizedURL);
            FileWatcher watcher = new FileWatcher(fileURL, filename, listener);
            entry.watchers.add(watcher);
            return watcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyFileWatcherImpl(FileWatcher watcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            watcher._active = false;
            URL rootURL = FileWatcher.getRootURLFor(watcher.getFileURL());
            WatchEntry entry = FileWatcher.findWatchEntry(rootURL);
            if (entry != null) {
                entry.watchers.remove(watcher);
                if (entry.watchers.size() == 0) {
                    _watchEntryList.remove(entry);
                    DirectoryWatcher.destroyDirectoryWatcher(entry.dirWatcher);
                }
            }
        }
    }

    private static URL getFileURLFor(URL url) {
        if (JarUtil.isJarURL((URL)url)) {
            return JarUtil.getJarFileURL((URL)url);
        }
        return url;
    }

    private static URL getRootURLFor(URL url) {
        URL fileURL = FileWatcher.getFileURLFor(url);
        return URLFileSystem.getParent((URL)fileURL);
    }

    private static WatchEntry findWatchEntry(URL rootURL) {
        int size = _watchEntryList.size();
        for (int i = 0; i < size; ++i) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry == null || !entry.rootURL.equals(rootURL)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(WatchEntry entry, DirectoryWatcher.DirectoryEvent event) {
        ArrayList<FileListener> listenerList = new ArrayList<FileListener>();
        ArrayList<FileEvent> eventList = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            String filename = event.getFileName();
            String oldname = event.getOldFileName();
            int watcherCount = entry.watchers.size();
            for (int i = 0; i < watcherCount; ++i) {
                FileWatcher watcher = (FileWatcher)entry.watchers.get(i);
                String watchName = watcher.getFileName();
                int type = -1;
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!filename.equals(watchName)) break;
                        type = eventType;
                        break;
                    }
                    case 4: {
                        if (filename.equals(watchName)) {
                            type = 1;
                            break;
                        }
                        if (!oldname.equals(watchName)) break;
                        type = 2;
                    }
                }
                if (type == -1) continue;
                FileWatcher fileWatcher = watcher;
                fileWatcher.getClass();
                FileEvent fileEvent = fileWatcher.new FileEvent(type);
                FileListener listener = watcher._listener;
                eventList.add(fileEvent);
                listenerList.add(listener);
            }
        }
        int numEvents = listenerList.size();
        for (int i = 0; i < numEvents; ++i) {
            FileListener listener = (FileListener)listenerList.get(i);
            FileEvent fileEvent = (FileEvent)eventList.get(i);
            if (listener == null || fileEvent == null) continue;
            try {
                listener.fileUpdate(fileEvent);
                continue;
            }
            catch (RuntimeException e) {
                Assert.println((String)("Warning: client exception: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(WatchEntry entry, DirectoryWatcher.DirectoryEvent event) {
        ArrayList<FileListener> listenerList = new ArrayList<FileListener>();
        ArrayList<FileEvent> eventList = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            int watcherCount = entry.watchers.size();
            for (int i = 0; i < watcherCount; ++i) {
                FileWatcher watcher = (FileWatcher)entry.watchers.get(i);
                watcher._active = false;
                FileWatcher fileWatcher = watcher;
                fileWatcher.getClass();
                FileEvent fileEvent = fileWatcher.new FileEvent(15);
                FileListener listener = watcher._listener;
                eventList.add(fileEvent);
                listenerList.add(listener);
            }
            _watchEntryList.remove(entry);
        }
        int numEvents = listenerList.size();
        for (int i = 0; i < numEvents; ++i) {
            FileListener listener = (FileListener)listenerList.get(i);
            FileEvent fileEvent = (FileEvent)eventList.get(i);
            if (listener == null || fileEvent == null) continue;
            try {
                listener.watchCancelled(fileEvent);
                continue;
            }
            catch (RuntimeException e) {
                Assert.println((String)("Warning: client exception: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private static class WatchEntry
    implements DirectoryWatcher.DirectoryListener {
        private List watchers;
        private URL rootURL;
        private DirectoryWatcher dirWatcher;

        private WatchEntry(List watchers, URL rootURL) {
            this.watchers = watchers;
            this.rootURL = rootURL;
        }

        @Override
        public void directoryUpdate(DirectoryWatcher.DirectoryEvent event) {
            FileWatcher.fireWatchEvent(this, event);
        }

        @Override
        public void watchCancelled(DirectoryWatcher.DirectoryEvent event) {
            FileWatcher.fireCancelledEvent(this, event);
        }
    }

    public static interface FileListener {
        public void fileUpdate(FileEvent var1);

        public void watchCancelled(FileEvent var1);
    }

    public class FileEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int WATCH_CANCELLED = 15;
        private int _type;

        private FileEvent(int type) {
            this._type = type;
        }

        public int getEventType() {
            return this._type;
        }

        public FileWatcher getFileWatcher() {
            return FileWatcher.this;
        }

        public URL getFileURL() {
            return this.getFileWatcher().getFileURL();
        }
    }
}

