/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public class DirectoryWatcher {
    private URL _rootURL;
    private boolean _recursive;
    private DirectoryListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = new int[0];
    private static List _watchEntryList = new ArrayList();
    private static boolean _watchThreadStarted = false;

    public static DirectoryWatcher createDirectoryWatcher(URL rootURL, DirectoryListener listener) {
        return DirectoryWatcher.createDirectoryWatcherImpl(rootURL, true, listener);
    }

    public static void destroyDirectoryWatcher(DirectoryWatcher watcher) {
        DirectoryWatcher.destroyDirectoryWatcherImpl(watcher);
    }

    private DirectoryWatcher(URL rootURL, boolean recursive, DirectoryListener listener) {
        this._rootURL = URLFactory.intern((URL)rootURL);
        this._recursive = recursive;
        this._listener = listener;
        this._active = true;
    }

    public URL getRootURL() {
        return this._rootURL;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String platformName = URLFileSystem.getPlatformPathName((URL)this.getRootURL());
        return "DW: " + platformName + " recurse(" + this._recursive + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryWatcher createDirectoryWatcherImpl(URL rootURL, boolean recursive, DirectoryListener listener) {
        if (!NativeHandler.isLoaded()) {
            return null;
        }
        if (rootURL == null) {
            return null;
        }
        if (!"file".equals(rootURL.getProtocol())) {
            return null;
        }
        DirectoryWatcher.startWatchThread();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(rootURL, recursive);
            if (entry == null) {
                String platformName = URLFileSystem.getPlatformPathName((URL)rootURL);
                int cookie = NativeHandler.startDirectoryWatch(platformName, recursive);
                if (cookie == -1) {
                    return null;
                }
                entry = new WatchEntry(new ArrayList(), rootURL, cookie, recursive);
                _watchEntryList.add(entry);
            }
            DirectoryWatcher watcher = new DirectoryWatcher(rootURL, recursive, listener);
            entry.watchers.add(watcher);
            return watcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyDirectoryWatcherImpl(DirectoryWatcher watcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            watcher._active = false;
            WatchEntry entry = DirectoryWatcher.findWatchEntry(watcher._rootURL, watcher._recursive);
            if (entry != null) {
                entry.watchers.remove(watcher);
                if (entry.watchers.size() == 0) {
                    _watchEntryList.remove(entry);
                    String platformName = URLFileSystem.getPlatformPathName((URL)entry.rootURL);
                    NativeHandler.stopDirectoryWatch(platformName, entry.cookie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startWatchThread() {
        Object object = WATCH_LOCK;
        synchronized (object) {
            if (!_watchThreadStarted) {
                NativeHandler.startWatcherThread(new WatchEventRedirector());
                _watchThreadStarted = true;
            }
        }
    }

    private static WatchEntry findWatchEntry(int cookie) {
        int size = _watchEntryList.size();
        for (int i = 0; i < size; ++i) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry == null || entry.cookie != cookie) continue;
            return entry;
        }
        return null;
    }

    private static WatchEntry findWatchEntry(URL rootURL, boolean recursive) {
        int size = _watchEntryList.size();
        for (int i = 0; i < size; ++i) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry == null || entry.recursive != recursive || !entry.rootURL.equals(rootURL)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(int cookie, int action, String filename) {
        ArrayList<DirectoryListener> listenerList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> eventList = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(cookie);
            if (entry == null) {
                Assert.println((String)("Warning: DirWatcher ignoring: " + filename + "(" + action + ")"));
                return;
            }
            if (entry.oldFilenameForRename != null && action != 5) {
                Assert.println((String)("Warning: DirWatcher non-null old: " + entry.oldFilenameForRename));
            }
            int type = -1;
            String oldName = null;
            switch (action) {
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 4: {
                    entry.oldFilenameForRename = filename;
                    return;
                }
                case 5: {
                    type = 4;
                    oldName = entry.oldFilenameForRename;
                    entry.oldFilenameForRename = null;
                    if (oldName != null) break;
                    Assert.println((String)("Warning: DirWatcher null old, skipping new: " + filename));
                    return;
                }
            }
            if (type == -1) {
                Assert.println((String)("Warning: DirWatcher unknown action(" + action + "): " + filename));
                return;
            }
            int watcherCount = entry.watchers.size();
            for (int i = 0; i < watcherCount; ++i) {
                DirectoryWatcher watcher;
                DirectoryWatcher directoryWatcher = watcher = (DirectoryWatcher)entry.watchers.get(i);
                directoryWatcher.getClass();
                DirectoryEvent event = directoryWatcher.new DirectoryEvent(type, filename);
                event.setOldFileName(oldName);
                DirectoryListener listener = watcher._listener;
                eventList.add(event);
                listenerList.add(listener);
            }
        }
        int numEvents = listenerList.size();
        for (int i = 0; i < numEvents; ++i) {
            DirectoryListener listener = (DirectoryListener)listenerList.get(i);
            DirectoryEvent event = (DirectoryEvent)eventList.get(i);
            if (listener == null || event == null) continue;
            try {
                listener.directoryUpdate(event);
                continue;
            }
            catch (RuntimeException e) {
                Assert.println((String)("Warning: client exception: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(int cookie) {
        ArrayList<DirectoryListener> listenerList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> eventList = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(cookie);
            if (entry == null) {
                Assert.println((String)("Warning: DirWatcher ignoring end cookie: " + cookie));
                return;
            }
            int watcherCount = entry.watchers.size();
            for (int i = 0; i < watcherCount; ++i) {
                DirectoryWatcher watcher = (DirectoryWatcher)entry.watchers.get(i);
                watcher._active = false;
                DirectoryWatcher directoryWatcher = watcher;
                directoryWatcher.getClass();
                DirectoryEvent event = directoryWatcher.new DirectoryEvent(15);
                DirectoryListener listener = watcher._listener;
                eventList.add(event);
                listenerList.add(listener);
            }
            _watchEntryList.remove(entry);
        }
        int numEvents = listenerList.size();
        for (int i = 0; i < numEvents; ++i) {
            DirectoryListener listener = (DirectoryListener)listenerList.get(i);
            DirectoryEvent event = (DirectoryEvent)eventList.get(i);
            if (listener == null || event == null) continue;
            try {
                listener.watchCancelled(event);
                continue;
            }
            catch (RuntimeException e) {
                Assert.println((String)("Warning: client exception: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private static class WatchEntry {
        private List watchers;
        private URL rootURL;
        private int cookie;
        private boolean recursive;
        private String oldFilenameForRename = null;

        private WatchEntry(List watchers, URL rootURL, int cookie, boolean recursive) {
            this.watchers = watchers;
            this.rootURL = rootURL;
            this.cookie = cookie;
            this.recursive = recursive;
        }
    }

    private static class WatchEventRedirector
    implements NativeHandler.WatchListener {
        private WatchEventRedirector() {
        }

        @Override
        public void notifyWatchEvent(int cookie, int action, String filename) {
            DirectoryWatcher.fireWatchEvent(cookie, action, filename);
        }

        @Override
        public void notifyWatchEnded(int cookie) {
            DirectoryWatcher.fireCancelledEvent(cookie);
        }
    }

    public static interface DirectoryListener {
        public void directoryUpdate(DirectoryEvent var1);

        public void watchCancelled(DirectoryEvent var1);
    }

    public class DirectoryEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int FILE_RENAMED = 4;
        public static final int WATCH_CANCELLED = 15;
        private String _filename;
        private int _type;
        private String _oldname;

        private DirectoryEvent(int type) {
            this._filename = null;
            this._oldname = null;
            this._type = type;
        }

        private DirectoryEvent(int type, String filename) {
            this._filename = filename;
            this._oldname = null;
            this._type = type;
        }

        private void setOldFileName(String oldname) {
            this._oldname = oldname;
        }

        public int getEventType() {
            return this._type;
        }

        public String getFileName() {
            return this._filename;
        }

        public String getOldFileName() {
            return this._oldname;
        }

        public DirectoryWatcher getDirectoryWatcher() {
            return DirectoryWatcher.this;
        }

        public URL getRootURL() {
            return this.getDirectoryWatcher().getRootURL();
        }
    }
}

