/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.DataContainer;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesMDDPanel;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.Namespace;
import oracle.ideimpl.model.SharedPropertiesManagerImpl;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.ModelUtil;

public final class PropertiesDialog {
    private final String _internalKey;
    private final CopyOnWriteArrayList<Navigable> _rootNavigables = new CopyOnWriteArrayList();
    private String[] _oldPath = null;
    private boolean _loadedExtensionPages;
    private String _objectLabel;
    private static final HashMap _dialogs = new HashMap();

    private PropertiesDialog(String internalKey) {
        this._internalKey = internalKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PropertiesDialog getInstance(String internalKey) {
        HashMap hashMap = _dialogs;
        synchronized (hashMap) {
            Object obj = _dialogs.get(internalKey);
            if (obj == null) {
                obj = new PropertiesDialog(internalKey);
                _dialogs.put(internalKey, obj);
            }
            return (PropertiesDialog)obj;
        }
    }

    final void addPanel(Navigable navigable) {
        if (navigable != null && !this._rootNavigables.contains(navigable)) {
            this._rootNavigables.add(navigable);
        }
    }

    public final boolean hasPanel() {
        this.getRootNavigables();
        return !this._rootNavigables.isEmpty();
    }

    public final void showDialog(HashStructureNode node) {
        this.showDialog(null, (Frame)((Object)Ide.getMainWindow()), node, null);
    }

    public final void showDialog(Context context, HashStructureNode node) {
        this.showDialog(context, (Frame)((Object)Ide.getMainWindow()), node, false, null);
    }

    public final void showDialog(Frame parent, HashStructureNode node, String[] selectionPath) {
        IllegalStateException e = new IllegalStateException("Call to deprecated PropertiesDialog.showDialog() should be fixed.");
        e.fillInStackTrace();
        FeedbackManager.reportException(e);
        Context lavContext = Ide.getLastActiveNavigator().getContext();
        this.showDialog(lavContext, parent, node, false, selectionPath);
    }

    public final void showDialog(Context context, Frame parent, HashStructureNode node, String[] selectionPath) {
        if (context == null) {
            context = Context.newIdeContext(node);
        }
        this.showDialog(context, parent, node, false, selectionPath);
    }

    private void showDialog(Context context, Frame parent, HashStructureNode node, boolean useDetailTree, String[] selectionPath) {
        MDDPanel panel;
        if (node == null || node.getUserPropertiesOnly() == null) {
            return;
        }
        parent.setCursor(Cursor.getPredefinedCursor(3));
        boolean isDefault = node.isDefault();
        node.ensureOpen();
        HashStructureNode nodeCopy = (HashStructureNode)node.copyTo(null);
        HashStructureNode unmodifiedNodeCopy = (HashStructureNode)node.copyTo(null);
        ChangeBuffer nodeChangeBuffer = new ChangeBuffer();
        nodeCopy.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)nodeChangeBuffer);
        ChangeBuffer userChangeBuffer = new ChangeBuffer();
        HashStructure nodeCopyUserPropertiesOnly = PropertiesDialog.getUserPropertiesOnlyBug14698512(node, nodeCopy);
        nodeCopyUserPropertiesOnly.addStructureChangeListener((StructureChangeListener)userChangeBuffer);
        Workspace workspace = null;
        DataContainer workspaceCopy = null;
        Workspace unmodifiedWorkspaceCopy = null;
        if (!isDefault && "Project".equals(this._internalKey) && node instanceof Project && (workspace = ((Project)node).getWorkspace()) != null) {
            workspace.ensureOpen();
            workspaceCopy = (Workspace)workspace.copyTo(null);
            unmodifiedWorkspaceCopy = (Workspace)workspace.copyTo(null);
        }
        ChangeBuffer workspaceChangeBuffer = new ChangeBuffer();
        if (workspaceCopy != null) {
            workspaceCopy.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)workspaceChangeBuffer);
        }
        Namespace data = new Namespace();
        data.put(Context.class.getName(), (Object)context);
        data.put(this._internalKey, (Object)nodeCopy);
        ProjectSettingsTraversablePanel.storeIsDefaultProject(data, isDefault);
        ProjectSettingsTraversablePanel.storeSharedProperties(data, nodeCopy.getSharedPropertiesOnly());
        ProjectSettingsTraversablePanel.storeChainedPropertiesData(data, nodeCopy.getProperties());
        ProjectSettingsTraversablePanel.storeUserPrivatePropertiesData(data, nodeCopyUserPropertiesOnly);
        Navigable[] rootNavigables = this.getRootNavigables();
        if (isDefault) {
            rootNavigables = this.getRootNavigables(false);
            panel = new MDDPanel(rootNavigables, useDetailTree);
            panel.setChildComparator((Comparator)new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        } else {
            Namespace customData = new Namespace();
            customData.put(this._internalKey, (Object)nodeCopy);
            customData.put(Context.class.getName(), (Object)context);
            ProjectSettingsTraversablePanel.storeIsDefaultProject(customData, isDefault);
            ProjectSettingsTraversablePanel.storeSharedProperties(customData, nodeCopy.getPropertiesForOverriding());
            ProjectSettingsTraversablePanel.storeChainedPropertiesData(customData, nodeCopy.getProperties());
            if (workspaceCopy != null) {
                ProjectSettingsTraversablePanel.storeWorkspaceLevelProperties(customData, ((SharedPropertiesManagerImpl)SharedPropertiesManager.get()).getWorkspaceLevelProjectProperties((Workspace)workspaceCopy));
                ProjectSettingsTraversablePanel.storeProjectsOwningWorkspace(data, (Workspace)workspaceCopy);
            }
            panel = new ProjectPropertiesMDDPanel(rootNavigables, useDetailTree, customData, this._objectLabel);
            panel.setChildComparator((Comparator)new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        }
        panel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
        panel.setTitleDepth(2);
        String title = ProjectPropertiesArb.format(5, this._objectLabel, node.getLongLabel());
        if (isDefault) {
            title = ProjectPropertiesArb.format(6, this._objectLabel);
        }
        SizeKeeperCallback skc = new SizeKeeperCallback(this._internalKey + ".settings");
        TDialogLauncher launcher = new TDialogLauncher((Component)parent, title, (Traversable)panel, data, (DialogRunnerCallback)skc);
        if (selectionPath != null) {
            panel.setTree1SelectionPath(selectionPath);
        } else if (this._oldPath != null) {
            panel.setTree1SelectionPath(this._oldPath);
        }
        parent.setCursor(Cursor.getDefaultCursor());
        boolean okSelected = launcher.showDialog();
        nodeCopy.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)nodeChangeBuffer);
        nodeCopyUserPropertiesOnly.removeStructureChangeListener((StructureChangeListener)userChangeBuffer);
        if (workspaceCopy != null) {
            workspaceCopy.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)workspaceChangeBuffer);
        }
        launcher.dispose();
        this._oldPath = panel.getTree1SelectionPath();
        if (okSelected) {
            this.maybeApplyProjectNodeChanges(node, isDefault, nodeCopy, unmodifiedNodeCopy, nodeChangeBuffer, userChangeBuffer);
            this.maybeApplyWorkspaceChanges(workspace, (HashStructureNode)workspaceCopy, unmodifiedWorkspaceCopy, workspaceChangeBuffer);
        }
        this.closeNode(nodeCopy);
        this.closeNode((HashStructureNode)workspaceCopy);
    }

    private void closeNode(HashStructureNode node) {
        if (node != null) {
            try {
                node.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void maybeApplyProjectNodeChanges(final HashStructureNode node, boolean isDefault, HashStructureNode nodeCopy, HashStructureNode unmodifiedNode, final ChangeBuffer nodeChangeBuffer, final ChangeBuffer userChangeBuffer) {
        if (ModelUtil.areDifferent((Object)unmodifiedNode, (Object)nodeCopy)) {
            node.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    node.ensureOpen();
                    node.getSharedPropertiesOnly().applyChanges(nodeChangeBuffer.getChanges());
                    node.getUserPropertiesOnly().applyChanges(userChangeBuffer.getChanges());
                }
            });
            try {
                node.saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (isDefault) {
                try {
                    node.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void maybeApplyWorkspaceChanges(final Workspace workspace, HashStructureNode workspaceCopy, HashStructureNode unmodifiedWorkspaceCopy, final ChangeBuffer workspaceChangeBuffer) {
        if (workspace != null && ModelUtil.areDifferent((Object)workspaceCopy, (Object)unmodifiedWorkspaceCopy)) {
            workspace.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    workspace.ensureOpen();
                    workspace.getSharedPropertiesOnly().applyChanges(workspaceChangeBuffer.getChanges());
                }
            });
        }
    }

    private Navigable[] getRootNavigables(boolean includeInDefault) {
        if (!this._loadedExtensionPages) {
            this._loadedExtensionPages = true;
            Collection<Navigable> extensionNavigables = SettingsUIRegistry.getExtensionNavigables(this._internalKey);
            for (Navigable n : extensionNavigables) {
                this.addPanel(n);
            }
            this._objectLabel = SettingsUIRegistry.getObjectLabel(this._internalKey);
        }
        ArrayList<Navigable> list = new ArrayList<Navigable>();
        for (Navigable n : this._rootNavigables) {
            boolean include = true;
            if (!includeInDefault && !n.includeInDefault()) {
                include = false;
            }
            if (!include) continue;
            list.add(n);
        }
        return list.toArray(new Navigable[list.size()]);
    }

    private Navigable[] getRootNavigables() {
        return this.getRootNavigables(true);
    }

    private static HashStructure getUserPropertiesOnlyBug14698512(HashStructureNode originalNode, HashStructureNode nodeCopy) {
        HashStructure userPropertiesOnly = nodeCopy.getUserPropertiesOnly();
        assert (userPropertiesOnly != null) : PropertiesDialog.loggingInfoForBug14698512(originalNode, nodeCopy);
        if (userPropertiesOnly == null) {
            Logger.getLogger(PropertiesDialog.class.getName()).warning(PropertiesDialog.loggingInfoForBug14698512(originalNode, nodeCopy));
        }
        return userPropertiesOnly != null ? userPropertiesOnly : HashStructure.newInstance();
    }

    private static String loggingInfoForBug14698512(HashStructureNode ... nodes) {
        StringBuilder sb = new StringBuilder("Bug #14698512");
        String format = "%s[%s]";
        HashMap<String, HashStructure> objects2Log = new HashMap<String, HashStructure>();
        for (HashStructureNode nextNode : nodes) {
            String key = String.format("%s[%s]", nextNode.getShortLabel(), System.identityHashCode(nextNode));
            objects2Log.put(key, nextNode.getUserPropertiesOnly());
        }
        for (Map.Entry entry : objects2Log.entrySet()) {
            String description = (String)entry.getKey();
            String instanceAsText = entry.getValue() != null ? entry.getValue().toString() : null;
            sb.append(", ").append(String.format("%s = %s", description, instanceAsText));
        }
        String loggingInfo = sb.toString();
        return loggingInfo;
    }
}

