/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.zip.CRC32;
import oracle.ide.ExtensionRegistry;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXParseException;

final class UserProperties
implements PropertyStorage,
Copyable {
    static final String INDEX_FILE_NAME = "index2.xml";
    static final String PROJECTS_FOLDER_NAME = "projects";
    static final String USER_PROPERTIES_KEY = "user";
    static final String DATA_KEY = "index";
    private HashStructure _hash;
    private URL _userStorageURL;
    private final URL _sharedStorageURL;
    private final String _namespaceURI;
    private final String _rootQName;

    UserProperties(URL sharedStorageURL, String namespaceURI, String rootQName) {
        if (sharedStorageURL == null) {
            throw new IllegalArgumentException();
        }
        this._sharedStorageURL = sharedStorageURL;
        this._namespaceURI = namespaceURI;
        this._rootQName = rootQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws IOException {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash != null && this._hash.isDirty()) {
                ObjectStore io = this.getIO();
                io.save(this.getOrCreateUserStorageURL(), (Object)this._hash);
                Index.getInstance().commit(this._sharedStorageURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashStructure getProperties() {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash == null) {
                try {
                    URL userStorageURL = this.getUserStorageURL();
                    if (userStorageURL != null && URLFileSystem.exists((URL)userStorageURL) && URLFileSystem.exists((URL)this._sharedStorageURL)) {
                        ObjectStore io = this.getIO();
                        this._hash = (HashStructure)io.load(userStorageURL);
                        return this._hash;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this._hash = HashStructure.newInstance();
            }
            return this._hash;
        }
    }

    public Object copyTo(Object target) {
        UserProperties copy = target != null ? (UserProperties)target : new UserProperties(this._sharedStorageURL, this._namespaceURI, this._rootQName);
        this.copyToImpl(copy);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyToImpl(UserProperties copy) {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            UserProperties userProperties2 = copy;
            synchronized (userProperties2) {
                if (this._hash != null) {
                    if (copy._hash != null) {
                        this._hash.copyTo(copy._hash);
                    } else {
                        copy._hash = this._hash.copyTo(null);
                    }
                } else {
                    copy._hash = null;
                }
                copy._userStorageURL = this._userStorageURL;
            }
        }
    }

    protected final ObjectStore getIO() {
        return new HashStructureIO(this._namespaceURI, this._rootQName);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((UserProperties)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean equalsImpl(UserProperties other) {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            UserProperties userProperties2 = other;
            synchronized (userProperties2) {
                return URLFileSystem.equals((URL)this._sharedStorageURL, (URL)other._sharedStorageURL) && URLFileSystem.equals((URL)this._userStorageURL, (URL)other._userStorageURL) && ModelUtil.areEqual((Object)this._hash, (Object)other._hash);
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    private URL getUserStorageURL() throws IOException {
        if (this._userStorageURL == null) {
            this._userStorageURL = Index.getInstance().getUserStorageURL(this._sharedStorageURL);
        }
        return this._userStorageURL;
    }

    private URL getOrCreateUserStorageURL() throws IOException {
        if (this._userStorageURL == null) {
            this._userStorageURL = Index.getInstance().getOrCreateUserStorageURL(this._sharedStorageURL);
        }
        return this._userStorageURL;
    }

    private static class Index {
        private static Index _instance;
        private final HashStructure _hash;
        private volatile File _projectsDir;

        private Index() throws IOException {
            File indexFile = new File(this.projectsDir(), UserProperties.INDEX_FILE_NAME);
            if (!indexFile.exists()) {
                this.convertOldIndex();
            }
            if (indexFile.exists()) {
                HashStructure h = null;
                try {
                    h = (HashStructure)new HashStructureIO(null, null).load(URLFactory.newFileURL((File)indexFile));
                }
                catch (IOException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof SAXParseException) {
                        h = HashStructure.newInstance();
                    }
                    throw ex;
                }
                this._hash = h;
            } else {
                this._hash = HashStructure.newInstance();
            }
            ExitCommand.addShutdownHook(new ShutdownHook(){

                @Override
                public void shutdown() {
                    try {
                        this.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean canShutdown() {
                    return true;
                }
            });
        }

        static synchronized Index getInstance() throws IOException {
            if (_instance == null) {
                _instance = new Index();
            }
            return _instance;
        }

        private String encode(URL key) {
            return URLEncoder.encode(key.getPath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File projectsDir() {
            File file = this._projectsDir;
            if (file == null) {
                Index index = this;
                synchronized (index) {
                    file = this._projectsDir;
                    if (file == null) {
                        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                        URL url = er.getSystemDirectory("oracle.ide");
                        file = new File(url.getPath(), UserProperties.PROJECTS_FOLDER_NAME);
                        file.mkdirs();
                        this._projectsDir = file;
                    }
                }
            }
            return file;
        }

        private void convertOldIndex() throws IOException {
            File projectsDir = this.projectsDir();
            File oldIndex = new File(projectsDir, "index.xml");
            if (!oldIndex.exists()) {
                return;
            }
            ListStructureIO listIO = new ListStructureIO(null, null);
            ListStructure list = (ListStructure)listIO.load(URLFactory.newFileURL((File)oldIndex));
            HashStructure hsNew = HashStructure.newInstance();
            for (Object o : list) {
                HashStructure h = (HashStructure)o;
                String user = h.getString(UserProperties.USER_PROPERTIES_KEY);
                if (!new File(projectsDir, user).exists()) continue;
                URL shared = h.getURL("shared");
                HashStructure hs = HashStructure.newInstance();
                hs.putString(UserProperties.USER_PROPERTIES_KEY, user);
                hsNew.putHashStructure(this.encode(shared), hs);
            }
            this.save(hsNew);
            oldIndex.delete();
        }

        private void save(HashStructure hsNew) throws IOException {
            File newIndex = new File(this.projectsDir(), UserProperties.INDEX_FILE_NAME);
            new HashStructureIO(null, UserProperties.DATA_KEY).save(URLFactory.newFileURL((File)newIndex), (Object)hsNew);
            hsNew.markDirty(false);
        }

        private String generateUserStorageName(URL shared) {
            String checksum = Index.checksum(shared.getPath());
            String name = URLFileSystem.getName((URL)shared) + checksum + URLFileSystem.getSuffix((URL)shared);
            int index = 0;
            while (new File(this.projectsDir(), name).exists()) {
                name = URLFileSystem.getName((URL)shared) + checksum + String.valueOf(index) + URLFileSystem.getSuffix((URL)shared);
                ++index;
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL getUserStorageURL(URL sharedStorageURL) {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                String encoded = this.encode(sharedStorageURL);
                HashStructure result = this._hash.getHashStructure(encoded);
                if (result != null) {
                    String user = result.getString(UserProperties.USER_PROPERTIES_KEY);
                    return URLFactory.newFileURL((String)new File(this.projectsDir(), user).getAbsolutePath());
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL getOrCreateUserStorageURL(URL sharedStorageURL) {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                String encoded = this.encode(sharedStorageURL);
                HashStructure result = this._hash.getHashStructure(encoded);
                if (result == null) {
                    result = HashStructure.newInstance();
                    result.putBoolean("committed", false);
                    result.putString(UserProperties.USER_PROPERTIES_KEY, this.generateUserStorageName(sharedStorageURL));
                    this._hash.putHashStructure(encoded, result);
                }
                String user = result.getString(UserProperties.USER_PROPERTIES_KEY);
                return URLFactory.newFileURL((String)new File(this.projectsDir(), user).getAbsolutePath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit(URL sharedStorageURL) {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                HashStructure result = this._hash.getHashStructure(this.encode(sharedStorageURL));
                assert (result != null);
                result.remove("committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() throws IOException {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                if (!this._hash.isDirty()) {
                    return;
                }
                ArrayList<String> keysToRemove = new ArrayList<String>();
                for (String key : this._hash.keySet()) {
                    HashStructure hs = this._hash.getHashStructure(key);
                    if (hs.getBoolean("committed", true)) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    this._hash.remove(key);
                }
                this.save(this._hash);
            }
        }

        private static String checksum(String filename) {
            CRC32 crc = new CRC32();
            crc.update(filename.getBytes());
            return Long.toString(crc.getValue(), 16);
        }
    }
}

